/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define.validation.rules;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.JoinType;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SplitType;
import com.kingdee.bos.workflow.define.validation.Priority;
import com.kingdee.bos.workflow.define.validation.ProcessRule;
import com.kingdee.bos.workflow.define.validation.ResultInfo;
import com.kingdee.bos.workflow.define.validation.ResultType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XorTypeTransitionShouldConjugated
extends ProcessRule {
    private List results;

    @Override
    public List processCheck(ProcessDef process) {
        this.results = new ArrayList();
        ProcessDef destProcess = process.cloneProcess();
        int count = 0;
        try {
            destProcess = KpdlParser.toPerfectModelProcess(destProcess);
            Iterator activities = destProcess.getActivitys().iterator();
            while (activities.hasNext()) {
                ActivityDef activity = (ActivityDef)activities.next();
                if (activity.getActivityHeader().getSplitType() == SplitType.XOR && !activity.getOutgoingTransitions().isEmpty()) {
                    count += activity.getOutgoingTransitions().size();
                }
                if (activity.getActivityHeader().getJoinType() != JoinType.XOR || activity.getIncomingTransitions().isEmpty()) continue;
                count -= activity.getIncomingTransitions().size();
            }
        }
        catch (WfException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
        if (count != 0) {
            this.results.add(new ResultInfo(this, ResultType.WARNING, "Xor\u7c7b\u578b\u5f97\u8fde\u63a5\u5f27\u53ef\u80fd\u4e0d\u662f\u6210\u5bf9\u7684.", "Xor\u7c7b\u578b\u5f97\u8fde\u63a5\u5f27\u53ef\u80fd\u4e0d\u662f\u6210\u5bf9\u7684.\u8fde\u63a5\u5f27Xor\u6570\u503c\u4e3a[" + count + "].", "Xor\u7c7b\u578b\u5f97\u8fde\u63a5\u5f27\u5e94\u8be5\u662f\u6210\u5bf9\u7684", ""));
        }
        return this.results;
    }

    @Override
    public String getDescription() {
        return "Xor\u7c7b\u578b\u5f97\u8fde\u63a5\u5f27\u5e94\u8be5\u662f\u6210\u5bf9\u7684";
    }

    @Override
    public boolean getIsMainRule() {
        return true;
    }

    @Override
    public String getLongDescription() {
        return "";
    }

    @Override
    public String getName() {
        return "Xor\u7c7b\u578b\u5f97\u8fde\u63a5\u5f27\u5e94\u8be5\u662f\u6210\u5bf9\u7684";
    }

    @Override
    public Priority getPriority() {
        return Priority.P1;
    }

    @Override
    public String getRuleName() {
        return this.getClass().getName();
    }
}

