/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.dynui;

import com.kingdee.bos.workflow.dynui.DynUIResource;
import com.kingdee.bos.workflow.dynui.DynUIResourceCollection;
import com.kingdee.bos.workflow.dynui.IDynUIElement;
import java.util.Locale;

public abstract class AbstractDynUIElement
implements IDynUIElement {
    protected DynUIResourceCollection resources = new DynUIResourceCollection();
    protected Locale locale = null;
    protected IDynUIElement container = null;

    public IDynUIElement getContainer() {
        return this.container;
    }

    @Override
    public abstract String getId();

    @Override
    public Locale getLocale() {
        if (this.getContainer() != null) {
            return this.container.getLocale();
        }
        return this.locale;
    }

    public DynUIResource getResource(String key) {
        if (this.resources != null && this.resources.containsKey(key)) {
            return this.resources.getDynUIResource(key);
        }
        return null;
    }

    public String getResourceValue(String key) {
        return this.getResourceValue(key, this.getLocale());
    }

    public String getResourceValue(String key, Locale locale) {
        String value = null;
        DynUIResource resource = this.getResource(key);
        if (resource != null) {
            value = resource.getValue(locale);
        }
        return value;
    }

    public void setContainer(AbstractDynUIElement element) {
        this.container = element;
    }

    public void setLocale(Locale destLocale) {
        if (destLocale == null) {
            throw new IllegalArgumentException();
        }
        this.locale = destLocale;
    }

    public void setResource(String key, DynUIResource resource) {
        if (key == null || resource == null) {
            throw new IllegalArgumentException();
        }
        this.resources.set(key, resource);
    }

    public void setResource(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException();
        }
        DynUIResource resource = this.getResource(key);
        if (resource != null) {
            resource.setValue(this.getLocale(), value);
        } else {
            resource = new DynUIResource();
            resource.setKey(key);
            resource.setValue(this.getLocale(), value);
            this.resources.set(key, resource);
        }
    }

    public void setResource(String key, String value, Locale locale) {
        if (key == null || value == null || locale == null) {
            throw new IllegalArgumentException();
        }
        DynUIResource resource = this.getResource(key);
        if (resource != null) {
            resource.setValue(locale, value);
        } else {
            resource = new DynUIResource();
            resource.setKey(key);
            resource.setValue(locale, value);
            this.resources.set(key, resource);
        }
    }
}

