/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.emluator.engine;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.emluator.engine.IMethodInvoker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DefaultMethodInvoker
extends AbstractBOSObject
implements IMethodInvoker {
    public DefaultMethodInvoker() {
        super.registerInterface(IMethodInvoker.class, (Object)this);
    }

    public DefaultMethodInvoker(Context ctx) {
        super(ctx);
        super.registerInterface(IMethodInvoker.class, (Object)this);
    }

    @Override
    public Object invoke(BOSObjectType bosType, String methodName, Object[] args) throws BOSException {
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)bosType);
        Class[] argTypes = this.getArgTypes(args);
        try {
            Method[] methods = obj.getClass().getMethods();
            Method selectedMethod = null;
            for (Method method : methods) {
                Class<?>[] paramsTypes;
                if (!method.getName().equals(methodName) || (paramsTypes = method.getParameterTypes()).length != argTypes.length) continue;
                boolean fit = true;
                int m = argTypes.length;
                for (int j = 0; j < m; ++j) {
                    if (argTypes[j].equals(paramsTypes[j]) || paramsTypes[j].isAssignableFrom(argTypes[j])) continue;
                    fit = false;
                }
                if (!fit) continue;
                selectedMethod = method;
                break;
            }
            if (selectedMethod != null) {
                Object o = selectedMethod.invoke((Object)obj, args);
                return o;
            }
            throw new BOSException("no such method");
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof BOSException) {
                throw (BOSException)t;
            }
            throw new BOSException((Throwable)e);
        }
    }

    private Class[] getArgTypes(Object[] args) {
        Class[] cs = new Class[args.length];
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            cs[i] = args[i].getClass();
        }
        return cs;
    }

    public BOSObjectType getType() {
        return BOSObjectType.create((String)"MEIN");
    }
}

