/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.emluator.engine;

import com.kingdee.bos.workflow.emluator.def.ProcessTestMetaDef;
import com.kingdee.bos.workflow.emluator.engine.EmluationResult;
import com.kingdee.bos.workflow.emluator.engine.EmluationRunner;

public class EmluationDirector {
    private ProcessTestMetaDef procTestMetaDef;

    public EmluationDirector(ProcessTestMetaDef metaDef) {
        this.procTestMetaDef = metaDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmluationResult[] startEmluation() {
        boolean isLoop = this.procTestMetaDef.getOptionInfo().isLoop();
        boolean isMultiThread = this.procTestMetaDef.getOptionInfo().isMultiThread();
        int size = isLoop ? this.procTestMetaDef.getOptionInfo().getLoopSize() : 1;
        EmluationResult[] results = null;
        for (int index = 0; index < size; ++index) {
            if (isMultiThread) {
                int i;
                int threadNum = this.procTestMetaDef.getOptionInfo().getThreadNumber();
                Object[] locks = new Object[threadNum];
                for (i = 0; i < threadNum; ++i) {
                    locks[i] = new Object();
                    RunnerThread t = new RunnerThread(locks[i]);
                    t.start();
                }
                for (i = 0; i < threadNum; ++i) {
                    Object object = locks[i];
                    synchronized (object) {
                        continue;
                    }
                }
                continue;
            }
            EmluationResult r = this.runEmluation();
            results = this.appendContext(results, r);
        }
        return results;
    }

    private EmluationResult[] appendContext(EmluationResult[] results, EmluationResult r) {
        if (results == null) {
            results = new EmluationResult[]{};
        }
        EmluationResult[] c = new EmluationResult[results.length + 1];
        System.arraycopy(results, 0, c, 0, results.length);
        c[results.length] = r;
        return c;
    }

    private EmluationResult runEmluation() {
        EmluationRunner runner = new EmluationRunner(this.procTestMetaDef);
        runner.start();
        return runner.getEmluationResult();
    }

    private class RunnerThread
    extends Thread {
        private Object lock;

        public RunnerThread(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                EmluationDirector.this.runEmluation();
            }
        }
    }
}

