/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.emluator.engine;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.emluator.engine.AbstractExecutable;
import com.kingdee.bos.workflow.emluator.engine.EmluationContext;
import com.kingdee.bos.workflow.emluator.engine.EmluationException;
import com.kingdee.bos.workflow.emluator.engine.IEmluationInvoker;
import com.kingdee.bos.workflow.emluator.engine.MethodResultInfo;
import com.kingdee.bos.workflow.emluator.engine.MultiApproveExecutorProxy;
import com.kingdee.bos.workflow.emluator.engine.SimpleAssignmentInfo;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EmluationInvoker
extends AbstractBOSObject
implements IEmluationInvoker {
    public EmluationInvoker() {
        super.registerInterface(IEmluationInvoker.class, (Object)this);
    }

    public EmluationInvoker(Context ctx) {
        super(ctx);
        super.registerInterface(IEmluationInvoker.class, (Object)this);
    }

    public BOSObjectType getType() {
        return BOSObjectType.create((String)"WFEM");
    }

    @Override
    public MethodResultInfo execute(String className, EmluationContext ctx, BOSObjectType type, String methodName) throws EmluationException {
        try {
            Class<?> c = Class.forName(className);
            AbstractExecutable executor = (AbstractExecutable)c.newInstance();
            executor.fillContext(ctx, type, methodName);
            Object o = executor.bizMethodInvoke();
            String[] pk = executor.getObjectPK();
            MethodResultInfo info = new MethodResultInfo();
            info.setBizObjectIds(pk);
            info.setReturnValue(o);
            try {
                executor.assertion();
            }
            catch (Exception ex) {
                throw new EmluationException(1002, StringUtils.stackToString((Exception)ex));
            }
            return info;
        }
        catch (ClassNotFoundException e) {
            throw new EmluationException(2002, "class com.kingdee.bos.workflow.emluator.engine.MultiApproveExecutor not found", e);
        }
        catch (InstantiationException e) {
            throw new EmluationException(2002, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new EmluationException(2002, e.getMessage(), e);
        }
        catch (EmluationException ex) {
            throw ex;
        }
    }

    @Override
    public MethodResultInfo executeApprove(String actDefId, EmluationContext ctx, String approveResult, int approveOption, String assignmentId) throws EmluationException {
        try {
            Class<?> c = Class.forName("com.kingdee.bos.workflow.emluator.engine.MultiApproveExecutorProxy");
            AbstractExecutable executor = (AbstractExecutable)c.newInstance();
            executor.fillContext(ctx, null, null);
            MultiApproveExecutorProxy exe = (MultiApproveExecutorProxy)executor;
            exe.setApproveResult(approveResult);
            exe.setApproveOption(approveOption);
            exe.setAssignmentId(assignmentId);
            Object o = exe.bizMethodInvoke();
            String[] pk = exe.getObjectPK();
            MethodResultInfo info = new MethodResultInfo();
            info.setBizObjectIds(pk);
            info.setReturnValue(o);
            try {
                executor.assertion();
            }
            catch (Exception ex) {
                throw new EmluationException(1002, StringUtils.stackToString((Exception)ex));
            }
            return info;
        }
        catch (ClassNotFoundException e) {
            throw new EmluationException(2002, "class com.kingdee.bos.workflow.emluator.engine.MultiApproveExecutor not found", e);
        }
        catch (InstantiationException e) {
            throw new EmluationException(2002, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new EmluationException(2002, e.getMessage(), e);
        }
        catch (EmluationException ex) {
            throw ex;
        }
    }

    @Override
    public SimpleAssignmentInfo[] checkAssignmentInfo(String pk, String procDefId) throws EmluationException {
        SimpleAssignmentInfo[] simpleAssignmentInfoArray;
        SimpleAssignmentInfo[] saInfos;
        String sql;
        ResultSet rs;
        PreparedStatement stmt;
        Connection cn;
        HashMap<String, SimpleAssignmentInfo> map;
        block18: {
            SimpleAssignmentInfo[] userId;
            String procInstId;
            block17: {
                map = new HashMap<String, SimpleAssignmentInfo>();
                procInstId = null;
                cn = null;
                stmt = null;
                rs = null;
                cn = EJBFactory.getConnection((Context)this.getContext());
                sql = "select p.fprocinstid ,p.fparentprocinstid from t_wfr_procinst p inner join t_wfr_procinstbizobj b on p.fprocinstid= b.fprocinstid where p.fstate not like 'close%' and b.fbizobjid=?";
                stmt = cn.prepareStatement(sql);
                stmt.setString(1, pk);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String parentProcInstId = rs.getString(2);
                    if (!StringUtils.isEmpty((String)parentProcInstId)) continue;
                    procInstId = rs.getString(1);
                    break;
                }
                if (!StringUtils.isEmpty(procInstId)) break block17;
                String state = "";
                sql = "SELECT A.FPROCINSTID , B.fparentprocinstid ,B.FSTATE FROM T_WFR_ASSIGN A INNER JOIN T_WFR_PROCINST B ON A.FPROCINSTID = B.FPROCINSTID WHERE A.FBIZOBJID=? AND  B.FSTATE LIKE 'close%'";
                stmt = cn.prepareStatement(sql);
                stmt.setString(1, pk);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String parentProcInstId = rs.getString(2);
                    if (!StringUtils.isEmpty((String)parentProcInstId)) continue;
                    procInstId = rs.getString(1);
                    state = rs.getString(3);
                    break;
                }
                SimpleAssignmentInfo saInfo = new SimpleAssignmentInfo();
                saInfo.setProcessInstState(state);
                saInfo.setProcessInstId(procInstId);
                saInfo.setBizObjId(pk);
                saInfo.setProcessDefId(procDefId);
                SimpleAssignmentInfo[] simpleAssignmentInfoArray2 = new SimpleAssignmentInfo[]{saInfo};
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
                return simpleAssignmentInfoArray2;
            }
            saInfos = null;
            sql = "SELECT FACTDEFID , FPERSONUSERID , FASSIGNID ,FPROCINSTID FROM T_WFR_ASSIGN WHERE FBIZOBJID=? AND FSTATE IN (1,2)";
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, pk);
            rs = stmt.executeQuery();
            boolean isSuspended = true;
            while (rs.next()) {
                SimpleAssignmentInfo saInfo;
                if (isSuspended) {
                    isSuspended = false;
                }
                String actDefId = rs.getString(1);
                userId = rs.getString(2);
                String assignmentId = rs.getString(3);
                String processInstId = rs.getString(4);
                if (!map.containsKey(actDefId)) {
                    saInfo = new SimpleAssignmentInfo();
                    saInfo.setProcessInstState(WfState.OPEN.getValue());
                    saInfo.setActivityDefId(actDefId);
                    saInfo.appendUserId((String)userId);
                    saInfo.appendAssignmentId(assignmentId);
                    saInfo.setBizObjId(pk);
                    saInfo.setProcessDefId(procDefId);
                    saInfo.setProcessInstId(processInstId);
                    map.put(actDefId, saInfo);
                    continue;
                }
                saInfo = (SimpleAssignmentInfo)map.get(actDefId);
                saInfo.appendUserId((String)userId);
                saInfo.appendAssignmentId(assignmentId);
            }
            if (!isSuspended) break block18;
            SimpleAssignmentInfo saInfo = new SimpleAssignmentInfo();
            saInfo.setProcessInstState(WfState.SUSPENDED.getValue());
            saInfo.setProcessInstId(procInstId);
            saInfo.setBizObjId(pk);
            saInfo.setProcessDefId(procDefId);
            userId = new SimpleAssignmentInfo[]{saInfo};
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
            return userId;
        }
        try {
            saInfos = new SimpleAssignmentInfo[map.size()];
            Iterator iter = map.entrySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object o = entry.getValue();
                if (!(o instanceof SimpleAssignmentInfo)) continue;
                saInfos[i] = (SimpleAssignmentInfo)o;
                ++i;
            }
            int n = saInfos.length;
            for (int i2 = 0; i2 < n; ++i2) {
                sql = "SELECT FPARENTPROCINSTID , FPARENTACTDEFID ,FPROCDEFID FROM T_WFR_PROCINST WHERE FPROCINSTID=? ";
                stmt = cn.prepareStatement(sql);
                stmt.setString(1, saInfos[i2].getProcessInstId());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    String parentProcInstId = rs.getString(1);
                    String parentActDefId = rs.getString(2);
                    if (!StringUtils.isEmpty((String)parentProcInstId)) {
                        saInfos[i2].setParentActivityDefId(parentActDefId);
                        saInfos[i2].setParentProcessInstId(parentProcInstId);
                        saInfos[i2].setSubFlow(true);
                    } else {
                        saInfos[i2].setSubFlow(false);
                    }
                } else {
                    throw new EmluationException("data is bad");
                }
                saInfos[i2].setProcessDefId(rs.getString(3));
            }
            simpleAssignmentInfoArray = saInfos;
        }
        catch (SQLException e) {
            try {
                throw new EmluationException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return simpleAssignmentInfoArray;
    }

    @Override
    public boolean isAllProcessComplete(String[] pks, String procDefId) throws EmluationException {
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean rtnValue = true;
        try {
            String sql = "select p.fstate from t_wfr_procinst p inner join t_wfr_procinstbizobj b on p.fprocinstid= b.fprocinstid where b.fbizobjid=? ";
            cn = EJBFactory.getConnection((Context)this.getContext());
            stmt = cn.prepareStatement(sql);
            int n = pks.length;
            for (int i = 0; i < n; ++i) {
                stmt.setString(1, pks[i]);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String state = rs.getString(1);
                    if (state.startsWith("closed")) continue;
                    rtnValue = false;
                }
            }
            if (!rtnValue) {
                boolean hasFinish = true;
                sql = "select p.fstate from t_wfr_procinst p inner join t_wfr_assign a on p.fprocinstid=a.fprocinstid where a.fbizobjid=? and a.fprocdefid=? and a.fstate in (1,2)";
                cn = EJBFactory.getConnection((Context)this.getContext());
                stmt = cn.prepareStatement(sql);
                int n2 = pks.length;
                for (int i = 0; i < n2; ++i) {
                    stmt.setString(1, pks[i]);
                    stmt.setString(2, procDefId);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String state = rs.getString(1);
                        if (state.startsWith("closed")) continue;
                        hasFinish = false;
                    }
                }
                rtnValue = hasFinish;
            }
        }
        catch (SQLException e) {
            try {
                throw new EmluationException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
        return rtnValue;
    }
}

