/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.emluator.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AcceptOption;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.emluator.def.ApproveSplitCollection;
import com.kingdee.bos.workflow.emluator.def.ApproveSplitInfo;
import com.kingdee.bos.workflow.emluator.def.MutexSplitCollection;
import com.kingdee.bos.workflow.emluator.def.MutexSplitInfo;
import com.kingdee.bos.workflow.emluator.def.ProcessTestMetaDef;
import com.kingdee.bos.workflow.emluator.def.SubFlowEmluationCollection;
import com.kingdee.bos.workflow.emluator.def.SubFlowEmluationInfo;
import com.kingdee.bos.workflow.emluator.engine.AssignmentCheckResultInfo;
import com.kingdee.bos.workflow.emluator.engine.EmluationContext;
import com.kingdee.bos.workflow.emluator.engine.EmluationException;
import com.kingdee.bos.workflow.emluator.engine.EmluationResult;
import com.kingdee.bos.workflow.emluator.engine.IEmluationHelper;
import com.kingdee.bos.workflow.emluator.engine.IEmluationInvoker;
import com.kingdee.bos.workflow.emluator.engine.MethodResultInfo;
import com.kingdee.bos.workflow.emluator.engine.SimpleAssignmentInfo;
import com.kingdee.bos.workflow.emluator.util.LoginUtil;
import com.kingdee.bos.workflow.emluator.util.ThreadUtil;
import com.kingdee.bos.workflow.emluator.util.WfModelUtil;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.wfdesigner.service.IWorkFlowDefineService;
import com.kingdee.bos.workflow.wfdesigner.service.LoginAgentException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EmluationRunner {
    public static final int BASIC_WAIT_TIME = 30000;
    public static final String CUR_ACTIVITYDEF_ID = "curActivityDefId";
    public static final String DEF_ACTIVITY_POST_RELATION = "curPostActivitys";
    private static final int CAN_CHECK_NEXT = 0;
    private static final int PROCESS_ALL_COMPLETE = 1;
    private static final int PROCESS_EXECUTE_EXCEPTION = 2;
    public static final int CHECKED_SUCESS = 1;
    public static final int CHECKED_ERROR = 2;
    public static final int CHECKING = 0;
    private ProcessTestMetaDef procTestMetaDef;
    EmluationContext context;
    private ProcessDef processDef;
    private Map postRelationMap;
    private final Object lock = new Object();
    private boolean isSubFlow;
    private int waitTimeCount = 0;

    public EmluationRunner(ProcessTestMetaDef metaDef) {
        this(metaDef, null, false, null);
    }

    public EmluationRunner(ProcessTestMetaDef metaDef, EmluationContext ctx, boolean isSubFlow, String startupActivityId) {
        this.procTestMetaDef = metaDef;
        this.isSubFlow = isSubFlow;
        if (ctx != null) {
            this.context = new EmluationContext();
            this.context.setBizObjectIds(ctx.getBizObjectIds());
            this.context.setAdminPass(ctx.getAdminPass());
            this.context.put(CUR_ACTIVITYDEF_ID, startupActivityId);
            this.context.setBizExterndMap(ctx.getBizExterndMap());
        }
    }

    public EmluationResult getEmluationResult() {
        return this.context.getEmluationResult();
    }

    public void start() {
        long start = System.currentTimeMillis();
        this.setUp();
        if (!this.isSubFlow) {
            this.context.fetchPath();
            this.startupOperation();
        }
        boolean needLoop = true;
        while (needLoop) {
            try {
                List list = this.context.getBizObjectIds();
                String[] pks = new String[list.size()];
                pks = list.toArray(pks);
                ThreadUtil.threadWait(list.size(), 30000L, this.lock);
                this.increaseWaitCount(list.size());
                this.login(this.context.getAdminUserName(), this.context.getAdminPass());
                boolean allProcInstCompleted = EmluationRunner.getInvoker(this.procTestMetaDef.getServerUrl()).isAllProcessComplete(pks, this.processDef.getID());
                if (!allProcInstCompleted) {
                    this.context.fetchPath();
                    int result = this.checkAssignment();
                    switch (result) {
                        case 0: {
                            needLoop = true;
                            break;
                        }
                        case 2: {
                            needLoop = false;
                            this.context.setSucess(false);
                            break;
                        }
                        case 1: {
                            needLoop = false;
                            this.context.setSucess(true);
                            break;
                        }
                        default: {
                            needLoop = true;
                            break;
                        }
                    }
                    continue;
                }
                needLoop = false;
                this.context.setSucess(true);
            }
            catch (Exception ex) {
                throw new EmluationException(ex);
            }
        }
        long end = System.currentTimeMillis();
        this.context.setExecuteTotalTimeSpan(end - start);
        this.context.setWaitCount(this.waitTimeCount);
    }

    private void increaseWaitCount(int delta) {
        this.waitTimeCount += delta;
    }

    private int checkAssignment() {
        int maxSize;
        int checkResult = 0;
        List list = this.context.getBizObjectIds();
        String[] pks = new String[list.size()];
        pks = list.toArray(pks);
        AssignmentCheckResultInfo resultInfo = new AssignmentCheckResultInfo(list.size());
        int n = maxSize = list.size() > 100 ? 500 : list.size() * 5;
        for (int count = 0; checkResult == 0 && count < maxSize; ++count) {
            ThreadUtil.threadWait(1, 30000L, this.lock);
            this.increaseWaitCount(1);
            resultInfo = this.checkAssignmentInfos(pks, this.procTestMetaDef.getServerUrl(), resultInfo);
            if (resultInfo.getCheckingSize() != 0) continue;
            checkResult = resultInfo.hasError() ? 2 : 1;
        }
        try {
            if (checkResult == 0) {
                if (EmluationRunner.getInvoker(this.procTestMetaDef.getServerUrl()).isAllProcessComplete(pks, this.processDef.getID())) {
                    return 1;
                }
                throw new EmluationException(2003, "check assignment over time");
            }
            if (checkResult == 2) {
                this.logError(resultInfo);
                return 2;
            }
            for (String bizObjId : list) {
                String[] nextIds = resultInfo.getNextActDefIds(bizObjId);
                for (String actDefId : this.getActualNextActivityDefId(nextIds)) {
                    SimpleAssignmentInfo saInfo = resultInfo.getAssignment(bizObjId + "," + actDefId);
                    String[] userIds = saInfo.getUserIds();
                    if (this.isSubflowActivity(this.processDef, actDefId)) {
                        SubFlowEmluationInfo subflowInfo = this.getSubFlowInfo(actDefId);
                        ProcessTestMetaDef subMetaDef = ProcessTestMetaDef.createByFileSystem(subflowInfo.getRefTestMetaDefId());
                        EmluationRunner d = new EmluationRunner(subMetaDef, this.context, true, saInfo.getActivityDefId());
                        d.start();
                        continue;
                    }
                    if (!this.isAllAccept(this.processDef, actDefId)) {
                        String userId = userIds[0];
                        String userName = EmluationRunner.getHelper(this.procTestMetaDef.getServerUrl()).getUserName(userId, this.procTestMetaDef.getSolution(), this.procTestMetaDef.getAis(), new Locale(this.procTestMetaDef.getStrLocale()));
                        String userPass = "";
                        userPass = EmluationRunner.getHelper(this.procTestMetaDef.getServerUrl()).getUserPass(userId, this.procTestMetaDef.getSolution(), this.procTestMetaDef.getAis(), new Locale(this.procTestMetaDef.getStrLocale()));
                        if (StringUtils.isEmpty((String)userPass)) {
                            userPass = "";
                        }
                        this.invokeActivity(actDefId, userName, userPass, false, saInfo);
                        continue;
                    }
                    int m = userIds.length;
                    for (int j = 0; j < m; ++j) {
                        String userName = EmluationRunner.getHelper(this.procTestMetaDef.getServerUrl()).getUserName(userIds[j], this.procTestMetaDef.getSolution(), this.procTestMetaDef.getAis(), new Locale(this.procTestMetaDef.getStrLocale()));
                        String userPass = "";
                        userPass = EmluationRunner.getHelper(this.procTestMetaDef.getServerUrl()).getUserPass(userIds[j], this.procTestMetaDef.getSolution(), this.procTestMetaDef.getAis(), new Locale(this.procTestMetaDef.getStrLocale()));
                        if (StringUtils.isEmpty((String)userPass)) {
                            userPass = "";
                        }
                        this.invokeActivity(actDefId, userName, userPass, false, saInfo);
                    }
                }
            }
            return 0;
        }
        catch (Exception ex) {
            throw new EmluationException(ex);
        }
    }

    private void logError(AssignmentCheckResultInfo resultInfo) {
        this.context.setErrorResult(resultInfo);
    }

    private boolean isSubflowActivity(ProcessDef procDef, String actDefId) {
        ActivityDef actDef = procDef.getActivityDef(actDefId);
        return actDef instanceof SubflowActivityDef;
    }

    private boolean isAllAccept(ProcessDef processDef2, String actDefId) {
        ActivityDef actDef = WfModelUtil.getActivityDef(processDef2, actDefId);
        return ((ManpowerActivityDef)actDef).getAcceptOption().equals((Object)AcceptOption.ALL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] getActualNextActivityDefId(String[] nextIds) {
        HashSet<String> set = new HashSet<String>();
        int n = nextIds.length;
        for (int i = 0; i < n; ++i) {
            ActivityCollection col = WfModelUtil.getPrevActivityDef(this.processDef, nextIds[i]);
            int m = col.size();
            for (int j = 0; j < m; ++j) {
                if (!(col.get(j) instanceof RouterActivityDef) || !((RouterActivityDef)col.get(j)).isMutexSplit() || set.contains(col.get(j).getID())) continue;
                set.add(col.get(j).getID());
            }
        }
        Iterator iter = set.iterator();
        if (!iter.hasNext()) return nextIds;
        String id = (String)iter.next();
        MutexSplitCollection mutexCol = this.procTestMetaDef.getMutexCol();
        MutexSplitInfo mutexSplitInfo = null;
        mutexSplitInfo = this.hasMutexDesc(id, mutexCol);
        if (mutexSplitInfo == null) throw new EmluationException(1004, "id " + id + " activity does not has mutex info");
        String toActivityDefId = mutexSplitInfo.getToActivityDefId();
        if (!this.isStringInArray(toActivityDefId, nextIds)) throw new EmluationException(1004, "id " + toActivityDefId + " does not match");
        return this.discardMutexSplit(id, toActivityDefId, nextIds);
    }

    private String[] discardMutexSplit(String mutexId, String toActivityDefId, String[] nextIds) {
        String[] postActIds = null;
        ActivityCollection col = WfModelUtil.getPostActivityDef(this.processDef, mutexId);
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            postActIds = StringUtils.stringArrayAppend(postActIds, (String)col.get(i).getID());
        }
        String[] afterDiscard = this.discardStringArray(nextIds, postActIds);
        afterDiscard = StringUtils.stringArrayAppend((String[])afterDiscard, (String)toActivityDefId);
        return afterDiscard;
    }

    private String[] discardStringArray(String[] main, String[] discard) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> discardList = new ArrayList<String>();
        ArrayList<String> rtnValue = new ArrayList<String>();
        int n = main.length;
        for (i = 0; i < n; ++i) {
            list.add(main[i]);
        }
        n = discard.length;
        for (i = 0; i < n; ++i) {
            if (!list.contains(discard[i])) continue;
            discardList.add(discard[i]);
        }
        n = main.length;
        for (i = 0; i < n; ++i) {
            if (discardList.contains(main[i])) continue;
            rtnValue.add(main[i]);
        }
        String[] rtn = new String[rtnValue.size()];
        return rtnValue.toArray(rtn);
    }

    private boolean isStringInArray(String string, String[] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    private MutexSplitInfo hasMutexDesc(String id, MutexSplitCollection mutexCol) {
        int n = mutexCol.size();
        for (int i = 0; i < n; ++i) {
            if (!id.equals(mutexCol.get(i).getMutexActivityDefId())) continue;
            return mutexCol.get(i);
        }
        return null;
    }

    private void startupOperation() {
        BOSObjectFactory.clearSession((String)this.procTestMetaDef.getServerUrl());
        this.invokeActivity(this.procTestMetaDef.getStartupInfo().getActivityDefId(), this.procTestMetaDef.getStartupInfo().getUserName(), this.procTestMetaDef.getStartupInfo().getPassword(), true, null);
    }

    private void invokeActivity(String actDefId, String userName, String userPass, boolean b, SimpleAssignmentInfo assignInfo) {
        OperationInfo operInfo = WfModelUtil.getOperation(this.processDef, actDefId);
        String className = operInfo.getExtendedProperty("executor");
        BOSObjectType type = null;
        String methodName = null;
        if (operInfo.getFacadeObjectRef() != null) {
            type = operInfo.getFacadeObjectRef().getType();
            methodName = operInfo.getFacadeMethodRef().getName();
        } else {
            type = operInfo.getEntityObjectRef().getType();
            methodName = operInfo.getEntityMethodRef().getName();
        }
        if (StringUtils.isEmpty((String)className)) {
            throw new EmluationException("operation has no response executor");
        }
        try {
            LoginUtil.logIn(this.procTestMetaDef.getServerUrl(), userName, userPass, this.procTestMetaDef.getSolution(), this.procTestMetaDef.getAis(), this.procTestMetaDef.getStrLocale(), this.procTestMetaDef.getClientMetaPath());
        }
        catch (BOSLoginException e) {
            throw new EmluationException(2001, userName + ":" + userPass, e);
        }
        catch (BOSException e) {
            throw new EmluationException(2001, userName + ":" + userPass, e);
        }
        catch (LoginAgentException e) {
            throw new EmluationException(2001, userName + ":" + userPass, (Throwable)((Object)e));
        }
        MethodResultInfo info = null;
        long s = System.currentTimeMillis();
        try {
            if (operInfo.getUiActionRef().getUIObjectRef().getName().equals("MultiApproveUI")) {
                ApproveSplitInfo approveInfo = this.getApproveSplitInfo(actDefId);
                info = EmluationRunner.getInvoker(this.procTestMetaDef.getServerUrl()).executeApprove(actDefId, this.context, approveInfo.getApproveResult(), approveInfo.getApproveDecition(), assignInfo.getAssignmentIds()[0]);
            } else {
                info = EmluationRunner.getInvoker(this.procTestMetaDef.getServerUrl()).execute(className, this.context, type, methodName);
            }
        }
        catch (EmluationException e1) {
            throw e1;
        }
        catch (BOSException e1) {
            throw new EmluationException(2002, userName + ":" + userPass, e1);
        }
        long e = System.currentTimeMillis();
        String[] pk = info.getBizObjectIds();
        this.cachePk(pk, b);
        this.context.put(CUR_ACTIVITYDEF_ID, actDefId);
        String postIds = (String)this.postRelationMap.get(actDefId);
        this.context.put(DEF_ACTIVITY_POST_RELATION, postIds);
        this.context.addExecutePathInfo(actDefId, assignInfo, e - s);
    }

    private ApproveSplitInfo getApproveSplitInfo(String actDefId) {
        ApproveSplitInfo info = null;
        ApproveSplitCollection col = this.procTestMetaDef.getApproveSplitCol();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            if (!col.get(i).getActivityDefId().equals(actDefId)) continue;
            info = col.get(i);
            break;
        }
        if (info == null) {
            throw new EmluationException(1004, "has no deciption of approve activity,activity id " + actDefId);
        }
        return info;
    }

    private SubFlowEmluationInfo getSubFlowInfo(String actDefId) {
        SubFlowEmluationInfo info = null;
        SubFlowEmluationCollection col = this.procTestMetaDef.getSubFlowCol();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            if (!col.get(i).getSubFlowActivityDefId().equals(actDefId)) continue;
            info = col.get(i);
            break;
        }
        if (info == null) {
            throw new EmluationException(1004, "has no deciption of subflow activity,activity id " + actDefId);
        }
        return info;
    }

    private void cachePk(String[] pks, boolean isStartup) {
        if (pks == null || pks.length == 0) {
            throw new EmluationException(1003, "can not get related pk");
        }
        List list = this.context.getBizObjectIds();
        if (isStartup) {
            if (list.size() > 0) {
                list.clear();
            }
            int n = pks.length;
            for (int i = 0; i < n; ++i) {
                list.add(pks[i]);
            }
        } else {
            boolean validate = true;
            int n = pks.length;
            for (int i = 0; i < n; ++i) {
                if (list.contains(pks[i])) continue;
                validate = false;
                break;
            }
            if (!validate) {
                throw new EmluationException("fatal error");
            }
        }
    }

    public void setUp() {
        this.initTestContext();
        this.loadProcessDef();
        this.loadPostRelations();
    }

    private void loadPostRelations() {
        ActivityCollection activitys = WfModelUtil.getActivitys(this.processDef, new ActivityType[]{ActivityType.MANPOWER, ActivityType.SUBFLOW});
        this.postRelationMap = new HashMap();
        int n = activitys.size();
        for (int i = 0; i < n; ++i) {
            String postActivtyIds = this.cacuPostActivity(activitys.get(i));
            this.postRelationMap.put(activitys.get(i).getID(), postActivtyIds);
        }
    }

    private void initTestContext() {
        if (!this.isSubFlow && this.context == null) {
            this.context = new EmluationContext();
            String adminUserPass = "";
            try {
                adminUserPass = EmluationRunner.getHelper(this.procTestMetaDef.getServerUrl()).getAdminitratorPass(this.procTestMetaDef.getSolution(), this.procTestMetaDef.getAis(), new Locale(this.procTestMetaDef.getStrLocale()));
                if (StringUtils.isEmpty((String)adminUserPass)) {
                    adminUserPass = "";
                }
            }
            catch (BOSException e) {
                throw new EmluationException(e);
            }
            this.context.setAdminPass(adminUserPass);
        }
        this.context.setProcessDefId(this.procTestMetaDef.getProcessDefId());
        int n = this.procTestMetaDef.getBizExterndDataCol().size();
        for (int i = 0; i < n; ++i) {
            String key = this.procTestMetaDef.getBizExterndDataCol().get(i).getKey();
            String value = this.procTestMetaDef.getBizExterndDataCol().get(i).getValue();
            this.context.addBizExterndData(key, value);
        }
    }

    private String cacuPostActivity(ActivityDef def) {
        Object[] rtnValue = new String[]{};
        try {
            ActivityCollection postCol = def.getPostActivities();
            int n = postCol.size();
            for (int i = 0; i < n; ++i) {
                if (postCol.get(i) instanceof ManpowerActivityDef || postCol.get(i) instanceof SubflowActivityDef) {
                    rtnValue = StringUtils.stringArrayAppend((String[])rtnValue, (String)postCol.get(i).getID());
                    continue;
                }
                String postActivityIds = this.cacuPostActivity(postCol.get(i));
                if (StringUtils.isEmpty((String)postActivityIds)) continue;
                rtnValue = StringUtils.stringArrayAppend((String[])rtnValue, (String)postActivityIds);
            }
            if (rtnValue != null) {
                return StringUtils.arrayToString((Object[])rtnValue, (String)",");
            }
            return "";
        }
        catch (WfException e) {
            throw new EmluationException(1004, "get post activity error,current activity id is" + def.getID());
        }
    }

    private void loadProcessDef() {
        this.processDef = this.getProcessDef();
    }

    private ProcessDef getProcessDef() {
        return this.getProcessDef(this.procTestMetaDef.getProcessDefId());
    }

    private void login(String userName, String userPass) {
        try {
            LoginUtil.logIn(this.procTestMetaDef.getServerUrl(), userName, userPass, this.procTestMetaDef.getSolution(), this.procTestMetaDef.getAis(), this.procTestMetaDef.getStrLocale(), this.procTestMetaDef.getClientMetaPath());
        }
        catch (BOSLoginException e) {
            throw new EmluationException(e);
        }
        catch (BOSException e) {
            throw new EmluationException(e);
        }
        catch (LoginAgentException e) {
            throw new EmluationException((Throwable)((Object)e));
        }
    }

    private ProcessDef getProcessDef(String procDefId) {
        try {
            this.login(this.context.getAdminUserName(), this.context.getAdminPass());
            String xml = this.getWfDefineService().get(procDefId).getProcessXml();
            ProcessDef processDef = KpdlParser.parseKpdl(xml);
            return processDef;
        }
        catch (WfException e) {
            throw new EmluationException((Throwable)((Object)e));
        }
        catch (BOSException e) {
            throw new EmluationException(e);
        }
        finally {
            BOSObjectFactory.clearSession((String)this.procTestMetaDef.getServerUrl());
        }
    }

    private IWorkFlowDefineService getWfDefineService() throws BOSException {
        IWorkFlowDefineService service = (IWorkFlowDefineService)BOSObjectFactory.createRemoteBOSObject((String)this.procTestMetaDef.getServerUrl(), (String)"com.kingdee.bos.workflow.wfdesigner.service.WorkFlowDefineService", IWorkFlowDefineService.class);
        return service;
    }

    public static IEmluationInvoker getInvoker(String serverUrl) throws BOSException {
        IEmluationInvoker service = (IEmluationInvoker)BOSObjectFactory.createRemoteBOSObject((String)serverUrl, (String)"com.kingdee.bos.workflow.emluator.engine.EmluationInvoker", IEmluationInvoker.class);
        return service;
    }

    public static IEmluationHelper getHelper(String serverUrl) throws BOSException {
        IEmluationHelper service = (IEmluationHelper)RPCEngineFactory.getEngine((String)serverUrl).createObject("com.kingdee.bos.workflow.emluator.engine.EmluationHelper", IEmluationHelper.class);
        return service;
    }

    private AssignmentCheckResultInfo checkAssignmentInfos(String[] objectPks, String serverUrl, AssignmentCheckResultInfo result) {
        try {
            int n = objectPks.length;
            for (int i = 0; i < n; ++i) {
                SimpleAssignmentInfo[] saInfos = EmluationRunner.getInvoker(serverUrl).checkAssignmentInfo(objectPks[i], this.context.getProcessDefId());
                String postActDefIds = (String)this.context.get(DEF_ACTIVITY_POST_RELATION);
                if (saInfos.length == 1 && !saInfos[0].getProcessInstState().equals(WfState.OPEN.getValue())) {
                    SimpleAssignmentInfo saInfo = saInfos[0];
                    String procInstState = saInfo.getProcessInstState();
                    if (WfState.COMPLETED.getValue().equals(procInstState)) {
                        result.dicreaseCheckingSize();
                        continue;
                    }
                    if (!WfState.SUSPENDED.getValue().equals(procInstState) && !WfState.ABORTED.getValue().equals(procInstState)) continue;
                    result.dicreaseCheckingSize();
                    result.addErrorData(objectPks[i], saInfo);
                    result.setHasError(true);
                    continue;
                }
                Object[] actDefIds = new String[saInfos.length];
                int m = saInfos.length;
                for (int j = 0; j < m; ++j) {
                    String actDefId = null;
                    actDefId = saInfos[j].isSubFlow() && !saInfos[j].getProcessDefId().equals(this.context.getProcessDefId()) ? saInfos[j].getParentActivityDefId() : saInfos[j].getActivityDefId();
                    actDefIds[j] = actDefId;
                    result.addData(objectPks[i], actDefId, saInfos[j]);
                }
                if (!this.isSubSet((String[])actDefIds, postActDefIds)) continue;
                String nextActivityDefIds = StringUtils.arrayToString((Object[])result.getNextActDefIds(objectPks[i]), (String)",");
                if (nextActivityDefIds == null) {
                    nextActivityDefIds = "";
                }
                if (nextActivityDefIds.equals(StringUtils.arrayToString((Object[])actDefIds, (String)","))) {
                    result.dicreaseCheckingSize();
                }
                result.setNextActDefIds(objectPks[i], (String[])actDefIds);
            }
            return result;
        }
        catch (Exception ex) {
            throw new EmluationException(ex);
        }
    }

    private boolean isSubSet(String[] actDefIds, String postActDefIds) {
        return true;
    }
}

