/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mdo.impl;

import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.mdo.IEntityLinkProperty;
import com.kingdee.bos.workflow.util.TreeSelectorUtils;

public class EntityLinkProperty
implements IEntityLinkProperty {
    private static final long serialVersionUID = -5476408483000446811L;
    private String name;
    private String alias;
    private String clientEntityName;
    private String supplierEntityName;
    private boolean isConfigured;

    private EntityLinkProperty() {
    }

    public static EntityLinkProperty create(LinkPropertyInfo linkPropertyInfo) {
        EntityLinkProperty property = new EntityLinkProperty();
        property.setName(linkPropertyInfo.getName());
        property.setAlias(TreeSelectorUtils.getPropertyAlias((PropertyInfo)linkPropertyInfo));
        RelationshipInfo relationshipInfo = linkPropertyInfo.getRelationship();
        if (relationshipInfo.getClientObject() == null) {
            throw new IllegalArgumentException("can't found LinkProperty(" + linkPropertyInfo.getName() + ")'s ClientObject!");
        }
        property.setClientEntityName(relationshipInfo.getClientObject().getFullName());
        if (relationshipInfo.getSupplierObject() == null) {
            throw new IllegalArgumentException("can't found LinkProperty(" + linkPropertyInfo.getName() + ")'s getSupplierObject!");
        }
        property.setSupplierEntityName(relationshipInfo.getSupplierObject().getFullName());
        property.setConfigured(linkPropertyInfo.isConfigured());
        return property;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    private void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    @Override
    public String getClientEntityName() {
        return this.clientEntityName;
    }

    private void setClientEntityName(String clientEntityName) {
        this.clientEntityName = clientEntityName;
    }

    @Override
    public String getSupplierEntityName() {
        return this.supplierEntityName;
    }

    private void setSupplierEntityName(String supplierEntityName) {
        this.supplierEntityName = supplierEntityName;
    }

    @Override
    public BOSObjectType getMDOType() {
        return MDO_TYPE;
    }

    @Override
    public boolean isConfigured() {
        return this.isConfigured;
    }

    public void setConfigured(boolean configured) {
        this.isConfigured = configured;
    }
}

