/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mdo.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.biz.trans.ITreeNode;
import com.kingdee.bos.workflow.biz.trans.TreeNode;
import com.kingdee.bos.workflow.mdo.IEntityObject;
import com.kingdee.bos.workflow.mdo.impl.EntityObject;
import com.kingdee.bos.workflow.mdo.impl.MDBViewTreeBuilder;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class EntityTreeBuilder
extends MDBViewTreeBuilder {
    public EntityTreeBuilder(Context ctx) {
        super(ctx, "com_kingdee_eas_base_subsystemEntity");
    }

    private void recursiveRemove(Map map, ITreeNode treeNode) {
        int size = treeNode.getChildren().size();
        for (int i = 0; i < size; ++i) {
            ITreeNode child = (ITreeNode)treeNode.getChildren().get(i);
            Object userObject = child.getUserObject();
            if (userObject instanceof EntityObject) {
                IEntityObject entityObject = (IEntityObject)userObject;
                map.remove(entityObject.getFullName());
            }
            this.recursiveRemove(map, child);
        }
    }

    private String getEntityAlias(EntityObjectInfo objectInfo) {
        return !StringUtils.isEmpty((String)objectInfo.getAlias()) ? objectInfo.getAlias() : objectInfo.getFullName();
    }

    @Override
    protected ITreeNode createTreeNode(ITreeNode treeContentParent, IBriefViewTreeNode briefViewTreeNode) {
        ITreeNode treeNode = super.createTreeNode(treeContentParent, briefViewTreeNode);
        if (MetaDataTypeList.ENTITY.equals((Object)briefViewTreeNode.getMetaDataType())) {
            String name = briefViewTreeNode.getName();
            String alias = briefViewTreeNode.getAlias();
            String fullName = briefViewTreeNode.getFullName();
            BOSObjectType type = briefViewTreeNode.getBOType();
            treeNode.setUserObject(EntityObject.create(name, alias, fullName, type));
        }
        return treeNode;
    }

    private ITreeNode createEntityNode(EntityObjectInfo objectInfo) {
        TreeNode child = new TreeNode();
        String alias = this.getEntityAlias(objectInfo);
        child.setText(alias);
        child.setUserObject(EntityObject.create(objectInfo));
        return child;
    }

    @Override
    public ITreeNode[] getNodesNotInMDBView() {
        ArrayList<ITreeNode> retVal = new ArrayList<ITreeNode>();
        HashMap<String, EntityObjectInfo> mapEntities = new HashMap<String, EntityObjectInfo>();
        EntityObjectCollection entities = this.getMetaDataLoader().getEntityCollection();
        int size = entities.size();
        for (int i = 0; i < size; ++i) {
            EntityObjectInfo entity = entities.get(i);
            if (entity.isAbstract()) continue;
            mapEntities.put(entity.getFullName(), entity);
        }
        ITreeNode treeNodeRoot = this.build();
        this.recursiveRemove(mapEntities, treeNodeRoot);
        for (EntityObjectInfo entity : mapEntities.values()) {
            ITreeNode entityNode = this.createEntityNode(entity);
            retVal.add(entityNode);
        }
        return retVal.toArray(new TreeNode[retVal.size()]);
    }
}

