/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mdo.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.workflow.biz.trans.ITreeNode;
import com.kingdee.bos.workflow.biz.trans.TreeNode;
import com.kingdee.bos.workflow.mdo.BriefViewTreeUtil;
import com.kingdee.bos.workflow.mdo.impl.IMDBViewTreeBuilder;
import com.kingdee.util.StringUtils;
import java.util.Enumeration;

public class MDBViewTreeBuilder
implements IMDBViewTreeBuilder {
    protected final Context ctx;
    protected final String mdbViewName;
    private boolean filterEmptyPackage;
    private boolean useDetail;

    public MDBViewTreeBuilder(Context ctx, String mdbViewName) {
        this.ctx = ctx;
        this.mdbViewName = mdbViewName;
        this.filterEmptyPackage = true;
        this.useDetail = false;
    }

    public void setFilterEmptyPackage(boolean filterEmptyPackage) {
        this.filterEmptyPackage = filterEmptyPackage;
    }

    public void setUseDetail(boolean useDetail) {
        this.useDetail = useDetail;
    }

    @Override
    public ITreeNode build() {
        IBriefViewTreeNode briefViewTreeRoot = this.createBriefViewTreeRoot();
        ITreeNode treeNodeRoot = this.createTreeNode(null, briefViewTreeRoot);
        this.recursiveProcess(treeNodeRoot, briefViewTreeRoot);
        return treeNodeRoot;
    }

    private void filterEmptyPackage(IBriefViewTreeNode root) {
        if (root.isPackage() && !root.isLeaf()) {
            Enumeration enu = root.children();
            while (enu.hasMoreElements()) {
                IBriefViewTreeNode temp = (IBriefViewTreeNode)enu.nextElement();
                this.filterEmptyPackage(temp);
            }
        } else if (root.isPackage() && root.isLeaf() && root.getParent() != null) {
            IBriefViewTreeNode temp = (IBriefViewTreeNode)root.getParent();
            root.removeFromParent();
            this.filterEmptyPackage(temp);
        }
    }

    protected final IObjectValue getMD(IBriefViewTreeNode briefViewTreeNode) {
        if (briefViewTreeNode.getMetaDataType() != null && !StringUtils.isEmpty((String)briefViewTreeNode.getFullName())) {
            return this.getMetaDataLoader().get(briefViewTreeNode.getMetaDataType(), (IMetaDataPK)new MetaDataPK(briefViewTreeNode.getFullName()));
        }
        return null;
    }

    protected IBriefViewTreeNode createBriefViewTreeRoot() {
        BusinessObjectBriefView businessObjectBriefView = this.getMetaDataLoader().getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK(this.mdbViewName));
        IBriefViewTreeNode root = businessObjectBriefView.getViewRootByType(null);
        if (this.filterEmptyPackage) {
            this.filterEmptyPackage(root);
        }
        return root;
    }

    protected final IMetaDataLoader getMetaDataLoader() {
        return MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
    }

    private void recursiveProcess(ITreeNode treeContentParent, IBriefViewTreeNode briefViewTreeParent) {
        Enumeration enumeration = briefViewTreeParent.children();
        while (enumeration.hasMoreElements()) {
            IBriefViewTreeNode briefViewTreeChild = (IBriefViewTreeNode)enumeration.nextElement();
            ITreeNode treeNodeChild = this.createTreeNode(treeContentParent, briefViewTreeChild);
            this.recursiveProcess(treeNodeChild, briefViewTreeChild);
        }
    }

    protected ITreeNode createTreeNode(ITreeNode treeContentParent, IBriefViewTreeNode briefViewTreeNode) {
        TreeNode treeNode = new TreeNode();
        String alias = this.getTreeNodeAlias(briefViewTreeNode);
        treeNode.setText(alias);
        if (this.useDetail) {
            treeNode.setUserObject(BriefViewTreeUtil.convertToSimpleBriefViewTreeNode(briefViewTreeNode));
        }
        if (treeContentParent != null) {
            treeContentParent.addChild(treeNode);
        }
        return treeNode;
    }

    private String getTreeNodeAlias(IBriefViewTreeNode briefViewTreeNode) {
        return !StringUtils.isEmpty((String)briefViewTreeNode.getAlias()) ? briefViewTreeNode.getAlias() : briefViewTreeNode.getName();
    }

    @Override
    public ITreeNode[] getNodesNotInMDBView() {
        return null;
    }
}

