/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mdo.impl;

import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.function.UIActionRefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.mdo.IFunctionObject;
import com.kingdee.bos.workflow.mdo.IMethodObject;
import com.kingdee.bos.workflow.mdo.IOperationObject;
import com.kingdee.bos.workflow.mdo.IUIActionObject;
import com.kingdee.bos.workflow.mdo.impl.MethodObject;
import com.kingdee.bos.workflow.mdo.impl.UIActionObject;
import com.kingdee.bos.workflow.util.TreeSelectorUtils;
import com.kingdee.util.StringUtils;

public class OperationObject
implements IOperationObject {
    private static final long serialVersionUID = 4286256428568798546L;
    private String name;
    private String alias;
    private IFunctionObject functionObject;
    private String entityName;
    private IUIActionObject uiActionObject;
    private IUIActionObject webPageActionObject;
    private IMethodObject methodObject;
    private boolean isBindedEntity;
    private boolean isBindedWebUI;

    @Override
    public boolean isBindedWebUI() {
        return this.isBindedWebUI;
    }

    public void setBindedWebUI(boolean isBindedWebUI) {
        this.isBindedWebUI = isBindedWebUI;
    }

    private OperationObject() {
    }

    public static IOperationObject create(IFunctionObject functionObject, OperationInfo operation) {
        UIActionRefInfo actionRefInfo;
        OperationObject operationObject = new OperationObject();
        operationObject.setName(operation.getName());
        operationObject.setAlias(TreeSelectorUtils.getOperationAlias(operation));
        operationObject.setFunctionObject(functionObject);
        EntityObjectInfo entity = operation.getEntityObjectRef();
        if (entity != null) {
            operationObject.setEntityName(entity.getFullName());
            operationObject.setBindedWebUI(!StringUtils.isEmpty((String)entity.getExtendedProperty("webEditUI")) || !StringUtils.isEmpty((String)entity.getExtendedProperty("webEditPage")));
        }
        if ((actionRefInfo = operation.getUiActionRef()) != null) {
            operationObject.setUIActionObject(UIActionObject.create(actionRefInfo));
            operationObject.setWebPageActionObject(UIActionObject.createWebPageObject(actionRefInfo));
        }
        try {
            MethodInfo method = operation.getEntityMethodRef();
            if (method == null) {
                method = operation.getFacadeMethodRef();
                operationObject.setBindedEntity(false);
            } else {
                operationObject.setBindedEntity(true);
            }
            if (method != null) {
                operationObject.setMethodObject(MethodObject.create(method));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return operationObject;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    private void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public IFunctionObject getFunctionObject() {
        return this.functionObject;
    }

    private void setFunctionObject(IFunctionObject functionObject) {
        this.functionObject = functionObject;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    private void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Override
    public IUIActionObject getUIActionObject() {
        return this.uiActionObject;
    }

    @Override
    public IUIActionObject getWebPageActionObject() {
        return this.webPageActionObject;
    }

    private void setUIActionObject(IUIActionObject uiActionObject) {
        this.uiActionObject = uiActionObject;
    }

    private void setWebPageActionObject(IUIActionObject webPageActionObject) {
        this.webPageActionObject = webPageActionObject;
    }

    @Override
    public IMethodObject getMethodObject() {
        return this.methodObject;
    }

    private void setMethodObject(IMethodObject methodObject) {
        this.methodObject = methodObject;
    }

    @Override
    public boolean isBindedEntity() {
        return this.isBindedEntity;
    }

    private void setBindedEntity(boolean isBindedEntity) {
        this.isBindedEntity = isBindedEntity;
    }

    @Override
    public BOSObjectType getMDOType() {
        return MDO_TYPE;
    }
}

