/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mdo.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.workflow.biz.trans.ITreeNode;
import com.kingdee.bos.workflow.biz.trans.OperationFilterType;
import com.kingdee.bos.workflow.biz.trans.TreeNode;
import com.kingdee.bos.workflow.mdo.IFunctionObject;
import com.kingdee.bos.workflow.mdo.IOperationObject;
import com.kingdee.bos.workflow.mdo.impl.FunctionObject;
import com.kingdee.bos.workflow.mdo.impl.MDBViewTreeBuilder;
import com.kingdee.bos.workflow.mdo.impl.OperationObject;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OperationTreeBuilder
extends MDBViewTreeBuilder {
    private final OperationFilterType filterType;

    public OperationTreeBuilder(Context ctx, OperationFilterType filterType) {
        super(ctx, "com_kingdee_eas_base_function");
        this.filterType = filterType;
    }

    @Override
    public ITreeNode build() {
        ITreeNode root = super.build();
        this.filterEmptyPackageNode(root);
        return root;
    }

    private void filterEmptyPackageNode(ITreeNode node) {
        int i;
        List children = node.getChildren();
        ArrayList<ITreeNode> removeNodes = new ArrayList<ITreeNode>();
        int size = children.size();
        for (i = 0; i < size; ++i) {
            ITreeNode child = (ITreeNode)children.get(i);
            Object object = child.getUserObject();
            if (object != null) continue;
            if (child.hasChildren()) {
                this.filterEmptyPackageNode(child);
                continue;
            }
            removeNodes.add(child);
        }
        size = removeNodes.size();
        for (i = 0; i < size; ++i) {
            ITreeNode removeNode = (ITreeNode)removeNodes.get(i);
            removeNode.removeFromParent();
        }
    }

    @Override
    protected ITreeNode createTreeNode(ITreeNode treeContentParent, IBriefViewTreeNode briefViewTreeChild) {
        ITreeNode treeNode = super.createTreeNode(treeContentParent, briefViewTreeChild);
        if (MetaDataTypeList.FUNCTION.equals((Object)briefViewTreeChild.getMetaDataType())) {
            FunctionObjectInfo function = (FunctionObjectInfo)this.getMD(briefViewTreeChild);
            treeNode.setUserObject(FunctionObject.create(function));
        }
        return treeNode;
    }

    private void addOperationNodes(ITreeNode functionNode, FunctionObjectInfo function) {
        IFunctionObject functionObject = (IFunctionObject)functionNode.getUserObject();
        OperationCollection operations = function.getOperation();
        if (operations != null) {
            int size = operations.size();
            for (int i = 0; i < size; ++i) {
                OperationInfo operationInfo = (OperationInfo)operations.getObject(i);
                if (!this.isSuitable(operationInfo)) continue;
                ITreeNode child = this.createOperationNode(functionObject, operationInfo);
                functionNode.addChild(child);
            }
        }
    }

    private ITreeNode createOperationNode(IFunctionObject functionObject, OperationInfo operationInfo) {
        TreeNode child = new TreeNode();
        String alias = this.getOperationAlias(operationInfo);
        child.setText(alias);
        IOperationObject operationObject = OperationObject.create(functionObject, operationInfo);
        child.setUserObject(operationObject);
        return child;
    }

    private ITreeNode createFunctionNode(FunctionObjectInfo function) {
        TreeNode child = new TreeNode();
        String alias = this.getFunctionAlias(function);
        child.setText(alias);
        child.setUserObject(FunctionObject.create(function));
        return child;
    }

    private String getOperationAlias(OperationInfo objectInfo) {
        return !StringUtils.isEmpty((String)objectInfo.getAlias()) ? objectInfo.getAlias() : objectInfo.getName();
    }

    private String getFunctionAlias(FunctionObjectInfo objectInfo) {
        return !StringUtils.isEmpty((String)objectInfo.getAlias()) ? objectInfo.getAlias() : objectInfo.getName();
    }

    private boolean isSuitable(OperationInfo operation) {
        if (OperationFilterType.ALL.equals((Object)this.filterType)) {
            return true;
        }
        return OperationFilterType.WITH_UI_BINDING.equals((Object)this.filterType) ? operation.getUiActionRef() != null : operation.getUiActionRef() == null;
    }

    private void recursiveRemove(Map map, ITreeNode treeNode) {
        int size = treeNode.getChildren().size();
        for (int i = 0; i < size; ++i) {
            ITreeNode child = (ITreeNode)treeNode.getChildren().get(i);
            Object object = child.getUserObject();
            if (object instanceof FunctionObject) {
                String functionName = ((IFunctionObject)object).getFullName();
                map.remove(functionName);
            }
            this.recursiveRemove(map, child);
        }
    }

    @Override
    public ITreeNode[] getNodesNotInMDBView() {
        ArrayList<ITreeNode> retVal = new ArrayList<ITreeNode>();
        HashMap<String, FunctionObjectInfo> mapFunctionOperations = new HashMap<String, FunctionObjectInfo>();
        FunctionObjectCollection functions = this.getMetaDataLoader().getFunctions();
        int size = functions.size();
        for (int i = 0; i < size; ++i) {
            FunctionObjectInfo function = functions.get(i);
            mapFunctionOperations.put(function.getFullName(), function);
        }
        ITreeNode treeNodeRoot = this.build();
        this.recursiveRemove(mapFunctionOperations, treeNodeRoot);
        for (FunctionObjectInfo function : mapFunctionOperations.values()) {
            ITreeNode functionNode = this.createFunctionNode(function);
            this.addOperationNodes(functionNode, function);
            if (!functionNode.hasChildren()) continue;
            retVal.add(functionNode);
            functionNode.getChildren().clear();
        }
        return retVal.toArray(new TreeNode[retVal.size()]);
    }
}

