/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mdo.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webpage.WebPageObjectAssembler;
import com.kingdee.bos.metadata.webpage.WebPageObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.mdo.IUIObject;
import com.kingdee.bos.workflow.mdo.IUIStatusObject;
import com.kingdee.bos.workflow.mdo.impl.UIStatusObject;
import com.kingdee.bos.workflow.util.TreeSelectorUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class UIObject
implements IUIObject {
    private static final long serialVersionUID = -2576843817846149979L;
    private String fullName;
    private String alias;
    private List statuses = new ArrayList();
    private String name;

    private UIObject() {
    }

    public static IUIObject create(Context ctx, UIObjectInfo uiObjectInfo) {
        UIObject uiObject = new UIObject();
        uiObject.setFullName(uiObjectInfo.getFullName());
        uiObject.setAlias(TreeSelectorUtils.getUIObjectAlias(uiObjectInfo));
        uiObject.setName(uiObjectInfo.getName());
        StatusCollection collection = UIObjectAssembler.getAllStatus((Context)ctx, (UIObjectInfo)uiObjectInfo);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            uiObject.addStatus(UIStatusObject.create(uiObject, collection.get(i)));
        }
        return uiObject;
    }

    public static IUIObject create(Context ctx, WebPageObjectInfo webUIObjectInfo) {
        UIObject uiObject = new UIObject();
        uiObject.setFullName(webUIObjectInfo.getFullName());
        String alias = !StringUtils.isEmpty((String)webUIObjectInfo.getAlias()) ? webUIObjectInfo.getAlias() : webUIObjectInfo.getFullName();
        uiObject.setAlias(alias);
        uiObject.setName(webUIObjectInfo.getName());
        StatusCollection collection = WebPageObjectAssembler.getAllStatus((Context)ctx, (WebPageObjectInfo)webUIObjectInfo);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            uiObject.addStatus(UIStatusObject.create(uiObject, collection.get(i)));
        }
        return uiObject;
    }

    public static IUIObject create(String name, String alias, String fullName) {
        UIObject uiObject = new UIObject();
        uiObject.setFullName(fullName);
        uiObject.setAlias(alias);
        uiObject.setName(name);
        return uiObject;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    private void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    private void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public List getStatuses() {
        return this.statuses;
    }

    private void addStatus(IUIStatusObject statusObject) {
        this.statuses.add(statusObject);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    @Override
    public BOSObjectType getMDOType() {
        return MDO_TYPE;
    }
}

