/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mdo.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.workflow.biz.trans.ITreeNode;
import com.kingdee.bos.workflow.biz.trans.TreeNode;
import com.kingdee.bos.workflow.mdo.IUIObject;
import com.kingdee.bos.workflow.mdo.impl.MDBViewTreeBuilder;
import com.kingdee.bos.workflow.mdo.impl.UIObject;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UITreeBuilder
extends MDBViewTreeBuilder {
    public UITreeBuilder(Context ctx) {
        super(ctx, "com_kingdee_eas_base_ui");
    }

    private void recursiveRemove(Map map, ITreeNode treeNode) {
        int size = treeNode.getChildren().size();
        for (int i = 0; i < size; ++i) {
            ITreeNode child = (ITreeNode)treeNode.getChildren().get(i);
            Object userObject = child.getUserObject();
            if (userObject instanceof UIObject) {
                IUIObject uiObject = (IUIObject)userObject;
                map.remove(uiObject.getFullName());
            }
            this.recursiveRemove(map, child);
        }
    }

    @Override
    protected ITreeNode createTreeNode(ITreeNode treeContentParent, IBriefViewTreeNode briefViewTreeNode) {
        ITreeNode treeNode = super.createTreeNode(treeContentParent, briefViewTreeNode);
        if (MetaDataTypeList.UIOBJECT.equals((Object)briefViewTreeNode.getMetaDataType())) {
            String name = briefViewTreeNode.getName();
            String alias = briefViewTreeNode.getAlias();
            String fullName = briefViewTreeNode.getFullName();
            IUIObject uiObject = UIObject.create(name, alias, fullName);
            treeNode.setUserObject(uiObject);
        }
        return treeNode;
    }

    private String getUIObjectAlias(UIObjectInfo objectInfo) {
        return !StringUtils.isEmpty((String)objectInfo.getAlias()) ? objectInfo.getAlias() : objectInfo.getFullName();
    }

    private ITreeNode createUINode(UIObjectInfo objectInfo) {
        TreeNode child = new TreeNode();
        String alias = this.getUIObjectAlias(objectInfo);
        child.setText(alias);
        child.setUserObject(UIObject.create(this.ctx, objectInfo));
        return child;
    }

    @Override
    public ITreeNode[] getNodesNotInMDBView() {
        ArrayList<ITreeNode> retVal = new ArrayList<ITreeNode>();
        HashMap<String, UIObjectInfo> mapUIs = new HashMap<String, UIObjectInfo>();
        IObjectCollection uiObjects = this.getMetaDataLoader().getCollection(MetaDataTypeList.UIOBJECT);
        if (uiObjects != null) {
            int size = uiObjects.size();
            for (int i = 0; i < size; ++i) {
                UIObjectInfo uiObjectInfo = (UIObjectInfo)uiObjects.getObject(i);
                mapUIs.put(uiObjectInfo.getFullName(), uiObjectInfo);
            }
        }
        ITreeNode treeNodeRoot = this.build();
        this.recursiveRemove(mapUIs, treeNodeRoot);
        for (UIObjectInfo uiObjectInfo : mapUIs.values()) {
            ITreeNode uiNode = this.createUINode(uiObjectInfo);
            retVal.add(uiNode);
        }
        return retVal.toArray(new TreeNode[retVal.size()]);
    }
}

