/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.participant;

import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ReferenceHumanType;
import com.kingdee.bos.workflow.define.RelationType;
import com.kingdee.bos.workflow.define.ScriptDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.participant.BasePartitipantComposite;
import com.kingdee.bos.workflow.participant.ParticipantCase;
import com.kingdee.bos.workflow.participant.ParticipantUnit;
import com.kingdee.bos.workflow.participant.ScriptDefDescriptor;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class ParticipantBlock
extends BasePartitipantComposite {
    public static final String UNIQUEID_KEY = "uniqueID";
    private ActivityDef activityDef;
    private ParticipantCase defaultCase;

    public ParticipantBlock(ActivityDef activityDef) {
        this.activityDef = activityDef;
        this.defaultCase = new ParticipantCase(this, true);
        ParticipantCollection participantCol = this.getParticipantCol(activityDef);
        HashMap unitMap = new HashMap();
        HashMap<String, ParticipantCase> caseMap = new HashMap<String, ParticipantCase>();
        int n = participantCol.size();
        for (int i = 0; i < n; ++i) {
            ParticipantDef def = participantCol.get(i);
            ScriptDef scriptDef = this.hasScriptRef(def, (ProcessDef)activityDef.getContainer());
            if (scriptDef != null) {
                ParticipantCase participantCase;
                String scriptID = def.getScriptRef();
                if (caseMap.containsKey(scriptID)) {
                    participantCase = (ParticipantCase)caseMap.get(scriptID);
                    this.genarateUnit(activityDef, unitMap, def, participantCase);
                    caseMap.put(scriptID, participantCase);
                    continue;
                }
                participantCase = new ParticipantCase(this, false);
                this.genarateUnit(activityDef, unitMap, def, participantCase);
                participantCase.setCondition(new ScriptDefDescriptor(participantCase, scriptDef));
                caseMap.put(scriptID, participantCase);
                continue;
            }
            this.genarateUnit(activityDef, unitMap, def, this.defaultCase);
        }
    }

    protected ParticipantCollection getParticipantCol(ActivityDef activityDef) {
        if (activityDef instanceof ManpowerActivityDef) {
            return ((ManpowerActivityDef)activityDef).getParticipants();
        }
        if (activityDef instanceof MessageActivityDef) {
            return ((MessageActivityDef)activityDef).getReceivers();
        }
        if (activityDef instanceof ToolActivityDef) {
            ParticipantCollection col = new ParticipantCollection();
            ParticipantDef def = ((ToolActivityDef)activityDef).getApplicationUser();
            if (def == null) {
                def = new ParticipantDef(activityDef);
                def.setParticipantType(ParticipantType.RELATION);
                def.setReferenceHumanType(ReferenceHumanType.PROCESS_INITIATOR);
                def.setRelationType(RelationType.SELF);
                ((ToolActivityDef)activityDef).setApplicationUser(def);
            }
            col.add(def.getID(), def);
            return col;
        }
        if (activityDef instanceof EventActivityDef) {
            return ((EventActivityDef)activityDef).getParticipants();
        }
        throw new IllegalArgumentException();
    }

    private void genarateUnit(ActivityDef activityDef, Map unitMap, ParticipantDef def, ParticipantCase participantCase) {
        if (this.hasExceptFrom(def, activityDef)) {
            String id = def.getExceptFormRef();
            ParticipantDef mainDef = this.getParticipantCol(activityDef).get(id);
            ParticipantUnit unit = (ParticipantUnit)unitMap.get(this.getUniqueID(mainDef));
            if (unit != null) {
                unit.getExcludeParticpant().getParticpantDefWrapper().setParticipantDef(def);
                unitMap.put(this.getUniqueID(def), unit);
            } else {
                unit = new ParticipantUnit(participantCase);
                unit.getExcludeParticpant().getParticpantDefWrapper().setParticipantDef(def);
                unitMap.put(this.getUniqueID(def), unit);
                unitMap.put(this.getUniqueID(mainDef), unit);
            }
        } else {
            ParticipantUnit unit = (ParticipantUnit)unitMap.get(this.getUniqueID(def));
            if (unit != null) {
                unit.getIncludeParticpant().getParticpantDefWrapper().setParticipantDef(def);
                unitMap.put(this.getUniqueID(def), unit);
            } else {
                unit = new ParticipantUnit(participantCase);
                unit.getIncludeParticpant().getParticpantDefWrapper().setParticipantDef(def);
                def.setExceptFormRef("");
                unitMap.put(this.getUniqueID(def), unit);
            }
        }
    }

    private String getUniqueID(ParticipantDef def) {
        return def.getID();
    }

    private boolean hasExceptFrom(ParticipantDef def, ActivityDef activityDef2) {
        if (StringUtils.isEmpty((String)def.getExceptFormRef())) {
            return false;
        }
        String exceptFromID = def.getExceptFormRef();
        if (activityDef2 instanceof ManpowerActivityDef) {
            return ((ManpowerActivityDef)activityDef2).getParticipants().containsKey(exceptFromID);
        }
        if (activityDef2 instanceof EventActivityDef) {
            return ((EventActivityDef)activityDef2).getParticipants().containsKey(exceptFromID);
        }
        if (activityDef2 instanceof MessageActivityDef) {
            return ((MessageActivityDef)activityDef2).getReceivers().containsKey(exceptFromID);
        }
        return false;
    }

    private ScriptDef hasScriptRef(ParticipantDef def, ProcessDef procDef) {
        if (StringUtils.isEmpty((String)def.getScriptRef())) {
            return null;
        }
        String scriptId = def.getScriptRef();
        return procDef.getScripts().get(scriptId);
    }

    public ActivityDef getActivityDef() {
        return this.activityDef;
    }

    public void setActivityDef(ManpowerActivityDef activityDef) {
        this.activityDef = activityDef;
    }

    public ParticipantCase getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(ParticipantCase defaultCase) {
        this.defaultCase = defaultCase;
    }
}

