/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service.ces;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.event.adapter.BOSEventServiceConfig;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.event.model.EventRepositoryServiceFactory;
import com.kingdee.bos.event.model.IEventRepositoryService;
import com.kingdee.bos.event.model.cem.CommonEvent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.ces.CommonEventTransObj;
import com.kingdee.bos.workflow.service.ces.ExtendedDatasTransObj;
import com.kingdee.bos.workflow.service.ces.FilterRuleSetsTransObj;
import com.kingdee.bos.workflow.service.ces.ICESService;
import java.util.ArrayList;
import java.util.List;

public class CESService
extends AbstractBOSObject
implements ICESService {
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"CESSERVI");

    public CESService() {
        super.registerInterface(ICESService.class, (Object)this);
    }

    public CESService(Context ctx) {
        super(ctx);
        super.registerInterface(ICESService.class, (Object)this);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    @Override
    public List getAllEventModel() throws WfException {
        ArrayList<CommonEventTransObj> rt = new ArrayList<CommonEventTransObj>();
        CommonEvent[] models = null;
        String protocol = BOSEventServiceConfig.getInstance().getProtocol();
        String serverUrl = BOSEventServiceConfig.getInstance().getServerUrl();
        try {
            IEventRepositoryService service = EventRepositoryServiceFactory.getEventRepositoryService((String)protocol, (String)serverUrl);
            models = service.getAllEventModel();
        }
        catch (EventRepositoryException e) {
            throw new WfException(e);
        }
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                rt.add(this.getCommonEventObj(models[i]));
            }
        }
        return rt;
    }

    private CommonEventTransObj getCommonEventObj(CommonEvent commonEvent) {
        CommonEventTransObj transObj = new CommonEventTransObj();
        transObj.setName(commonEvent.getName());
        transObj.setAlias(commonEvent.getAlias());
        transObj.setDescription(commonEvent.getDescription());
        transObj.setExpirationDate(commonEvent.getExpirationDate());
        transObj.setGroup(commonEvent.getGroup());
        transObj.setId(commonEvent.getId());
        transObj.setPriority(commonEvent.getPriority());
        transObj.setSeverity(commonEvent.getSeverity());
        transObj.setType(commonEvent.getType());
        transObj.setVersion(commonEvent.getVersion());
        transObj.setFilterRuleSets(FilterRuleSetsTransObj.create(commonEvent.getFilterRuleSets()));
        transObj.setExtendedDatas(ExtendedDatasTransObj.create(commonEvent.getExtendedDatas()));
        return transObj;
    }
}

