/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service.ormrpc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.service.ormrpc.Config;
import com.kingdee.bos.workflow.service.ormrpc.IConfigLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigLoader
implements IConfigLoader {
    static final Logger logger = Logger.getLogger((String)Config.class.getName());
    Context ctx;
    private static Properties properties = null;
    private static Config config = null;

    public ConfigLoader(Context ctx) {
        this.ctx = ctx;
    }

    public ConfigLoader() {
    }

    @Override
    public Config getConfig() {
        Properties properties = ConfigLoader.loadProperties();
        return new Config(properties);
    }

    public Properties getProperties() {
        Properties properties = ConfigLoader.loadProperties();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() {
        if (properties != null) {
            return properties;
        }
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (properties != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return properties;
            }
            String tmp = System.getProperty("java.security.auth.login.config");
            if (tmp == null) {
                properties = new Properties();
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u672a\u914d\u7f6e!");
                // ** MonitorExit[var0] (shouldn't be in output)
                return properties;
            }
            int i = tmp.lastIndexOf("/");
            if (i < 0) {
                properties = new Properties();
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u914d\u7f6e\u7684\u8def\u5f84\u4e2d\u6ca1\u6709 /!");
                // ** MonitorExit[var0] (shouldn't be in output)
                return properties;
            }
            Properties properties = new Properties();
            String path = tmp.substring(0, i) + "/";
            String file = path + "wf_ext.properties";
            ConfigLoader.loadPropertie(file, properties);
            file = path + "wf_ext-eas.properties";
            ConfigLoader.loadPropertie(file, properties);
            file = path + "wf_ext-domain.properties";
            ConfigLoader.loadPropertie(file, properties);
            file = path + "wf_ext-sp.properties";
            ConfigLoader.loadPropertie(file, properties);
            ConfigLoader.properties = properties;
            // ** MonitorExit[var0] (shouldn't be in output)
            return properties;
        }
    }

    public static synchronized Config getConfig4Client() throws BOSException {
        if (config == null) {
            IConfigLoader loader = (IConfigLoader)RpcProxy.wrapNoSupport(IConfigLoader.class, (String)ConfigLoader.class.getName());
            config = loader.getConfig();
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getConfig4Server() {
        if (config != null) return config;
        Class<ConfigLoader> clazz = ConfigLoader.class;
        synchronized (ConfigLoader.class) {
            if (config != null) return config;
            config = new ConfigLoader().getConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertie(String file, Properties map) {
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            properties.load(fis);
        }
        catch (Exception e) {
            logger.error((Object)("load wf_ext.properties from " + file + " failed!"), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Enumeration<Object> em = properties.keys();
        while (em.hasMoreElements()) {
            Object o;
            Object key = em.nextElement();
            Object value = properties.get(key);
            if (value instanceof String) {
                try {
                    value = new String(((String)value).getBytes("ISO8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = properties.get(key);
                }
            }
            if ((o = map.put(key, value)) == null) continue;
            StringBuffer msg = new StringBuffer();
            msg.append("wf_ext config {").append(key).append("=").append(o).append("} is overridden by {").append(file).append("}, with new value{").append(value).append("}");
            logger.info((Object)msg);
        }
    }

    public static void reset() {
        config = null;
        properties = null;
        ConfigLoader.getConfig4Server();
    }

    public void set(String key, String value) {
        if (!"00000000-0000-0000-0000-00000000000013B7DE7F".equals(this.ctx.getCaller().toString())) {
            throw new RuntimeException("\u65e0\u6743\u9650!");
        }
        ConfigLoader.getConfig4Server();
        key = key.trim();
        value = value.trim();
        properties.put(key, value);
    }

    public String getBosType(String billId) {
        return Config.getBOSType(billId);
    }
}

