/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service.ormrpc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class NotRollbackCause
implements Serializable {
    private static final long serialVersionUID = 1149614430206619675L;
    public static final String PROCESS_CLOSED = "processClosed";
    public static final String PROCESS_SUSPEND = "processSuspend";
    public static final String PROCESS_DATAERROR = "processDataError";
    public static final String ACTINST_IS_APPEND = "actInstIsAppend";
    public static final String ACTINST_IS_NOT_COMPLETED = "actInstIsNotCompleted";
    public static final String TARGET_ACTINST_IS_NULL = "targetActInstIsNull";
    public static final String ACTDEF_IS_NOT_ALLOWED = "actDefIsNotAllowed";
    public static final String MANPOWER_IS_NOT_STARTED = "manpowerIsNotStarted";
    public static final String YES = "yes";
    public static final String ACTINST_IS_DynCountersign = "dynCountersign";
    public static final String NOT_AllowCancelParent = "notAllowCancelParent";
    public static final String COUNTERSIGN_NOREPEAT = "countersignNoRepeat";
    private static Map<String, Map<String, String>> locales = new HashMap<String, Map<String, String>>();
    private String type = "yes";
    private String actDefName;

    public NotRollbackCause(String type) {
        this(type, null);
    }

    public NotRollbackCause(String type, String actDefName) {
        this.type = type;
        this.actDefName = actDefName;
    }

    public String getCauseMsg(Locale locale) {
        String language = "l2";
        if (locale != null) {
            language = locale.getLanguage();
        }
        String msg = "";
        if ("l1".equals(language)) {
            msg = "The task cannot be called back:";
        } else if ("l2".equals(language)) {
            msg = "\u8be5\u4efb\u52a1\u65e0\u6cd5\u64a4\u56de:";
        } else if ("l3".equals(language)) {
            msg = "\u8a72\u4efb\u52d9\u7121\u6cd5\u64a4\u56de:";
        }
        msg = msg + locales.get(this.type).get(language);
        msg = String.format(msg, this.actDefName);
        return msg;
    }

    public boolean isCanRollback() {
        return YES.equals(this.type);
    }

    static {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("l1", "Process is closed");
        item.put("l2", "\u6d41\u7a0b\u5df2\u7ed3\u675f");
        item.put("l3", "\u6d41\u7a0b\u5df2\u7d50\u675f");
        locales.put(PROCESS_CLOSED, item);
        item = new HashMap();
        item.put("l1", "Process is suspended");
        item.put("l2", "\u6d41\u7a0b\u5df2\u6302\u8d77");
        item.put("l3", "\u6d41\u7a0b\u5df2\u639b\u8d77");
        locales.put(PROCESS_SUSPEND, item);
        item = new HashMap();
        item.put("l1", "Process data error");
        item.put("l2", "\u6d41\u7a0b\u6570\u636e\u5f02\u5e38");
        item.put("l3", "\u6d41\u7a0b\u6578\u64da\u7570\u5e38");
        locales.put(PROCESS_DATAERROR, item);
        item = new HashMap();
        item.put("l1", "ActInst[%s] is append node ");
        item.put("l2", "\u6d3b\u52a8\u5b9e\u4f8b\u3010%s\u3011\u662f\u52a0\u7b7e\u8282\u70b9");
        item.put("l3", "\u6d3b\u52d5\u5be6\u4f8b\u3010%s\u3011\u662f\u52a0\u7c3d\u7bc0\u9ede");
        locales.put(ACTINST_IS_APPEND, item);
        item = new HashMap();
        item.put("l1", "Current actInst[%s] is not completed");
        item.put("l2", "\u5f53\u524d\u6d3b\u52a8\u5b9e\u4f8b\u3010%s\u3011\u72b6\u6001\u4e0d\u662f\u5df2\u5b8c\u6210");
        item.put("l3", "\u7576\u524d\u6d3b\u52d5\u5be6\u4f8b\u3010%s\u3011\u72c0\u614b\u4e0d\u662f\u5df2\u5b8c\u6210");
        locales.put(ACTINST_IS_NOT_COMPLETED, item);
        item = new HashMap();
        item.put("l1", "Target actInst[%s] is null ");
        item.put("l2", "\u76ee\u6807\u6d3b\u52a8\u5b9e\u4f8b\u3010%s\u3011\u4e3a\u7a7a");
        item.put("l3", "\u76ee\u6a19\u6d3b\u52d5\u5be6\u4f8b\u3010%s\u3011\u70ba\u7a7a");
        locales.put(TARGET_ACTINST_IS_NULL, item);
        item = new HashMap();
        item.put("l1", "Proess node[%s] property isCanRollback isn't set");
        item.put("l2", "\u6d41\u7a0b\u8282\u70b9\u3010%s\u3011\u672a\u8bbe\u7f6e\u5141\u8bb8\u64a4\u56de");
        item.put("l3", "\u6d41\u7a0b\u7bc0\u9ede\u3010%s\u3011\u672a\u8a2d\u7f6e\u5141\u8a31\u64a4\u56de");
        locales.put(ACTDEF_IS_NOT_ALLOWED, item);
        item = new HashMap();
        item.put("l1", "Next manpower actInst[%s] state is not not_started");
        item.put("l2", "\u4e0b\u4e00\u4e2a\u4eba\u5de5\u8282\u70b9\u3010%s\u3011\u72b6\u6001\u4e0d\u662f\u672a\u5f00\u59cb");
        item.put("l3", "\u4e0b\u58f9\u500b\u4eba\u5de5\u7bc0\u9ede\u3010%s\u3011\u72c0\u614b\u4e0d\u662f\u672a\u958b\u59cb");
        locales.put(MANPOWER_IS_NOT_STARTED, item);
        item = new HashMap();
        item.put("l1", "Dynamic countersignature has been made for the active node\u3010%s\u3011");
        item.put("l2", "\u6d3b\u52a8\u8282\u70b9\u3010%s\u3011\u505a\u4e86\u52a8\u6001\u4f1a\u7b7e");
        item.put("l3", "\u6d3b\u52d5\u7bc0\u9ede\u3010%s\u3011\u505a\u4e86\u52d5\u614b\u6703\u7c3d");
        locales.put(ACTINST_IS_DynCountersign, item);
        item = new HashMap();
        item.put("l1", YES);
        item.put("l2", YES);
        item.put("l3", YES);
        locales.put(YES, item);
        item = new HashMap();
        item.put("l1", "The next node [% s] is a sub process node");
        item.put("l2", "\u4e0b\u4e00\u4e2a\u8282\u70b9\u3010%s\u3011\u4e3a\u5b50\u6d41\u7a0b\u8282\u70b9");
        item.put("l3", "\u4e0b\u4e00\u500b\u7bc0\u9ede\u3010%s\u3011\u70ba\u5b50\u6d41\u7a0b\u7bc0\u9ede");
        locales.put(NOT_AllowCancelParent, item);
        item = new HashMap();
        item.put("l1", "Countersigning tasks cannot be repeatedly recalled or the task status is not Completed");
        item.put("l2", "\u4f1a\u7b7e\u4efb\u52a1\u4e0d\u5141\u8bb8\u91cd\u590d\u64a4\u56de\u6216\u8005\u4efb\u52a1\u72b6\u6001\u4e0d\u4e3a\u5df2\u5b8c\u6210");
        item.put("l3", "\u6703\u7c3d\u4efb\u52d9\u4e0d\u5141\u8a31\u91cd\u8907\u64a4\u56de\u6216\u8005\u4efb\u52d9\u72c0\u614b\u4e0d\u70ba\u5df2\u5b8c\u6210");
        locales.put(COUNTERSIGN_NOREPEAT, item);
    }
}

