/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.shell.ast.expr;

import com.kingdee.bos.workflow.shell.ast.expr.WfShellExpr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ObjectCreateExpr
extends WfShellExpr {
    public String objType;
    public final List paramList = new ArrayList();
    public final List initExprList = new ArrayList();
    private Class _class;

    public ObjectCreateExpr() {
        super(23);
    }

    public ObjectCreateExpr(String objType) {
        super(23);
        this.objType = objType;
    }

    @Override
    public void output(StringBuffer buff) {
        buff.append("new ");
        if (this.objType.startsWith("[")) {
            String componentType;
            boolean isRefType;
            char ch;
            int dim = 0;
            for (int i = 0; i < this.objType.length() && (ch = this.objType.charAt(i)) == '['; ++i) {
                ++dim;
            }
            boolean bl = isRefType = this.objType.charAt(dim) == 'L';
            if (isRefType) {
                componentType = this.objType.substring(dim + 1, this.objType.length() - 1);
            } else {
                switch (this.objType.charAt(dim)) {
                    case 'C': {
                        componentType = "char";
                        break;
                    }
                    case 'B': {
                        componentType = "byte";
                        break;
                    }
                    case 'S': {
                        componentType = "short";
                        break;
                    }
                    case 'I': {
                        componentType = "int";
                        break;
                    }
                    case 'J': {
                        componentType = "long";
                        break;
                    }
                    case 'F': {
                        componentType = "float";
                        break;
                    }
                    case 'D': {
                        componentType = "double";
                        break;
                    }
                    default: {
                        componentType = "ErrorType.";
                    }
                }
            }
            buff.append(componentType);
            for (int i = 0; i < dim; ++i) {
                WfShellExpr pramExpr;
                buff.append('[');
                if (i < this.paramList.size() && (pramExpr = (WfShellExpr)this.paramList.get(i)) != null) {
                    pramExpr.output(buff);
                }
                buff.append(']');
            }
        } else {
            buff.append('(');
            for (int i = 0; i < this.paramList.size(); ++i) {
                if (i != 0) {
                    buff.append(", ");
                }
                WfShellExpr paramExpr = (WfShellExpr)this.paramList.get(i);
                paramExpr.output(buff);
            }
            buff.append(')');
        }
        if (this.initExprList.size() != 0) {
            buff.append(" {");
            Iterator iter = this.initExprList.iterator();
            boolean flag = false;
            while (iter.hasNext()) {
                if (flag) {
                    buff.append(", ");
                }
                WfShellExpr initExpr = (WfShellExpr)iter.next();
                initExpr.output(buff);
                flag = true;
            }
            buff.append("}");
        }
    }

    @Override
    public final Class getExprClass() {
        return this._class;
    }

    @Override
    public void setExprClass(Class c) {
        this._class = c;
    }
}

