/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.shell.ast.expr;

import com.kingdee.bos.workflow.shell.ast.expr.WfShellExpr;

public class StringExpr
extends WfShellExpr {
    public String text;

    public StringExpr() {
        super(5);
    }

    public StringExpr(String text) {
        super(5);
        this.text = text;
    }

    @Override
    public void setExprClass(Class val) {
        throw new UnsupportedOperationException();
    }

    public String getJavaString() {
        StringBuffer buff = new StringBuffer();
        int length = this.text.length();
        for (int i = 0; i < length; ++i) {
            char c = this.text.charAt(i);
            if (c == '\'' && i != length - 1 && this.text.charAt(i + 1) == '\'') continue;
            buff.append(c);
        }
        return buff.toString();
    }

    @Override
    public void output(StringBuffer buff) {
        buff.append('\'');
        block7: for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            switch (ch) {
                case '\\': {
                    buff.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    buff.append("\\\"");
                    continue block7;
                }
                case '\t': {
                    buff.append("\\t");
                    continue block7;
                }
                case '\r': {
                    buff.append("\\r");
                    continue block7;
                }
                case '\n': {
                    buff.append("\\n");
                    continue block7;
                }
                default: {
                    buff.append(ch);
                }
            }
        }
        buff.append('\'');
    }

    @Override
    public final Class getExprClass() {
        return String.class;
    }
}

