/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.shell.parser;

import com.kingdee.bos.workflow.shell.parser.TokenType;

public class Token {
    public int type;
    public String value;
    public int beginLine;
    public int endLine;
    public int beginColumn;
    public int endColumn;
    public int position;
    public static final Token NotToken = new Token("!", 4, 0, 0);
    public static final Token AssignToken = new Token("=", 4, 0, 0);
    public static final Token EqualToken = new Token("==", 4, 0, 0);
    public static final Token NotEqualToken = new Token("!=", 4, 0, 0);
    public static final Token LessThanToken = new Token("<", 4, 0, 0);
    public static final Token LessThanOrEqualToken = new Token("<=", 4, 0, 0);
    public static final Token GreaterThanToken = new Token(">", 4, 0, 0);
    public static final Token GreaterThanOrEqualToken = new Token(">=", 4, 0, 0);
    public static final Token PlusToken = new Token("+", 4, 0, 0);
    public static final Token MinusToken = new Token("-", 4, 0, 0);
    public static final Token MulToken = new Token("*", 4, 0, 0);
    public static final Token DivToken = new Token("/", 4, 0, 0);
    public static final Token ModToken = new Token("%", 4, 0, 0);
    public static final Token BitwiseAndToken = new Token("&", 4, 0, 0);
    public static final Token BooleanAndToken = new Token("&&", 4, 0, 0);
    public static final Token BitwiseOrToken = new Token("|", 4, 0, 0);
    public static final Token BitwiseComplementToken = new Token("~", 4, 0, 0);
    public static final Token BitwiseXorToken = new Token("^", 4, 0, 0);
    public static final Token BooleanOrToken = new Token("||", 4, 0, 0);
    public static final Token BitwiseAndEqualToken = new Token("&=", 4, 0, 0);
    public static final Token BitwiseXorEqualToken = new Token("^=", 4, 0, 0);
    public static final Token BitwiseOrEqualToken = new Token("|=", 4, 0, 0);
    public static final Token IncrementToken = new Token("++", 4, 0, 0);
    public static final Token DecrementToken = new Token("--", 4, 0, 0);
    public static final Token AddEqualToken = new Token("+=", 4, 0, 0);
    public static final Token SubEqualToken = new Token("-=", 4, 0, 0);
    public static final Token MulEqualToken = new Token("*=", 4, 0, 0);
    public static final Token DivEqualToken = new Token("/=", 4, 0, 0);
    public static final Token ModEqualToken = new Token("%=", 4, 0, 0);
    public static final Token LeftShiftToken = new Token("<<", 4, 0, 0);
    public static final Token RightShiftToken = new Token(">>", 4, 0, 0);
    public static final Token UnsignRightShiftToken = new Token(">>>", 4, 0, 0);
    public static final Token LeftShiftEqualToken = new Token("<<=", 4, 0, 0);
    public static final Token RightShiftEqualToken = new Token(">>=", 4, 0, 0);
    public static final Token UnsignRightShiftEqualToken = new Token(">>>=", 4, 0, 0);
    public static final Token OpenCurlyBraceToken = new Token("{", 5, 0, 0);
    public static final Token CloseCurlyBraceToken = new Token("}", 5, 0, 0);
    public static final Token OpenBraceToken = new Token("(", 5, 0, 0);
    public static final Token CloseBraceToken = new Token(")", 5, 0, 0);
    public static final Token OpenSquareBraceToken = new Token("[", 5, 0, 0);
    public static final Token CloseSquareBraceToken = new Token("]", 5, 0, 0);
    public static final Token PeriodToken = new Token(".", 5, 0, 0);
    public static final Token CommaToken = new Token(",", 5, 0, 0);
    public static final Token ColonToken = new Token(":", 5, 0, 0);
    public static final Token SemicolonToken = new Token(";", 5, 0, 0);
    public static final Token QuestionToken = new Token("?", 5, 0, 0);
    public static final Token EOFToken = new Token("", 12, 0, 0);
    public static final Token BreakToken = new Token("BREAK", 3, 0, 0);
    public static final Token CaseToken = new Token("case", 3, 0, 0);
    public static final Token ContinueToken = new Token("continue", 3, 0, 0);
    public static final Token DefaultToken = new Token("default", 3, 0, 0);
    public static final Token DoubleToken = new Token("double", 3, 0, 0);
    public static final Token DoToken = new Token("do", 3, 0, 0);
    public static final Token ElseToken = new Token("else", 3, 0, 0);
    public static final Token FalseToken = new Token("false", 3, 0, 0);
    public static final Token ForToken = new Token("for", 3, 0, 0);
    public static final Token FunctionToken = new Token("function", 3, 0, 0);
    public static final Token GotoToken = new Token("goto", 3, 0, 0);
    public static final Token IfToken = new Token("if", 3, 0, 0);
    public static final Token InstanceofToken = new Token("instanceof", 3, 0, 0);
    public static final Token NullToken = new Token("null", 3, 0, 0);
    public static final Token ReturnToken = new Token("return", 3, 0, 0);
    public static final Token TrueToken = new Token("true", 3, 0, 0);
    public static final Token VarToken = new Token("var", 3, 0, 0);
    public static final Token SwitchToken = new Token("switch", 3, 0, 0);
    public static final Token WhileToken = new Token("while", 3, 0, 0);
    public static final Token AscToken = new Token("asc", 3, 0, 0);
    public static final Token DescToken = new Token("desc", 3, 0, 0);
    public static final Token WhereToken = new Token("where", 3, 0, 0);
    public static final Token OrderToken = new Token("order", 3, 0, 0);
    public static final Token ByToken = new Token("by", 3, 0, 0);
    public static final Token ListToken = new Token("list", 3, 0, 0);
    public static final Token ProcessToken = new Token("process", 3, 0, 0);
    public static final Token InstanceToken = new Token("instance", 3, 0, 0);
    public static final Token New = new Token("new", 3, 0, 0);
    public static final Token LambdaToken = new Token("lambda", 3, 0, 0);

    public Token() {
    }

    public Token(int type, String value) {
        this.value = value;
        this.type = type;
    }

    public Token(String value, int type, int line, int col) {
        this.value = value;
        this.type = type;
        this.beginLine = line;
        this.beginColumn = col;
    }

    public Token(String value, int type, int line, int col, int ptr) {
        this.value = value;
        this.type = type;
        this.beginLine = line;
        this.beginColumn = col;
        this.position = ptr;
    }

    public final boolean equals(Token tok) {
        if (tok == null) {
            return false;
        }
        if (tok.type != this.type) {
            return false;
        }
        switch (tok.type) {
            case 4: 
            case 5: 
            case 6: {
                return this.value == tok.value;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.value.compareToIgnoreCase(tok.value) == 0;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.value.compareToIgnoreCase(tok.value) == 0;
            }
            case 12: {
                return true;
            }
            case 13: {
                return false;
            }
        }
        return false;
    }

    public final String typename() {
        return TokenType.typename(this.type);
    }
}

