/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.store.util.AbstractConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import com.kingdee.util.TypeConversionUtils;

public class BooleanConvertor
extends AbstractConvertor {
    @Override
    protected Object stringToObject(String value) throws WfException {
        if (RelevantDataType.isNULL(value)) {
            return new Boolean(false);
        }
        boolean returnValue = TypeConversionUtils.objToBoolean((Object)value);
        return returnValue;
    }

    @Override
    protected String objectToString(Object value) throws WfException {
        if (value == null) {
            return "##NULL##";
        }
        if (!(value instanceof Boolean)) {
            this.objectToStringException(value);
        }
        Boolean fieldValue = (Boolean)value;
        return String.valueOf(fieldValue);
    }

    @Override
    protected Object[] stringToArray(String value) throws WfException {
        Object[] objectArray = super.stringToArray(value);
        if (objectArray != null) {
            Object[] booleanArray = new Boolean[objectArray.length];
            System.arraycopy(objectArray, 0, booleanArray, 0, objectArray.length);
            return booleanArray;
        }
        return new Boolean[this.relevantData.getDataType().getLength()];
    }

    public BooleanConvertor(RelevantData value) {
        super(value);
    }
}

