/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.store.util.AbstractConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import org.apache.log4j.Logger;

public class EnumConvertor
extends AbstractConvertor {
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.store.util.EnumConvertor");

    @Override
    protected Object stringToObject(String value) throws WfException {
        try {
            DynamicEnum e;
            block6: {
                if (RelevantDataType.isNULL(value)) {
                    return null;
                }
                String className = this.relevantData.getDataType().getClassName();
                if (className == null || className.trim().length() == 0) {
                    log.warn((Object)"enum convertor warning: className is null.");
                    return null;
                }
                try {
                    Class<?> enumClass = Class.forName(className);
                    e = EnumUtils.getEnum(enumClass, (String)value);
                }
                catch (ClassNotFoundException ex) {
                    e = DynamicEnum.getEnumByName((String)className, (Object)value);
                    if (e != null) break block6;
                    log.error((Object)("can not found class:" + className), (Throwable)ex);
                    throw ex;
                }
            }
            return e;
        }
        catch (ClassNotFoundException e) {
            throw new WfException("ClassNotFoundException,{#" + this.relevantData.getName() + "," + this.relevantData.getDataType().getClassName() + "#}", e);
        }
    }

    @Override
    protected String objectToString(Object value) throws WfException {
        if (value == null) {
            return "##NULL##";
        }
        if (!(value instanceof Enum)) {
            this.objectToStringException(value);
        }
        RelevantDataType dataType = this.relevantData.getDataType();
        String className = null;
        className = value instanceof DynamicEnum ? ((DynamicEnum)value).getPK() : value.getClass().getName();
        dataType.setClassName(className);
        Enum fieldValueEnum = (Enum)value;
        String enumName = fieldValueEnum.getName();
        return enumName;
    }

    @Override
    protected Object[] stringToArray(String value) throws WfException {
        Object[] objectArray = super.stringToArray(value);
        if (objectArray != null) {
            Object[] pkArray = new Enum[objectArray.length];
            System.arraycopy(objectArray, 0, pkArray, 0, objectArray.length);
            return pkArray;
        }
        return new Enum[this.relevantData.getDataType().getLength()];
    }

    public EnumConvertor(RelevantData value) {
        super(value);
    }
}

