/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.store.util.EnumConvertor;
import com.kingdee.bos.workflow.store.util.IRelevantDataValueConvertor;
import com.kingdee.bos.workflow.store.util.ObjectConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import com.kingdee.util.enums.Enum;

public class ExternalTypeConvertor
implements IRelevantDataValueConvertor {
    private RelevantData relevantData;

    private IRelevantDataValueConvertor createConvertor(Object value) {
        String minorType = this.relevantData.getDataType().getMinorType();
        if (minorType.startsWith("EXTERNALTYPE.OBJECT")) {
            ObjectConvertor convertor = new ObjectConvertor(this.relevantData);
            return convertor;
        }
        if ("EXTERNALTYPE.ENUM".equalsIgnoreCase(minorType)) {
            EnumConvertor convertor = new EnumConvertor(this.relevantData);
            return convertor;
        }
        if (minorType == null || minorType.trim().length() == 0) {
            if (value instanceof Enum || value instanceof Enum[]) {
                RelevantDataType dataType = this.relevantData.getDataType();
                dataType.setMinorType("EXTERNALTYPE.ENUM");
                EnumConvertor convertor = new EnumConvertor(this.relevantData);
                return convertor;
            }
            ObjectConvertor convertor = new ObjectConvertor(this.relevantData);
            return convertor;
        }
        throw new UnsupportedOperationException();
    }

    public ExternalTypeConvertor(RelevantData dstRelevantData) {
        if (dstRelevantData == null) {
            throw new IllegalArgumentException();
        }
        this.relevantData = dstRelevantData;
    }

    @Override
    public String valueToString(Object value) throws WfException {
        IRelevantDataValueConvertor convertor = this.createConvertor(value);
        return convertor.valueToString(value);
    }

    @Override
    public Object stringToValue() throws WfException {
        IRelevantDataValueConvertor convertor = this.createConvertor(null);
        return convertor.stringToValue();
    }
}

