/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.wrapper.FunctionWrapper;
import com.kingdee.bos.service.job.wrapper.MessageSenderWrapper;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.EventPolicyCollection;
import com.kingdee.bos.workflow.define.EventPolicyDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessHeaderDef;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class JobServiceUtil {
    public static final String FAILURENOTICE = "failureNotice";
    public static final String COMPLETENOTICE = "completeNotice";
    public static final String ABORTNOTICE = "abortNotice";
    public static final String SLOWNOTICE = "slowNotice";
    public static final String OVERTIMENOTICE = "overtimeNotice";
    public static final String RUNTIMEOUT = "runTimeout";
    public static final String NOTICETIELE_L1 = "noticeTitle_L1";
    public static final String NOTICETIELE_L2 = "noticeTitle_L2";
    public static final String NOTICETIELE_L3 = "noticeTitle_L3";
    public static final String NOTICECONTENT_L1 = "noticeContent_L1";
    public static final String NOTICECONTENT_L2 = "noticeContent_L2";
    public static final String NOTICECONTENT_L3 = "noticeContent_L3";
    public static final String SENDSMS = "sendSMS";
    public static final String SENDMAIL = "sendMail";

    public static Trigger toTrigger(JobDef def, ProcessDef process) throws BOSException {
        Date validateTime = process.getProcessHeader().getValidFrom();
        Date expiredTime = process.getProcessHeader().getValidTo();
        ExtendedAttributeDef extendedAttributeDef1 = process.getExtendedAttributes().get("isRetainTime");
        if (extendedAttributeDef1 == null || !"true".equals(extendedAttributeDef1.getValue())) {
            validateTime = JobServiceUtil.truncateDate(validateTime);
            expiredTime = JobServiceUtil.truncateDate(expiredTime);
        }
        ScheduleDef schedule = process.getProcessHeader().getScheduale();
        String schedulePlan = schedule.getType().toString() + ":" + schedule.getDefine();
        boolean useCalendar = schedule.isUseCalendar();
        boolean inWorkingDay = schedule.isInWorkingDay();
        ExtendedAttributeDef extendedAttributeDef = process.getExtendedAttributes().get("selectedServer");
        String selectedServer = null;
        if (extendedAttributeDef != null) {
            selectedServer = extendedAttributeDef.getValue();
        }
        extendedAttributeDef = process.getExtendedAttributes().get("isFireLastMissedJob");
        boolean isFireLastMissedJob = true;
        if (extendedAttributeDef != null) {
            isFireLastMissedJob = "true".equalsIgnoreCase(extendedAttributeDef.getValue());
        }
        Trigger trigger = new Trigger(validateTime, expiredTime, def, "timer", true, schedulePlan, useCalendar, selectedServer, inWorkingDay, isFireLastMissedJob);
        return trigger;
    }

    public static Date truncateDate(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(sdf.format(d));
        }
        catch (ParseException e) {
            return d;
        }
    }

    public static JobDef toJobDef(Context ctx, ProcessDef process) throws BOSException {
        String dc = ctx.getAIS();
        String user = ctx.getCaller().toString();
        Locale l = ctx.getLocale();
        return JobServiceUtil.toJobDef(dc, user, process, l);
    }

    public static JobDef toJobDef(String dc, String user, ProcessDef process, Locale l) throws BOSException {
        ToolActivityDef activity;
        ExtendedAttributeDef ead;
        String jobdefid = process.getID().substring(0, 36) + "BGJOBDEF";
        String packageName = process.getProcessHeader().getPackageName();
        String title = process.getName();
        if (title == null || title.trim().length() == 0) {
            title = process.getName(l);
        }
        if (title == null || title.trim().length() == 0) {
            title = process.getName(new Locale("l1"));
        }
        if (title == null || title.trim().length() == 0) {
            title = process.getName(new Locale("l2"));
        }
        if (title == null || title.trim().length() == 0) {
            title = process.getName(new Locale("l3"));
        }
        String sql = "select fdescription from t_wfd_processdef where fprocessid='" + process.getID() + "'";
        ArrayList list = SQL.executeQuery((String)dc, (String)sql);
        String description = null;
        if (list.size() == 1) {
            description = (String)((HashMap)list.get(0)).get("fdescription");
        }
        boolean isPersistent = (ead = (activity = (ToolActivityDef)process.getActivitys(ActivityType.TOOL).get(0)).getActivityHeader().getExtendedAttributes().get("isPersistent")) == null ? true : new Boolean(ead.getValue());
        FunctionDef func = activity.getRelatedApplication().getFunction();
        String function = func.getPackageName() + "." + func.getName();
        String operation = func.getOperation();
        FormalParameterCollection fpc = activity.getRelatedApplication().getFormalParameters();
        FunctionWrapper.Parameter[] params = new FunctionWrapper.Parameter[fpc.size()];
        for (int i = 0; i < fpc.size(); ++i) {
            FormalParameterDef fp = fpc.get(i);
            String name = fp.getName();
            Resource t = fp.getDescriptionResource();
            String alias = t != null ? t.getValue(l) : "";
            String type = fp.getDataType().toString();
            String entityMetaData = fp.getEntityType();
            String value = JobServiceUtil.getDataFieldValue(process, name);
            params[i] = new FunctionWrapper.Parameter(name, alias, type, entityMetaData, value, null);
        }
        FunctionWrapper handler = new FunctionWrapper(function, operation, params);
        ead = activity.getActivityHeader().getExtendedAttributes().get("priority");
        int priority = ead == null ? 1000 : Integer.parseInt(ead.getValue());
        ScheduleDef schedule = process.getProcessHeader().getScheduale();
        int tmp = schedule.getInstructionType();
        int missedTimeout = tmp == 1 ? -1 : 0;
        String proxyUserID = null;
        ExtendedAttributeDef jobExecutorIdAttribute = process.getExtendedAttributes().get("jobExecutorId");
        if (jobExecutorIdAttribute != null) {
            proxyUserID = jobExecutorIdAttribute.getValue();
        }
        String proxyOrgID = schedule.getOrgUnitId();
        boolean isSmallJob = false;
        ExtendedAttributeDef nonMutexCtrlAttribute = process.getExtendedAttributes().get("nonMutexCtrl");
        String mutex = null;
        if (nonMutexCtrlAttribute == null || !"true".equals(nonMutexCtrlAttribute.getValue())) {
            ExtendedAttributeDef extendedAttributeDef = process.getExtendedAttributes().get("mutexCtrl");
            if (extendedAttributeDef != null) {
                mutex = extendedAttributeDef.getValue();
            }
            if (StringUtils.isEmpty(mutex)) {
                int i = function.lastIndexOf(46);
                if (i < 0) {
                    i = -1;
                }
                mutex = "G::" + function.substring(++i);
            }
            if (mutex.length() > 40) {
                mutex = mutex.substring(0, 40);
            }
        }
        JobIsolationLevel isolationLevel = null;
        String viewerUI = null;
        JobDef def = new JobDef(jobdefid, packageName, title, description, proxyUserID, proxyOrgID, isPersistent, (Wrapper)handler, isSmallJob, mutex, priority, missedTimeout, isolationLevel, viewerUI, dc, user);
        MessageSenderWrapper.MessageReceiver[] receivers = JobServiceUtil.getResponsibles(process);
        HashMap noticeContent = JobServiceUtil.getNoticeContent(process);
        boolean sendSMS = false;
        if (noticeContent.get(SENDSMS) != null) {
            sendSMS = (Boolean)noticeContent.get(SENDSMS);
        }
        boolean sendMail = false;
        if (noticeContent.get(SENDMAIL) != null) {
            sendMail = (Boolean)noticeContent.get(SENDMAIL);
        }
        if (receivers.length > 0) {
            MessageSenderWrapper messageSenderWrapper;
            MessageSenderWrapper.MessageTemplate[] message = JobServiceUtil.getUserDefMessageTemplates(noticeContent);
            MessageSenderWrapper msgSender = null;
            msgSender = message != null && message.length > 0 ? new MessageSenderWrapper(receivers, message, sendMail, sendSMS) : new MessageSenderWrapper(receivers, JobServiceUtil.getDefaultMessageTemplates(), sendMail, sendSMS);
            boolean failure = false;
            if (noticeContent.get(FAILURENOTICE) != null) {
                failure = (Boolean)noticeContent.get(FAILURENOTICE);
            }
            boolean complete = false;
            if (noticeContent.get(COMPLETENOTICE) != null) {
                complete = (Boolean)noticeContent.get(COMPLETENOTICE);
            }
            boolean abort = false;
            if (noticeContent.get(ABORTNOTICE) != null) {
                abort = (Boolean)noticeContent.get(ABORTNOTICE);
            }
            boolean slow = false;
            if (noticeContent.get(SLOWNOTICE) != null) {
                slow = (Boolean)noticeContent.get(SLOWNOTICE);
            }
            boolean overtime = false;
            if (noticeContent.get(OVERTIMENOTICE) != null) {
                overtime = (Boolean)noticeContent.get(OVERTIMENOTICE);
            }
            if (overtime) {
                def.setRunTimeout(((Integer)noticeContent.get(RUNTIMEOUT)).intValue());
                messageSenderWrapper = new MessageSenderWrapper(receivers, JobServiceUtil.getOvertimeNoticeTemplates(), sendMail, sendSMS);
                def.addListener(JobEvent.OnOvertime, (Wrapper)messageSenderWrapper);
            }
            if (slow) {
                messageSenderWrapper = new MessageSenderWrapper(receivers, JobServiceUtil.getSlowNoticeTemplates(), sendMail, sendSMS);
                def.addListener(JobEvent.OnSlow, (Wrapper)messageSenderWrapper);
            }
            if (failure) {
                def.addListener(JobEvent.OnFailed, (Wrapper)msgSender);
            }
            if (complete) {
                def.addListener(JobEvent.OnComplete, (Wrapper)msgSender);
            }
            if (abort) {
                def.addListener(JobEvent.OnMissed, (Wrapper)msgSender);
            }
        }
        return def;
    }

    public static HashMap getNoticeContent(ProcessDef pdef) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ExtendedAttributeCollection eac = pdef.getExtendedAttributes();
        if (eac != null && eac.size() > 0) {
            ExtendedAttributeDef def = null;
            def = eac.get(FAILURENOTICE);
            if (def != null) {
                map.put(FAILURENOTICE, Boolean.valueOf(def.getValue()));
            }
            if ((def = eac.get(COMPLETENOTICE)) != null) {
                map.put(COMPLETENOTICE, Boolean.valueOf(def.getValue()));
            }
            if ((def = eac.get(ABORTNOTICE)) != null) {
                map.put(ABORTNOTICE, Boolean.valueOf(def.getValue()));
            }
            if ((def = eac.get(SLOWNOTICE)) != null) {
                map.put(SLOWNOTICE, Boolean.valueOf(def.getValue()));
            }
            if ((def = eac.get(OVERTIMENOTICE)) != null) {
                map.put(OVERTIMENOTICE, Boolean.valueOf(def.getValue()));
            }
            if ((def = eac.get(RUNTIMEOUT)) != null) {
                map.put(RUNTIMEOUT, Integer.valueOf(def.getValue()));
            }
            if ((def = eac.get(SENDSMS)) != null) {
                map.put(SENDSMS, Boolean.valueOf(def.getValue()));
            }
            if ((def = eac.get(SENDMAIL)) != null) {
                map.put(SENDMAIL, Boolean.valueOf(def.getValue()));
            }
            if ((def = eac.get(NOTICETIELE_L1)) != null) {
                map.put(NOTICETIELE_L1, def.getValue());
            }
            if ((def = eac.get(NOTICETIELE_L2)) != null) {
                map.put(NOTICETIELE_L2, def.getValue());
            }
            if ((def = eac.get(NOTICETIELE_L3)) != null) {
                map.put(NOTICETIELE_L3, def.getValue());
            }
            if ((def = eac.get(NOTICECONTENT_L1)) != null) {
                map.put(NOTICECONTENT_L1, def.getValue());
            }
            if ((def = eac.get(NOTICECONTENT_L2)) != null) {
                map.put(NOTICECONTENT_L2, def.getValue());
            }
            if ((def = eac.get(NOTICECONTENT_L3)) != null) {
                map.put(NOTICECONTENT_L3, def.getValue());
            }
        }
        return map;
    }

    public static String getDataFieldValue(ProcessDef ps, String name) {
        if (ps != null) {
            DataFieldCollection dc = ps.getDataFields();
            int count = dc.size();
            for (int i = 0; i <= count - 1; ++i) {
                DataFieldDef df = dc.get(i);
                if (!df.getName().equals(name)) continue;
                return df.getInitValue();
            }
        }
        return "";
    }

    private static MessageSenderWrapper.MessageTemplate[] getDefaultMessageTemplates() {
        MessageSenderWrapper.MessageTemplate[] temps = new MessageSenderWrapper.MessageTemplate[3];
        String title = null;
        String body = null;
        title = "Background Services (<% Title%>) <% State%>!";
        body = "Please use\u201c system function -> Background Services -> Background Service Monitoring\u201d to see the name of background matter is title (<% title%>)  detail information,Or directly click on the\u201cBill\u201dbutton to see more information.";
        temps[0] = new MessageSenderWrapper.MessageTemplate(new Locale("l1"), title, body);
        title = "\u540e\u53f0\u4e8b\u52a1 {<%\u6807\u9898%>}  <%\u72b6\u6001%> !";
        body = "\u8bf7\u901a\u8fc7 \u201c \u7cfb\u7edf\u529f\u80fd -> \u540e\u53f0\u4e8b\u52a1 -> \u540e\u53f0\u4e8b\u52a1\u76d1\u63a7\u201d \u67e5\u770b \u201c\u6807\u9898\u201d \u4e3a {<%\u6807\u9898%>} \u7684\u540e\u53f0\u4e8b\u52a1\u7684\u8be6\u7ec6\u4fe1\u606f\uff1b\u6216\u76f4\u63a5\u70b9\u51fb\u201c\u5355\u636e\u201d\u6309\u94ae\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002";
        temps[1] = new MessageSenderWrapper.MessageTemplate(new Locale("l2"), title, body);
        title = "\u5f8c\u81fa\u4e8b\u52d9 {<%\u6a19\u984c%>}  <%\u72c0\u614b%> !";
        body = "\u8acb\u901a\u904e \u201c \u7cfb\u7d71\u529f\u80fd -> \u5f8c\u81fa\u4e8b\u52d9 -> \u5f8c\u81fa\u4e8b\u52d9\u76e3\u63a7\u201d \u67e5\u770b\u6a19\u984c\u70ba {<%\u6a19\u984c%>} \u7684\u5f8c\u81fa\u4e8b\u52d9\u7684\u8a73\u7d30\u4fe1\u606f\uff1b\u6216\u76f4\u63a5\u9ede\u64ca\u201c\u55ae\u64da\u201d\u6309\u9215\u67e5\u770b\u8a73\u7d30\u4fe1\u606f\u3002";
        temps[2] = new MessageSenderWrapper.MessageTemplate(new Locale("l3"), title, body);
        return temps;
    }

    private static MessageSenderWrapper.MessageTemplate[] getSlowNoticeTemplates() {
        MessageSenderWrapper.MessageTemplate[] temps = new MessageSenderWrapper.MessageTemplate[3];
        String title = null;
        String body = null;
        title = "Background Services (<% Title%>) havent been finished,please adjust the execute plan,extend the interval time";
        body = "Please use\u201c system function -> Background Services -> Background Service Monitoring\u201d to see the name of background matter is title (<% title%>)  detail information,Or directly click on the\u201cBill\u201dbutton to see more information.";
        temps[0] = new MessageSenderWrapper.MessageTemplate(new Locale("l1"), title, body);
        title = "\u540e\u53f0\u4e8b\u52a1 {<%\u6807\u9898%>}  \u6267\u884c\u592a\u6162\uff0c\u8bf7\u8c03\u6574\u8c03\u5ea6\u8ba1\u5212\uff0c\u5ef6\u957f\u6267\u884c\u95f4\u9694\u65f6\u95f4\u3002";
        body = "\u8bf7\u901a\u8fc7 \u201c \u7cfb\u7edf\u529f\u80fd -> \u540e\u53f0\u4e8b\u52a1 -> \u540e\u53f0\u4e8b\u52a1\u76d1\u63a7\u201d \u67e5\u770b \u201c\u6807\u9898\u201d \u4e3a {<%\u6807\u9898%>} \u7684\u540e\u53f0\u4e8b\u52a1\u7684\u8be6\u7ec6\u4fe1\u606f\uff1b\u6216\u76f4\u63a5\u70b9\u51fb\u201c\u5355\u636e\u201d\u6309\u94ae\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002";
        temps[1] = new MessageSenderWrapper.MessageTemplate(new Locale("l2"), title, body);
        title = "\u5f8c\u53f0\u4e8b\u52d9 {<%\u6a19\u984c%>}  \u57f7\u884c\u592a\u6162\uff0c\u8acb\u8abf\u6574\u8abf\u5ea6\u8a08\u5283\uff0c\u5ef6\u9577\u57f7\u884c\u9593\u9694\u6642\u9593\u3002";
        body = "\u8acb\u901a\u904e \u201c \u7cfb\u7d71\u529f\u80fd -> \u5f8c\u81fa\u4e8b\u52d9 -> \u5f8c\u81fa\u4e8b\u52d9\u76e3\u63a7\u201d \u67e5\u770b\u6a19\u984c\u70ba {<%\u6a19\u984c%>} \u7684\u5f8c\u81fa\u4e8b\u52d9\u7684\u8a73\u7d30\u4fe1\u606f\uff1b\u6216\u76f4\u63a5\u9ede\u64ca\u201c\u55ae\u64da\u201d\u6309\u9215\u67e5\u770b\u8a73\u7d30\u4fe1\u606f\u3002";
        temps[2] = new MessageSenderWrapper.MessageTemplate(new Locale("l3"), title, body);
        return temps;
    }

    private static MessageSenderWrapper.MessageTemplate[] getOvertimeNoticeTemplates() {
        MessageSenderWrapper.MessageTemplate[] temps = new MessageSenderWrapper.MessageTemplate[3];
        String title = null;
        String body = null;
        title = "Background Services (<% Title%>) execution timeout,please adjust the execute plan,extend the interval time";
        body = "Please use\u201c system function -> Background Services -> Background Service Monitoring\u201d to see the name of background matter is title (<% title%>)  detail log information,click on the\u201cLog\u201dbutton to see more information.";
        temps[0] = new MessageSenderWrapper.MessageTemplate(new Locale("l1"), title, body);
        title = "\u540e\u53f0\u4e8b\u52a1 {<%\u6807\u9898%>}  \u6267\u884c\u8d85\u65f6\uff0c\u8bf7\u8c03\u6574\u8c03\u5ea6\u8ba1\u5212\uff0c\u5ef6\u957f\u6267\u884c\u95f4\u9694\u65f6\u95f4\u3002";
        body = "\u8bf7\u901a\u8fc7 \u201c \u7cfb\u7edf\u529f\u80fd -> \u540e\u53f0\u4e8b\u52a1 -> \u540e\u53f0\u4e8b\u52a1\u76d1\u63a7\u201d \u67e5\u770b \u201c\u6807\u9898\u201d \u4e3a {<%\u6807\u9898%>} \u7684\u540e\u53f0\u4e8b\u52a1\u6267\u884c\u60c5\u6cc1\u7684\u8be6\u7ec6\u5806\u6808\u65e5\u5fd7\u4fe1\u606f\uff1b\u70b9\u51fb\u201c\u65e5\u5fd7\u201d\u6309\u94ae\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002";
        temps[1] = new MessageSenderWrapper.MessageTemplate(new Locale("l2"), title, body);
        title = "\u5f8c\u53f0\u4e8b\u52d9 {<%\u6a19\u984c%>}  \u57f7\u884c\u8d85\u6642\uff0c\u8acb\u8abf\u6574\u8abf\u5ea6\u8a08\u5283\uff0c\u5ef6\u9577\u57f7\u884c\u9593\u9694\u6642\u9593\u3002";
        body = "\u8acb\u901a\u904e \u201c \u7cfb\u7d71\u529f\u80fd -> \u5f8c\u81fa\u4e8b\u52d9 -> \u5f8c\u81fa\u4e8b\u52d9\u76e3\u63a7\u201d \u67e5\u770b\u6a19\u984c\u70ba {<%\u6a19\u984c%>} \u7684\u5f8c\u81fa\u4e8b\u52d9\u57f7\u884c\u60c5\u6cc1\u7684\u8a73\u7d30\u5806\u68e7\u65e5\u8a8c\u4fe1\u606f\uff1b\u9ede\u64ca\u201c\u65e5\u8a8c\u201d\u6309\u9215\u67e5\u770b\u8a73\u7d30\u4fe1\u606f\u3002";
        temps[2] = new MessageSenderWrapper.MessageTemplate(new Locale("l3"), title, body);
        return temps;
    }

    private static MessageSenderWrapper.MessageTemplate[] getUserDefMessageTemplates(HashMap map) {
        ArrayList<MessageSenderWrapper.MessageTemplate> array = new ArrayList<MessageSenderWrapper.MessageTemplate>();
        MessageSenderWrapper.MessageTemplate[] message = null;
        String title_L1 = (String)map.get(NOTICETIELE_L1);
        String title_L2 = (String)map.get(NOTICETIELE_L2);
        String title_L3 = (String)map.get(NOTICETIELE_L3);
        String body_L1 = (String)map.get(NOTICECONTENT_L1);
        String body_L2 = (String)map.get(NOTICECONTENT_L2);
        String body_L3 = (String)map.get(NOTICECONTENT_L3);
        MessageSenderWrapper.MessageTemplate template_l1 = null;
        MessageSenderWrapper.MessageTemplate template_l2 = null;
        MessageSenderWrapper.MessageTemplate template_l3 = null;
        if (!StringUtils.isEmpty((String)title_L1) || !StringUtils.isEmpty((String)body_L1)) {
            if (StringUtils.isEmpty((String)title_L1)) {
                title_L1 = "Background Services (<% Title%>) <% State%>!";
            }
            if (StringUtils.isEmpty((String)body_L1)) {
                body_L1 = "Please use\u201c system function -> Background Services -> Background Service Monitoring\u201d to see the name of background matter is title (<% title%>)  detail information,Or directly click on the\u201cBill\u201dbutton to see more information.";
            }
            template_l1 = new MessageSenderWrapper.MessageTemplate(new Locale("l1"), title_L1, body_L1);
            array.add(template_l1);
        }
        if (!StringUtils.isEmpty((String)title_L2) || !StringUtils.isEmpty((String)body_L2)) {
            if (StringUtils.isEmpty((String)title_L2)) {
                title_L2 = "\u540e\u53f0\u4e8b\u52a1 {<%\u6807\u9898%>}  <%\u72b6\u6001%> !";
            }
            if (StringUtils.isEmpty((String)body_L2)) {
                body_L2 = "\u8bf7\u901a\u8fc7 \u201c \u7cfb\u7edf\u529f\u80fd -> \u540e\u53f0\u4e8b\u52a1 -> \u540e\u53f0\u4e8b\u52a1\u76d1\u63a7\u201d \u67e5\u770b\u6807\u9898\u4e3a {<%\u6807\u9898%>} \u7684\u540e\u53f0\u4e8b\u52a1\u7684\u8be6\u7ec6\u4fe1\u606f\uff1b\u6216\u76f4\u63a5\u70b9\u51fb\u201c\u5355\u636e\u201d\u6309\u94ae\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002";
            }
            template_l2 = new MessageSenderWrapper.MessageTemplate(new Locale("l2"), title_L2, body_L2);
            array.add(template_l2);
        }
        if (!StringUtils.isEmpty((String)title_L3) || !StringUtils.isEmpty((String)body_L3)) {
            if (StringUtils.isEmpty((String)title_L3)) {
                title_L3 = "\u5f8c\u81fa\u4e8b\u52d9 {<%\u6a19\u984c%>}  <%\u72c0\u614b%> !";
            }
            if (StringUtils.isEmpty((String)body_L3)) {
                body_L3 = "\u8acb\u901a\u904e \u201c \u7cfb\u7d71\u529f\u80fd -> \u5f8c\u81fa\u4e8b\u52d9 -> \u5f8c\u81fa\u4e8b\u52d9\u76e3\u63a7\u201d \u67e5\u770b\u6a19\u984c\u70ba {<%\u6a19\u984c%>} \u7684\u5f8c\u81fa\u4e8b\u52d9\u7684\u8a73\u7d30\u4fe1\u606f\uff1b\u6216\u76f4\u63a5\u9ede\u64ca\u201c\u55ae\u64da\u201d\u6309\u9215\u67e5\u770b\u8a73\u7d30\u4fe1\u606f\u3002";
            }
            template_l3 = new MessageSenderWrapper.MessageTemplate(new Locale("l3"), title_L3, body_L3);
            array.add(template_l3);
        }
        if (array.size() > 0) {
            message = new MessageSenderWrapper.MessageTemplate[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                message[i] = (MessageSenderWrapper.MessageTemplate)array.get(i);
            }
        }
        return message;
    }

    public static MessageSenderWrapper.MessageReceiver[] getResponsibles(ProcessDef def) {
        EventPolicyCollection rc;
        String responsibleName = null;
        String responsibleId = null;
        ArrayList<MessageSenderWrapper.MessageReceiver> persons = new ArrayList<MessageSenderWrapper.MessageReceiver>();
        ProcessHeaderDef header = def.getProcessHeader();
        if (header != null && (rc = header.getEventPolicies()) != null && rc.size() > 0) {
            EventPolicyDef event = rc.get(0);
            ParticipantCollection participants = event.getParticipants();
            for (int i = 0; i < participants.size(); ++i) {
                ParticipantDef res = participants.get(i);
                responsibleName = res.getName();
                responsibleId = res.getParticipantValue();
                MessageSenderWrapper.MessageReceiver p = new MessageSenderWrapper.MessageReceiver(responsibleId, responsibleName);
                persons.add(p);
            }
        }
        return persons.toArray(new MessageSenderWrapper.MessageReceiver[0]);
    }
}

