/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.application.WfSerializable;
import com.kingdee.bos.workflow.store.util.AbstractConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import com.kingdee.bos.workflow.store.util.WfSerializableConst;

public class WfSerializableConvertor
extends AbstractConvertor {
    @Override
    protected Object stringToObject(String value) throws WfException {
        if (RelevantDataType.isNULL(value)) {
            return WfSerializableConst.NULL;
        }
        try {
            String className = this.relevantData.getDataType().getClassName();
            Object obj = Class.forName(className).newInstance();
            WfSerializable objWfSerializable = (WfSerializable)obj;
            objWfSerializable.readSerializeString(value);
            return objWfSerializable;
        }
        catch (ClassNotFoundException e) {
            throw new WfException("ClassNotFoundException", e);
        }
        catch (IllegalAccessException e) {
            throw new WfException("IllegalAccessException", e);
        }
        catch (InstantiationException e) {
            throw new WfException("InstantiationException", e);
        }
    }

    @Override
    protected String objectToString(Object value) throws WfException {
        if (value == null) {
            return "##NULL##";
        }
        if (!(value instanceof WfSerializable)) {
            this.objectToStringException(value);
        }
        RelevantDataType dataType = this.relevantData.getDataType();
        String className = value.getClass().getName();
        dataType.setClassName(className);
        WfSerializable fieldValue = (WfSerializable)value;
        return fieldValue.toSerializeString();
    }

    @Override
    protected Object[] stringToArray(String value) throws WfException {
        Object[] objectArray = super.stringToArray(value);
        if (objectArray != null) {
            Object[] wfSerializableArray = new WfSerializable[objectArray.length];
            System.arraycopy(objectArray, 0, wfSerializableArray, 0, objectArray.length);
            return wfSerializableArray;
        }
        return new WfSerializable[this.relevantData.getDataType().getLength()];
    }

    public WfSerializableConvertor(RelevantData dstRelevantData) {
        super(dstRelevantData);
    }
}

