/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.upgrade;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.upgrade.BaseUpgradeManager;
import com.kingdee.bos.workflow.upgrade.IVersionMapFinder;
import com.kingdee.bos.workflow.upgrade.IVersionUpgrader;
import com.kingdee.bos.workflow.upgrade.IWfUpgrader;
import com.kingdee.bos.workflow.upgrade.UpgradeException;
import com.kingdee.bos.workflow.upgrade.VersionMapFinderFactory;
import java.util.ArrayList;
import java.util.List;

public class VersionUpgradeManager
extends BaseUpgradeManager {
    @Override
    public IWfUpgrader[] getUpgraders(Object[] params) throws UpgradeException {
        if (params == null || params.length != 4) {
            throw new IllegalArgumentException();
        }
        String oldVersion = (String)params[0];
        String curVersion = (String)params[1];
        String cName = (String)params[2];
        AbstractKpdlElement kpdlElement = (AbstractKpdlElement)params[3];
        IVersionMapFinder finder = this.getVersionMapFinder();
        int oldVersionNum = finder.getVersionBySymbol(oldVersion);
        int curVersionNum = finder.getVersionBySymbol(curVersion);
        IWfUpgrader[] rtnValue = new IWfUpgrader[]{};
        IWfUpgrader[] temp = new IWfUpgrader[]{};
        List list = this.getUpgrades(oldVersionNum, curVersionNum, cName, kpdlElement);
        temp = new IWfUpgrader[rtnValue.length + list.size()];
        System.arraycopy(rtnValue, 0, temp, 0, rtnValue.length);
        System.arraycopy(list.toArray(), 0, temp, rtnValue.length, list.toArray().length);
        rtnValue = temp;
        return rtnValue;
    }

    private List getUpgrades(int oldVersion, int curVersion, String cName, AbstractKpdlElement kpdlElement) throws UpgradeException {
        List list = this.getRegistedUpgrader();
        ArrayList<IVersionUpgrader> rtnList = new ArrayList<IVersionUpgrader>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IVersionUpgrader upgrader = (IVersionUpgrader)list.get(i);
            if (!upgrader.getUpgradeElementClass().equals(cName) || !upgrader.needUpgrade(kpdlElement, new Object[0])) continue;
            rtnList.add(upgrader);
        }
        return rtnList;
    }

    private IVersionMapFinder getVersionMapFinder() {
        return VersionMapFinderFactory.createFinder();
    }
}

