/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ExpressionCollection;
import com.kingdee.bos.workflow.define.ExpressionDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ApproveTransSuccessUtil {
    public boolean approveTransSuccess(TransitionDef transDef, ProcessDef processDef) {
        int i;
        ApproveActivityDef currentActDef = (ApproveActivityDef)transDef.getFrom();
        ExpressionCollection expressionCollection = transDef.getCondition().getXpressionList();
        if (expressionCollection == null || expressionCollection.size() == 0) {
            return true;
        }
        ExpressionDef express = expressionCollection.get(0);
        if (express == null || express.toString().trim().length() == 0) {
            return true;
        }
        String newExpression = express.toString();
        FormalParameterCollection fcoll = currentActDef.getRelatedApplication().getFormalParameters();
        DataFieldCollection coll = processDef.getDataFields();
        HashMap<String, Object> approveExpr = new HashMap<String, Object>();
        for (i = 0; i < coll.size(); ++i) {
            DataFieldDef flowvar = coll.get(i);
            if (flowvar.getDataType() != BasicType.APPROVERESULT && flowvar.getDataType() != ExternalType.OBJECT && flowvar.getDataType() != BasicType.BIZOBJ) continue;
            this.genIsPass(flowvar.getName(), approveExpr, true);
            this.genManualDecision(flowvar.getName(), currentActDef, approveExpr, true);
        }
        for (i = 3; i < fcoll.size(); ++i) {
            FormalParameterDef formal = fcoll.get(i);
            String dataFiledId = currentActDef.getActualParameters().get(i).getExpr();
            String name = coll.get(dataFiledId).getName();
            if ("isPass".equals(formal.getPropertyName())) {
                this.genIsPass(name, approveExpr, false);
            }
            if (!"handlerOpinion".equals(formal.getPropertyName())) continue;
            this.genManualDecision(name, currentActDef, approveExpr, false);
        }
        boolean ismatch = true;
        for (Map.Entry entry : approveExpr.entrySet()) {
            if (!this.match((String)entry.getKey(), newExpression)) continue;
            if (entry.getValue() instanceof Boolean) {
                if (Boolean.parseBoolean(entry.getValue().toString())) continue;
                ismatch = false;
                break;
            }
            String val = entry.getValue().toString();
            String[] vals = val.split(";");
            if (!"false".equals(vals[0])) continue;
            ismatch = false;
            break;
        }
        return ismatch;
    }

    private void genIsPass(String expr, Map<String, Object> approveExpr, boolean isObj) {
        if (approveExpr.get(expr) != null) {
            return;
        }
        ArrayList<String> exprs = new ArrayList<String>();
        exprs.add(expr);
        if (isObj) {
            exprs.add(expr + "\\s*.\\s*isPass");
        }
        for (String item : exprs) {
            approveExpr.put(item + "\\s*==\\s*\"true\"", true);
            approveExpr.put(item + "\\s*==\\s*\"false\"", false);
            approveExpr.put(item + "\\s*!=\\s*\"true\"", false);
            approveExpr.put(item + "\\s*!=\\s*\"false\"", true);
        }
    }

    private void genManualDecision(String expr, ApproveActivityDef currentActDef, Map<String, Object> approveExpr, boolean isObj) {
        String itemStr = this.ManualDecisionStr(currentActDef);
        if (itemStr.equals("0;\u65e0;\u5168\u90e8;")) {
            itemStr = null;
        }
        if (itemStr == null || itemStr.length() == 0) {
            itemStr = "0;\u540c\u610f;\u540c\u610f;:1;\u4e0d\u540c\u610f;\u4e0d\u540c\u610f;";
        }
        String[] items = itemStr.split(":");
        if (approveExpr.get(expr) != null) {
            return;
        }
        ArrayList<String> exprs = new ArrayList<String>();
        exprs.add(expr);
        if (isObj) {
            exprs.add(expr + "\\s*.\\s*handlerOpinion");
        }
        for (String e : exprs) {
            for (int i = 0; i < items.length; ++i) {
                String[] decision = items[i].split(";");
                approveExpr.put(e + "\\s*==\\s*" + decision[0], decision[2].equals("\u540c\u610f") + ";" + decision[1]);
                if (items.length != 2) continue;
                approveExpr.put(e + "\\s*!=\\s*" + decision[0], !decision[2].equals("\u540c\u610f") + ";" + items[2 - i - 1].split(";")[1]);
            }
        }
    }

    private String ManualDecisionStr(ApproveActivityDef currentActDef) {
        ExtendedAttributeDef ext;
        String itemStr = currentActDef.getManualDecisionItems();
        if ((itemStr == null || itemStr.length() == 0) && (ext = currentActDef.getActivityHeader().getExtendedAttributes().get("manualDecisionItems")) != null) {
            return ext.getValue();
        }
        return itemStr;
    }

    private boolean match(String expr, String script) {
        if (script == null || script.length() == 0) {
            return false;
        }
        return Pattern.matches(".*" + expr + ".*", script);
    }
}

