/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import java.lang.reflect.Array;

public class JavaMethodUtil {
    public static String classArray2String(Class[] classes) {
        if (classes == null || classes.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < classes.length; ++i) {
            Class cls = classes[i];
            if (i > 0) {
                sb.append(";");
            }
            if (cls.isArray()) {
                sb.append(cls.getComponentType().getName()).append("[]");
                continue;
            }
            sb.append(cls.getName());
        }
        return sb.toString();
    }

    public static String classArray2String2(Class[] classes) {
        if (classes == null || classes.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < classes.length; ++i) {
            Class cls = classes[i];
            if (i > 0) {
                sb.append(",");
            }
            if (cls.isArray()) {
                sb.append(cls.getComponentType().getName()).append("[]");
            } else {
                sb.append(cls.getName());
            }
            sb.append(" arg");
            sb.append(i);
        }
        return sb.toString();
    }

    public static Class[] string2ClassArray(String s) {
        if (s == null || s.length() == 0) {
            return new Class[0];
        }
        String[] array = s.split(";");
        Class[] classes = new Class[array.length];
        for (int i = 0; i < array.length; ++i) {
            String name = array[i];
            if (name.endsWith("[]")) {
                name = name.substring(0, name.length() - 2);
                try {
                    classes[i] = Array.newInstance(JavaMethodUtil.getClass(name), 0).getClass();
                }
                catch (NegativeArraySizeException negativeArraySizeException) {}
                continue;
            }
            classes[i] = JavaMethodUtil.getClass(name);
        }
        return classes;
    }

    public static Class getClass(String name) {
        if (name.endsWith("int")) {
            return Integer.TYPE;
        }
        if (name.endsWith("boolean")) {
            return Boolean.TYPE;
        }
        if (name.endsWith("float")) {
            return Float.TYPE;
        }
        if (name.endsWith("long")) {
            return Long.TYPE;
        }
        if (name.endsWith("byte")) {
            return Byte.TYPE;
        }
        if (name.endsWith("char")) {
            return Character.TYPE;
        }
        if (name.endsWith("short")) {
            return Short.TYPE;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("class {" + name + "} not found!");
        }
    }
}

