/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.ITreeNode;
import com.kingdee.bos.workflow.biz.trans.OperationFilterType;
import com.kingdee.bos.workflow.mdo.IBizEnumObject;
import com.kingdee.bos.workflow.mdo.IEntityObject;
import com.kingdee.bos.workflow.mdo.IFunctionObject;
import com.kingdee.bos.workflow.mdo.IOperationObject;
import com.kingdee.bos.workflow.mdo.ISolutionObject;
import com.kingdee.bos.workflow.mdo.IUIActionObject;
import com.kingdee.bos.workflow.mdo.IUIObject;
import com.kingdee.bos.workflow.service.ormrpc.IMDOService;
import com.kingdee.bos.workflow.service.ormrpc.MDOServiceFactory;
import com.kingdee.util.LRUMap;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MDOHelper {
    private final LRUMap cache = new LRUMap();
    private static final Map INSTANCES = new HashMap();
    private static final Logger logger = Logger.getLogger(MDOHelper.class);
    private static final String DEFAULT_SOLUTION_NAME = "eas";
    private static final int DEFAULT_SIZE = 100;

    private MDOHelper() {
        this.cache.setMaxSize(100);
    }

    public static void cleanUp() {
        INSTANCES.clear();
    }

    public void putOperationTreeNode2Cache(String key, ITreeNode treeNode) {
        this.cache.remove((Object)key);
        this.cache.put((Object)key, (Object)treeNode);
    }

    public static MDOHelper getInstance(String solutionName) {
        if (INSTANCES.containsKey(solutionName)) {
            return (MDOHelper)INSTANCES.get(solutionName);
        }
        MDOHelper loader = new MDOHelper();
        INSTANCES.put(solutionName, loader);
        return loader;
    }

    public static synchronized MDOHelper getInstance() {
        return MDOHelper.getInstance(DEFAULT_SOLUTION_NAME);
    }

    private IMDOService getService() throws WfException {
        return MDOServiceFactory.getRemoteInstance();
    }

    private String getKey(BOSObjectType type, IMetaDataPK pk) {
        return type.toString() + pk.toString();
    }

    private String getKey(BOSObjectType mdoType, BOSObjectType type) {
        return mdoType.toString() + type.toString();
    }

    private String getKey(BOSObjectType mdoType) {
        return mdoType.toString();
    }

    private Object copy(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return ObjectUtils.createCopy((Object)object);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return object;
        }
    }

    public ITreeNode getMDBViewTreeNode(String mdBViewName, boolean isFilterEmptyPackage) throws WfException {
        ITreeNode treeNode;
        String key = "getMDBViewTreeNode" + mdBViewName + isFilterEmptyPackage;
        if (this.cache.containsKey((Object)key)) {
            treeNode = (ITreeNode)this.cache.get((Object)key);
        } else {
            treeNode = this.getService().getMDBViewTreeNode(mdBViewName, isFilterEmptyPackage);
            this.cache.put((Object)key, (Object)treeNode);
        }
        return (ITreeNode)this.copy(treeNode);
    }

    public ITreeNode getEntityTreeNode() throws WfException {
        ITreeNode treeNode;
        String key = "getEntityTreeNode";
        if (this.cache.containsKey((Object)key)) {
            treeNode = (ITreeNode)this.cache.get((Object)key);
        } else {
            treeNode = this.getService().getEntityTreeNode();
            this.cache.put((Object)key, (Object)treeNode);
        }
        return (ITreeNode)this.copy(treeNode);
    }

    public ITreeNode[] getEntityNodesNotInMDBView() throws WfException {
        ITreeNode[] treeNodes;
        String key = "getEntityNodesNotInMDBView";
        if (this.cache.containsKey((Object)key)) {
            treeNodes = (ITreeNode[])this.cache.get((Object)key);
        } else {
            treeNodes = this.getService().getEntityNodesNotInMDBView();
            this.cache.put((Object)key, (Object)treeNodes);
        }
        return (ITreeNode[])this.copy(treeNodes);
    }

    public ITreeNode getUITreeNode() throws WfException {
        ITreeNode treeNode;
        String key = "getUITreeNode";
        if (this.cache.containsKey((Object)key)) {
            treeNode = (ITreeNode)this.cache.get((Object)key);
        } else {
            treeNode = this.getService().getUITreeNode();
            this.cache.put((Object)key, (Object)treeNode);
        }
        return (ITreeNode)this.copy(treeNode);
    }

    public ITreeNode[] getUINodesNotInMDBView() throws WfException {
        ITreeNode[] treeNodes;
        String key = "getUINodesNotInMDBView";
        if (this.cache.containsKey((Object)key)) {
            treeNodes = (ITreeNode[])this.cache.get((Object)key);
        } else {
            treeNodes = this.getService().getUINodesNotInMDBView();
            this.cache.put((Object)key, (Object)treeNodes);
        }
        return (ITreeNode[])this.copy(treeNodes);
    }

    public ITreeNode getOperationTreeNode(OperationFilterType filterType) throws WfException {
        ITreeNode treeNode;
        String key = "getOperationTreeNode_" + filterType.getValue();
        if (this.cache.containsKey((Object)key)) {
            treeNode = (ITreeNode)this.cache.get((Object)key);
        } else {
            treeNode = this.getService().getOperationTreeNode(filterType);
            this.cache.put((Object)key, (Object)treeNode);
        }
        return (ITreeNode)this.copy(treeNode);
    }

    public ITreeNode[] getOperationNodesNotInMDBView(OperationFilterType filterType) throws WfException {
        String key = "getOperationNodesNotInMDBView_" + filterType.getValue();
        if (this.cache.containsKey((Object)key)) {
            return (ITreeNode[])this.cache.get((Object)key);
        }
        ITreeNode[] treeNodes = this.getService().getOperationNodesNotInMDBView(filterType);
        this.cache.put((Object)key, (Object)treeNodes);
        return treeNodes;
    }

    public IEntityObject getEntityObject(IMetaDataPK entityPK) throws WfException {
        String key = this.getKey(IEntityObject.MDO_TYPE, entityPK);
        if (this.cache.containsKey((Object)key)) {
            return (IEntityObject)this.cache.get((Object)key);
        }
        IEntityObject entityObject = this.getService().getEntityObject(entityPK);
        this.cache.put((Object)key, (Object)entityObject);
        this.cache.put((Object)this.getKey(IEntityObject.MDO_TYPE, entityObject.getType()), (Object)entityObject);
        return entityObject;
    }

    public IEntityObject getEntityObject(BOSObjectType type) throws WfException {
        String key = this.getKey(IEntityObject.MDO_TYPE, type);
        if (this.cache.containsKey((Object)key)) {
            return (IEntityObject)this.cache.get((Object)key);
        }
        IEntityObject entityObject = this.getService().getEntityObject(type);
        this.cache.put((Object)key, (Object)entityObject);
        this.cache.put((Object)this.getKey(IEntityObject.MDO_TYPE, (IMetaDataPK)new MetaDataPK(entityObject.getFullName())), (Object)entityObject);
        return entityObject;
    }

    public IUIObject getUIObject(IMetaDataPK uiPK) throws WfException {
        String key = this.getKey(IUIObject.MDO_TYPE, uiPK);
        if (this.cache.containsKey((Object)key)) {
            return (IUIObject)this.cache.get((Object)key);
        }
        IUIObject uiObject = this.getService().getUIObject(uiPK);
        this.cache.put((Object)key, (Object)uiObject);
        return uiObject;
    }

    public IUIObject getWebUIObject(IMetaDataPK uiPK) throws WfException {
        String key = this.getKey(IUIObject.MDO_TYPE, uiPK);
        if (this.cache.containsKey((Object)key)) {
            return (IUIObject)this.cache.get((Object)key);
        }
        IUIObject uiObject = this.getService().getWebUIObject(uiPK);
        this.cache.put((Object)key, (Object)uiObject);
        return uiObject;
    }

    public IFunctionObject getFunctionObject(IMetaDataPK functionPK) throws WfException {
        String key = this.getKey(IFunctionObject.MDO_TYPE, functionPK);
        if (this.cache.containsKey((Object)key)) {
            return (IFunctionObject)this.cache.get((Object)key);
        }
        IFunctionObject functionObject = this.getService().getFunctionObject(functionPK);
        this.cache.put((Object)key, (Object)functionObject);
        return functionObject;
    }

    public ISolutionObject getSolutionObject() throws WfException {
        String key = this.getKey(ISolutionObject.MDO_TYPE);
        if (this.cache.containsKey((Object)key)) {
            return (ISolutionObject)this.cache.get((Object)key);
        }
        ISolutionObject solutionObject = this.getService().getSolutionObject();
        this.cache.put((Object)key, (Object)solutionObject);
        return solutionObject;
    }

    public IBizEnumObject getBizEnumObject(IMetaDataPK enumPK) throws WfException {
        String key = this.getKey(IBizEnumObject.MDO_TYPE, enumPK);
        if (this.cache.containsKey((Object)key)) {
            return (IBizEnumObject)this.cache.get((Object)key);
        }
        IBizEnumObject bizEnumObject = this.getService().getBizEnumObject(enumPK);
        this.cache.put((Object)key, (Object)bizEnumObject);
        return bizEnumObject;
    }

    public IUIObject getBindedUIObject(IMetaDataPK functionPK, String operationName) throws WfException {
        String uiName;
        IUIActionObject uiActionObject;
        IFunctionObject functionObject = this.getFunctionObject(functionPK);
        IOperationObject operationObject = functionObject.getOperation(operationName);
        if (operationObject != null && (uiActionObject = operationObject.getUIActionObject()) != null && !StringUtils.isEmpty((String)(uiName = uiActionObject.getUIName()))) {
            return this.getUIObject((IMetaDataPK)new MetaDataPK(uiName));
        }
        return null;
    }

    public List getBindedUIObjects(IMetaDataPK functionPK, String operationName) throws WfException {
        ArrayList<IUIObject> uiObjects = new ArrayList<IUIObject>();
        IFunctionObject functionObject = this.getFunctionObject(functionPK);
        IOperationObject operationObject = functionObject.getOperation(operationName);
        if (operationObject != null) {
            String uiName;
            IUIActionObject webPageActionObject;
            String uiName2;
            IUIActionObject uiActionObject = operationObject.getUIActionObject();
            if (uiActionObject != null && !StringUtils.isEmpty((String)(uiName2 = uiActionObject.getUIName()))) {
                uiObjects.add(this.getUIObject((IMetaDataPK)new MetaDataPK(uiName2)));
            }
            if ((webPageActionObject = operationObject.getWebPageActionObject()) != null && !StringUtils.isEmpty((String)(uiName = webPageActionObject.getUIName()))) {
                uiObjects.add(this.getWebUIObject((IMetaDataPK)new MetaDataPK(uiName)));
            }
        }
        return uiObjects;
    }
}

