/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class TypeUtil {
    static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.util.TypeUtil");

    public static DataType convertTypeReferenceToDataType(TypeReference value) {
        if (value == null) {
            return null;
        }
        return TypeUtil.convertTypeReferenceToDataType(value.toString());
    }

    public static DataType convertMDataTypeToDataType(com.kingdee.bos.metadata.entity.DataType value) {
        if (com.kingdee.bos.metadata.entity.DataType.BYTE.equals((Object)value) || com.kingdee.bos.metadata.entity.DataType.SHORT.equals((Object)value) || com.kingdee.bos.metadata.entity.DataType.INTEGER.equals((Object)value)) {
            return BasicType.INTEGER;
        }
        if (com.kingdee.bos.metadata.entity.DataType.BOOLEAN.equals((Object)value)) {
            return BasicType.BOOLEAN;
        }
        if (com.kingdee.bos.metadata.entity.DataType.CHAR.equals((Object)value) || com.kingdee.bos.metadata.entity.DataType.STRING.equals((Object)value)) {
            return BasicType.STRING;
        }
        if (com.kingdee.bos.metadata.entity.DataType.FLOAT.equals((Object)value) || com.kingdee.bos.metadata.entity.DataType.DOUBLE.equals((Object)value)) {
            return BasicType.FLOAT;
        }
        if (com.kingdee.bos.metadata.entity.DataType.DATE.equals((Object)value) || com.kingdee.bos.metadata.entity.DataType.TIME.equals((Object)value) || com.kingdee.bos.metadata.entity.DataType.TIMESTAMP.equals((Object)value)) {
            return BasicType.DATETIME;
        }
        if (com.kingdee.bos.metadata.entity.DataType.OBJECTPK.equals((Object)value)) {
            return BasicType.PK;
        }
        if (com.kingdee.bos.metadata.entity.DataType.OBJECTVALUE.equals((Object)value)) {
            return BasicType.OBJECTVALUE;
        }
        if (com.kingdee.bos.metadata.entity.DataType.BOSUUID.equals((Object)value)) {
            return BasicType.BOID;
        }
        if (com.kingdee.bos.metadata.entity.DataType.DECIMAL.equals((Object)value)) {
            return ExternalType.OBJECT;
        }
        if (com.kingdee.bos.metadata.entity.DataType.ENUM.equals((Object)value)) {
            return ExternalType.ENUM;
        }
        return ExternalType.OBJECT;
    }

    public static DataType convertTypeReferenceToDataType(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        if (TypeReferenceString.INTEGER.equalsIgnoreCase(value) || TypeReferenceString.INT.equalsIgnoreCase(value) || TypeReferenceString.LONG.equalsIgnoreCase(value) || TypeReferenceString.SHORT.equalsIgnoreCase(value)) {
            return BasicType.INTEGER;
        }
        if (TypeReferenceString.BOOL.equalsIgnoreCase(value) || TypeReferenceString.BOOLEAN.equalsIgnoreCase(value)) {
            return BasicType.BOOLEAN;
        }
        if (TypeReferenceString.STRING.equalsIgnoreCase(value) || TypeReferenceString.CHAR.equalsIgnoreCase(value)) {
            return BasicType.STRING;
        }
        if (TypeReferenceString.FLOAT.equalsIgnoreCase(value) || TypeReferenceString.DOUBLE.equalsIgnoreCase(value)) {
            return BasicType.FLOAT;
        }
        if (TypeReferenceString.DATE.equalsIgnoreCase(value)) {
            return BasicType.DATETIME;
        }
        String temp = com.kingdee.bos.metadata.entity.DataType.BOSUUID.getJavaTypeName();
        temp = temp.substring(temp.lastIndexOf(46) + 1);
        if (BasicType.BOID.getTypeName().equalsIgnoreCase(value) || temp.equalsIgnoreCase(value)) {
            return BasicType.BOID;
        }
        if (BasicType.PK.getTypeName().equalsIgnoreCase(value) || TypeReferenceString.OBJECTPK.equalsIgnoreCase(value) || TypeReferenceString.IOBJECTPK.equalsIgnoreCase(value) || "com.kingdee.bos.dao.IObjectPK".equalsIgnoreCase(value)) {
            return BasicType.PK;
        }
        if (BasicType.OBJECTVALUE.getTypeName().equalsIgnoreCase(value) || "com.kingdee.bos.dao.IObjectVlaue".equalsIgnoreCase(value)) {
            return BasicType.OBJECTVALUE;
        }
        if (TypeReferenceString.ENUM.equalsIgnoreCase(value)) {
            return ExternalType.ENUM;
        }
        return ExternalType.OBJECT;
    }

    public static DataType convertEventDataTypeToDataType(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        if ("java.lang.Integer".equalsIgnoreCase(value) || "java.lang.Short".equalsIgnoreCase(value) || "java.lang.Long".equalsIgnoreCase(value)) {
            return BasicType.INTEGER;
        }
        if ("java.lang.Boolean".equalsIgnoreCase(value)) {
            return BasicType.BOOLEAN;
        }
        if ("java.lang.String".equalsIgnoreCase(value) || "java.lang.Character".equalsIgnoreCase(value)) {
            return BasicType.STRING;
        }
        if ("java.lang.Float".equalsIgnoreCase(value) || "java.lang.Double".equalsIgnoreCase(value) || "java.math.BigDecimal".equalsIgnoreCase(value)) {
            return BasicType.FLOAT;
        }
        if ("java.util.Date".equalsIgnoreCase(value) || "java.sql.Time".equalsIgnoreCase(value) || "java.sql.TimeStamp".equalsIgnoreCase(value)) {
            return BasicType.DATETIME;
        }
        if ("com.kingdee.bos.util.BOSUuid".equalsIgnoreCase(value)) {
            return BasicType.BOID;
        }
        if ("com.kingdee.bos.dao.ormapping.ObjectUuidPK".equalsIgnoreCase(value)) {
            return BasicType.PK;
        }
        if ("com.kingdee.util.enum.Enum".equalsIgnoreCase(value)) {
            return ExternalType.ENUM;
        }
        if ("com.kingdee.bos.dao.IObjectValue".equalsIgnoreCase(value)) {
            return BasicType.OBJECTVALUE;
        }
        return ExternalType.OBJECT;
    }

    private static class TypeReferenceString {
        public static String INTEGER = "Integer";
        public static String CHAR = "Char";
        public static String FLOAT = "Float";
        public static String DATE = "Date";
        public static String BOOLEAN = "Boolean";
        public static String BYTE = "byte";
        public static String DOUBLE = "Double";
        public static String LONG = "Long";
        public static String SHORT = "Short";
        public static String BOOL = "boolean";
        public static String INT = "int";
        public static String STRING = "String";
        public static String OBJECTPK = "OBJECTPK";
        public static String IOBJECTPK = "IOBJECTPK";
        public static String BOSUUID = "BOSUUID";
        public static String DECIMAL = "DECIMAL";
        public static String OBJECTVALUE = "OBJECTVALUE";
        public static String ENUM = "ENUM";

        private TypeReferenceString() {
        }
    }
}

