/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;

public class WorkflowClusterConfig {
    private static WorkflowClusterConfig instance = null;
    public static final String CONFIG_ITEM_WORKFLOWCLUSTER = "Workflow/Cluster";
    public static final String TYPE_MASTER_SLAVE = "masterSlave";
    public static final String TYPE_GROUP = "group";
    public static final String TYPE_STANDALONE = "standAlone";
    public static final String CONFIG_KEY_TYPE = "type";
    public static final String CONFIG_KEY_CLUSTERNAME = "clusterName";
    public static final String CONFIG_KEY_CLUSTER_PROTOCOL = "protocol";
    public static final String DEFAULT_PROTOCOL = "UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:STATE_TRANSFER:QUEUE";
    public static final String DEFAULT_CLUSTERNAME = "KINGDEE_WORKFLOW_CLUSTER";
    private String clusterType = "standAlone";
    private String clusterName = "KINGDEE_WORKFLOW_CLUSTER";
    private String protocol = "UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:STATE_TRANSFER:QUEUE";
    private final ORMServiceLocation serviceLocation;

    public WorkflowClusterConfig() {
        ConfigurationItem configItem = Configuration.getInstance().getConfigItemByPath(CONFIG_ITEM_WORKFLOWCLUSTER);
        if (configItem != null) {
            String typeString = configItem.getProperty(CONFIG_KEY_TYPE);
            this.clusterType = StringUtils.isEmpty((String)typeString) ? TYPE_STANDALONE : typeString;
            this.clusterName = configItem.getProperty(CONFIG_KEY_CLUSTERNAME, DEFAULT_CLUSTERNAME);
            this.protocol = configItem.getProperty(CONFIG_KEY_CLUSTER_PROTOCOL, DEFAULT_PROTOCOL);
        }
        this.serviceLocation = new ORMServiceLocation("Workflow");
    }

    public boolean isGroupType() {
        return false;
    }

    public boolean isStandAloneType() {
        return TYPE_STANDALONE.equalsIgnoreCase(this.clusterType) || TYPE_GROUP.equalsIgnoreCase(this.clusterType);
    }

    public boolean isMasterSlaveType() {
        return TYPE_MASTER_SLAVE.equalsIgnoreCase(this.clusterType);
    }

    public boolean isMaster() {
        if (this.isMasterSlaveType()) {
            return this.serviceLocation.isLocal();
        }
        throw new IllegalArgumentException(" The current cluster is not masterSlave");
    }

    public static WorkflowClusterConfig getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new WorkflowClusterConfig();
        return instance;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getProtocol() {
        return this.protocol;
    }
}

