/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.workflow.define.WfKpdlParseException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlUtil {
    public static SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat DTF = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");

    public static String readText(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        String val = element.getText();
        return val == null ? null : val.intern();
    }

    public static String readStringAttr(Element element, String attrName) {
        assert (attrName != null);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        String val = element.getAttributeValue(attrName);
        return val == null ? null : val.intern();
    }

    public static String readString(Element element, String subElementName, Namespace ns) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            return null;
        }
        return XmlUtil.readText(subElem);
    }

    public static String readStringSubAttr(Element element, String subElementName, String attrName, Namespace ns) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            return null;
        }
        return XmlUtil.readStringAttr(subElem, attrName);
    }

    public static int readInt(Element element, String subElementName, Namespace ns) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            throw new IllegalArgumentException();
        }
        return Integer.parseInt(subElem.getText());
    }

    public static int readInt(Element element, String subElementName, Namespace ns, int defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            return defaultValue;
        }
        return Integer.parseInt(subElem.getText());
    }

    public static Date readDate(Element element, String subElementName, Namespace ns) throws ParseException {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").parse(subElem.getText());
    }

    public static Timestamp readTimeStamp(Element element, String subElementName, Namespace ns) throws ParseException {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            return null;
        }
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss").parse(subElem.getText());
            return new Timestamp(date.getTime());
        }
        catch (Exception _) {
            return new Timestamp(new Date(5000, 0, 1).getTime());
        }
    }

    public static void readExtendedAttributes(Element element, Namespace ns, Map extendedAttributes) {
        List elemList = element.getChildren("ExtendedAttribute", ns);
        for (int i = 0; i < elemList.size(); ++i) {
            Element elem = (Element)elemList.get(i);
            String attrName = XmlUtil.readStringAttr(elem, "Name");
            String attrValue = XmlUtil.readText(elem);
            extendedAttributes.put(attrName, attrValue);
        }
    }

    public static String elementToString(Element element) {
        if (element != null) {
            Document XMLDoc = new Document(element);
            Format format = Format.getPrettyFormat();
            format.setIndent("  ");
            XMLOutputter xml = new XMLOutputter(format);
            return xml.outputString(XMLDoc);
        }
        return "";
    }

    public static Element stringToElement(String str) throws WfKpdlParseException {
        Document doc;
        ByteArrayInputStream inputStream;
        if (str == null || str.length() == 0) {
            return null;
        }
        try {
            inputStream = new ByteArrayInputStream(str.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new WfKpdlParseException("UnsupportedEncodingException", ex);
        }
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        try {
            doc = builder.build((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new WfKpdlParseException("builder doc dom error.", e);
        }
        return doc.getRootElement();
    }

    public static String trim(String str) {
        return str != null ? str.trim() : null;
    }

    public static String convertXMLstr(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer output = new StringBuffer("");
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '&') {
                output.append("&amp;");
                continue;
            }
            if (ch == '<') {
                output.append("&lt;");
                continue;
            }
            if (ch == '>') {
                output.append("&gt;");
                continue;
            }
            if (ch == '\'') {
                output.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }
}

