/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util.cache;

import com.kingdee.bos.workflow.util.cache.BinaryCacheLoader;
import com.kingdee.bos.workflow.util.cache.BinaryCachePolicy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BinaryCache {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.cache.BinaryCache");
    private File cacheRoot;
    private File dataDir;
    private BinaryCacheLoader loader;
    private BinaryCachePolicy policy;
    private static Map regions = Collections.synchronizedMap(new HashMap());

    public static BinaryCache createCache(String regionName) {
        return BinaryCache.createCache(null, regionName);
    }

    public static BinaryCache createCache(File cacheRoot, String regionName) {
        if (regions.get(regionName) != null) {
            return (BinaryCache)regions.get(regionName);
        }
        return new BinaryCache(cacheRoot, regionName);
    }

    public static BinaryCache getCache(String regionName) {
        return (BinaryCache)regions.get(regionName);
    }

    private BinaryCache(File cacheRoot, String regionName) {
        this.cacheRoot = cacheRoot;
        if (this.cacheRoot == null) {
            this.cacheRoot = this.makeTemp();
        } else if (cacheRoot.isFile()) {
            logger.error((Object)"cacheRoot can not be file");
            this.cacheRoot = this.makeTemp();
        }
        this.mkDataDir(regionName);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("create binary cache on\t" + this.dataDir.toString()));
        }
        regions.put(regionName, this);
    }

    public void setLoader(BinaryCacheLoader loader) {
        this.loader = loader;
    }

    public void setPolicy(BinaryCachePolicy policy) {
        this.policy = policy;
    }

    private File makeTemp() {
        try {
            File file = File.createTempFile("oldman", ".shaniao");
            file.delete();
            file.mkdir();
            file.deleteOnExit();
            return file.getParentFile();
        }
        catch (IOException e) {
            logger.error((Object)"Cant NOT create temp dir.");
            return null;
        }
    }

    private void mkDataDir(String regionName) {
        File regionDir = new File(this.cacheRoot, regionName);
        if (!regionDir.exists()) {
            regionDir.mkdirs();
        }
        this.dataDir = new File(regionDir, "data");
        if (!this.dataDir.exists()) {
            this.dataDir.mkdir();
        }
    }

    public Serializable load(Object args) {
        return this.loader == null ? null : this.loader.loadObject(args);
    }

    public Serializable getEntry(String key) {
        Serializable entryObj = null;
        File destFile = new File(this.dataDir, key);
        if (this.exists(key)) {
            entryObj = this.readObjFromFile(destFile);
        }
        if (entryObj != null && logger.isInfoEnabled()) {
            logger.info((Object)("get entry from cache,key=\t" + key));
        }
        if (this.loader != null) {
            if (entryObj == null || this.policy != null && this.policy.needReload(entryObj, destFile)) {
                entryObj = this.loader.loadObjectByKey(key);
                this.putEntry(key, entryObj);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("get entry from cache loader,key=\t" + key));
                }
            }
        } else {
            logger.warn((Object)"cache loader is null!!!");
        }
        return entryObj;
    }

    public void putEntry(String key, Serializable obj) {
        if (obj == null) {
            return;
        }
        if (!this.dataDir.exists() && !this.dataDir.mkdirs()) {
            return;
        }
        File dataFile = new File(this.dataDir, key);
        if (this.policy != null) {
            if (!this.policy.needRefresh(obj, dataFile) && logger.isInfoEnabled()) {
                logger.info((Object)"needn't to update binary cache!");
            }
            return;
        }
        this.writeObjToFile(obj, dataFile);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("put entry into cache,key=\t" + key));
        }
    }

    public boolean exists(String key) {
        try {
            File cacheFile = new File(this.dataDir, key);
            return cacheFile.exists();
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public void removeEntry(String key) {
        try {
            File cacheFile = new File(this.dataDir, key);
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        try {
            File[] cacheFiles = this.dataDir.listFiles();
            int n = cacheFiles.length;
            for (int i = 0; i < n; ++i) {
                cacheFiles[i].delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObjToFile(Serializable obj, File dataFile) {
        assert (obj != null && dataFile != null);
        if (!dataFile.isFile()) {
            dataFile.delete();
        }
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(dataFile));
        }
        catch (Exception e) {
            logger.error((Object)"could not create data file", (Throwable)e);
            return;
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(os);
            oos.writeObject(obj);
        }
        catch (Exception e) {
            logger.error((Object)"serilize object error", (Throwable)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable readObjFromFile(File dataFile) {
        assert (dataFile != null);
        BufferedInputStream is = null;
        try {
            if (!dataFile.exists()) {
                return null;
            }
            is = new BufferedInputStream(new FileInputStream(dataFile));
        }
        catch (Exception e) {
            logger.error((Object)"read data file error", (Throwable)e);
            return null;
        }
        if (is != null) {
            try {
                ObjectInputStream ois = new ObjectInputStream(is);
                Object rtv = ois.readObject();
                Serializable serializable = (Serializable)rtv;
                return serializable;
            }
            catch (Exception e) {
                logger.error((Object)"read object error", (Throwable)e);
                Serializable serializable = null;
                return serializable;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public int getCacheFileSize() {
        return this.dataDir.list().length;
    }

    public Serializable[] getEntries() {
        File[] cacheFiles = this.dataDir.listFiles();
        Serializable[] entries = new Serializable[cacheFiles.length];
        int n = cacheFiles.length;
        for (int i = 0; i < n; ++i) {
            entries[i] = this.readObjFromFile(cacheFiles[i]);
        }
        return entries;
    }
}

