/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util.cache;

import com.kingdee.bos.cache.CacheLoader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UtilCache {
    private Map objMap;
    private CacheLoader loader;
    private final long timeOut;
    private long lastClearTime = System.currentTimeMillis();
    private long lastVisitTime = System.currentTimeMillis();
    private long totalVisit;
    private static Map regions = Collections.synchronizedMap(new HashMap());

    private UtilCache(CacheLoader loader, long timeOut) {
        this.loader = loader;
        this.timeOut = timeOut;
        this.lastClearTime = System.currentTimeMillis();
        this.objMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UtilCache createRegion(String cacheName, CacheLoader loader, long timeOut) {
        if (regions.containsKey(cacheName)) {
            return (UtilCache)regions.get(cacheName);
        }
        UtilCache region = new UtilCache(loader, timeOut);
        Map map = regions;
        synchronized (map) {
            regions.put(cacheName, region);
        }
        return region;
    }

    public static UtilCache getRegion(String cacheName) {
        return (UtilCache)regions.get(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destoryRegion(String cacheName) {
        if (regions.containsKey(cacheName)) {
            Map map = regions;
            synchronized (map) {
                regions.remove(cacheName);
            }
        }
    }

    public synchronized Entry[] getObjects() {
        Entry[] entries = new Entry[this.objMap.values().size()];
        System.arraycopy(this.objMap.values().toArray(new Entry[0]), 0, entries, 0, entries.length);
        return entries;
    }

    private synchronized void visit(int append) {
        this.lastVisitTime = System.currentTimeMillis();
        this.totalVisit += (long)append;
    }

    private synchronized Entry getEntry(Object name, boolean create) {
        Entry ent = (Entry)this.objMap.get(name);
        if (ent == null && (create || this.loader != null)) {
            ent = new Entry(name);
            this.objMap.put(name, ent);
        }
        return ent;
    }

    public void put(Object key, Object val) {
        Entry entry = this.getEntry(key, true);
        entry.put(val);
        this.visit(0);
    }

    public Object get(Object key) {
        Entry ent = this.getEntry(key, true);
        if (ent == null) {
            return null;
        }
        this.visit(1);
        return ent.get();
    }

    public boolean containsKey(Object key) {
        return this.objMap.containsKey(key);
    }

    public synchronized void clearTimeOut() {
        ArrayList timeOutList = new ArrayList();
        for (Map.Entry entry : this.objMap.entrySet()) {
            Entry cacheItem = (Entry)entry.getValue();
            if (!cacheItem.checkTimeout()) continue;
            timeOutList.add(entry.getKey());
        }
        int size = timeOutList.size();
        for (int i = 0; i < size; ++i) {
            Object key = timeOutList.get(i);
            this.objMap.remove(key);
        }
        this.lastClearTime = System.currentTimeMillis();
    }

    public synchronized void remove(Object key) {
        Entry ent = (Entry)this.objMap.get(key);
        if (ent != null && ent.remove()) {
            this.objMap.remove(key);
        }
    }

    public synchronized void destroy(Object key) {
        Entry ent = (Entry)this.objMap.get(key);
        if (ent != null) {
            ent.destroy();
        }
        this.objMap.remove(key);
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public synchronized long getLastVistTime() {
        return this.lastVisitTime;
    }

    public long getTotalHit() {
        long totalVisitCount = 0L;
        for (Map.Entry entry : this.objMap.entrySet()) {
            Entry cacheItem = (Entry)entry.getValue();
            totalVisitCount += cacheItem.getHitCount();
        }
        return totalVisitCount;
    }

    public long getTotalVisit() {
        return this.totalVisit;
    }

    public long getLastClearTime() {
        return this.lastClearTime;
    }

    public long getSize() {
        return this.objMap.size();
    }

    class Entry {
        private Object value = null;
        private WeakReference ref = null;
        private long hitCount = 0L;
        private long lastHitTime = 0L;
        private final Object name;
        private boolean isDestroyed = false;

        Entry(Object name) {
            this.name = name;
        }

        Object getKey() {
            return this.name;
        }

        synchronized long getLastHitTime() {
            return this.lastHitTime;
        }

        synchronized long getHitCount() {
            return this.hitCount;
        }

        synchronized Object get() {
            this.lastHitTime = System.currentTimeMillis();
            Object val = null;
            val = this.value;
            if (val == null && this.ref != null) {
                val = this.ref.get();
            }
            if (val != null) {
                if (this.value == null) {
                    this.value = val;
                }
            } else {
                this.ref = null;
                if (UtilCache.this.loader != null) {
                    val = UtilCache.this.loader.load(this.name);
                }
                if (val != null) {
                    this.value = val;
                }
            }
            this.lastHitTime = System.currentTimeMillis();
            ++this.hitCount;
            this.isDestroyed = false;
            return val;
        }

        synchronized Object getValue() {
            return this.value;
        }

        synchronized void put(Object val) {
            this.lastHitTime = System.currentTimeMillis();
            this.value = val;
            this.ref = null;
            this.isDestroyed = false;
        }

        synchronized void destroy() {
            this.value = null;
            this.ref = null;
            this.isDestroyed = true;
        }

        synchronized boolean remove() {
            if (this.value != null) {
                this.ref = new WeakReference<Object>(this.value);
                this.value = null;
                this.isDestroyed = true;
                return false;
            }
            if (this.ref == null) {
                this.isDestroyed = true;
                return true;
            }
            this.isDestroyed = this.ref.get() == null;
            return this.isDestroyed;
        }

        synchronized boolean checkTimeout() {
            if (System.currentTimeMillis() - this.lastHitTime < UtilCache.this.timeOut) {
                return false;
            }
            return this.remove();
        }

        synchronized long getIdleTime() {
            return System.currentTimeMillis() - this.lastHitTime;
        }

        synchronized boolean isDestroyed() {
            return this.isDestroyed;
        }
    }
}

