/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.codingrule.CodingRuleCollection;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgCollection;
import com.kingdee.eas.base.codingrule.ICodingRule;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.client.CodingRuleClientUtils;
import com.kingdee.eas.base.codingrule.client.CodingRuleListUI_Define;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CodingRuleClientUtil {
    private static final Logger logger = CoreUIObject.getLogger(CodingRuleClientUtil.class);
    private static final String STR_RESOURCE = "com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource.";
    private static Map childBoTypeMap;

    public static Map getMapInstance() {
        if (childBoTypeMap == null) {
            childBoTypeMap = new HashMap();
        }
        return childBoTypeMap;
    }

    public static void addItemIntoChildBoTypeMap(String key, String value) {
        CodingRuleClientUtil.getMapInstance();
        childBoTypeMap.put(key, value);
    }

    public static String getItemFromChildBoType(String key) {
        return String.valueOf(childBoTypeMap.get(key));
    }

    public static CodingRuleCollection checkCodingRuleCollection(CodingRuleCollection col) {
        CodingRuleCollection tmp = (CodingRuleCollection)((Object)col.clone());
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(0).getBindingProExtent() == null || col.get(0).getBindingProExtent().size() < 1) continue;
            tmp.remove(col.get(0));
        }
        return tmp;
    }

    public static EntityViewInfo getEntityViewInfo(CodingRuleInfo codRuleInfo) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)codRuleInfo.getBusinessObjectID()));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)true));
        if (!StringUtils.isEmpty((String)codRuleInfo.getCustomProperty())) {
            filter.getFilterItems().add(new FilterItemInfo("customProperty", (Object)codRuleInfo.getCustomProperty()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("customProperty", null));
        }
        evi.setFilter(filter);
        return evi;
    }

    public static boolean enableCodingRule(KDTable table, Component comp, ICodingRule codRule, CodingRuleInfo codRuleInfo) throws BOSException {
        String strMsg = "";
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)codRuleInfo.getBusinessObjectID()));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)true));
        if (!StringUtils.isEmpty((String)codRuleInfo.getCustomProperty())) {
            filter.getFilterItems().add(new FilterItemInfo("customProperty", (Object)codRuleInfo.getCustomProperty()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("customProperty", null));
        }
        evi.setFilter(filter);
        CodingRuleCollection codRuleCollection = codRule.getCodingRuleCollection(evi);
        if (codRuleCollection.size() == 0) {
            strMsg = "Msg_BeSureEnable";
        } else {
            if (codRuleInfo.getBindingProperty() != null) {
                filter.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyName", (Object)codRuleInfo.getBindingProperty().getPropertyName()));
                filter.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyValue", (Object)codRuleInfo.getBindingProperty().getPropertyValue().toString()));
                evi.setFilter(filter);
                codRuleCollection = codRule.getCodingRuleCollection(evi);
            }
            if ((codRuleCollection = codRuleInfo.getBindingProExtent().size() > 0 ? CodingRuleManagerFactory.getRemoteInstance().checkMoreAdapt(codRuleInfo) : CodingRuleClientUtil.checkCodingRuleCollection(codRuleCollection)).size() > 0) {
                if (codRuleInfo.isGroupFirst()) {
                    strMsg = "Msg_GroupEnableInsteadAllEnable";
                }
                if (codRuleInfo.isOrgFirst()) {
                    if (codRuleCollection.size() == 1 && codRuleCollection.get(0).isGroupFirst() && "00000000-0000-0000-0000-000000000000CCE7AED4".equals(codRuleCollection.get(0).getAppOrgUnit().getId().toString())) {
                        if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString())) {
                            return CodingRuleClientUtil.crEnable(table, comp, codRuleInfo, "Msg_OrgEnableInsteadGroupEnable");
                        }
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_HasGroupEnable"));
                        return false;
                    }
                    CodingRuleMultiOrgCollection orgCol = CodingRuleClientUtils.getMultiOrgCRs(codRuleInfo.getAppOrgUnit().getId().toString());
                    for (int orgIndex = 0; orgIndex < orgCol.size(); ++orgIndex) {
                        CodingRuleInfo tmpCr = orgCol.get(orgIndex).getCodingrule();
                        if (!codRuleInfo.getBusinessObject().equalsIgnoreCase(tmpCr.getBusinessObject()) || !tmpCr.isIsEnabled() || (tmpCr.getBindingProperty() != null || codRuleInfo.getBindingProperty() != null) && (tmpCr.getBindingProperty() == null || codRuleInfo.getBindingProperty() == null || !StringUtils.equals((String)tmpCr.getBindingProperty().getPropertyName(), (String)codRuleInfo.getBindingProperty().getPropertyName()) || !StringUtils.equals((String)tmpCr.getBindingProperty().getPropertyValue(), (String)codRuleInfo.getBindingProperty().getPropertyValue()))) continue;
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_HasMultiOrgEnable"));
                        return false;
                    }
                    filter.getFilterItems().add(new FilterItemInfo("appOrgUnit", (Object)codRuleInfo.getAppOrgUnit().getId().toString()));
                    evi.setFilter(filter);
                    CodingRuleCollection temp = codRule.getCodingRuleCollection(evi);
                    temp = codRuleInfo.getBindingProExtent().size() > 0 ? CodingRuleManagerFactory.getRemoteInstance().checkMoreAdapt(codRuleInfo) : CodingRuleClientUtil.checkCodingRuleCollection(temp);
                    strMsg = temp.size() == 0 ? "Msg_BeSureEnable" : "Msg_OrgEnableInsteadSameOrgEnable";
                }
                if (codRuleInfo.isMultiOrgFirst()) {
                    if (codRuleCollection.size() == 1 && codRuleCollection.get(0).isGroupFirst() && "00000000-0000-0000-0000-000000000000CCE7AED4".equals(codRuleCollection.get(0).getAppOrgUnit().getId().toString())) {
                        if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString())) {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_HasGroupEnable"));
                            return false;
                        }
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_HasGroupEnable"));
                        return false;
                    }
                    StringBuffer strOrgs = new StringBuffer("");
                    for (int orgIndex = 0; orgIndex < codRuleInfo.getMultiOrg().size(); ++orgIndex) {
                        if (codRuleInfo.getMultiOrg().get(orgIndex).isIsMainOrg()) continue;
                        if (strOrgs.length() > 0) {
                            strOrgs.append(",");
                        }
                        strOrgs.append(codRuleInfo.getMultiOrg().get(orgIndex).getAppOrgUnit().getId().toString());
                    }
                    StringBuffer strInfoMsg = new StringBuffer("");
                    CodingRuleMultiOrgCollection orgCol = CodingRuleClientUtils.getMultiOrgCRs(strOrgs.toString());
                    for (int orgIndex = 0; orgIndex < orgCol.size(); ++orgIndex) {
                        CodingRuleInfo tmpCr = orgCol.get(orgIndex).getCodingrule();
                        if (!codRuleInfo.getBusinessObject().equalsIgnoreCase(tmpCr.getBusinessObject()) || !tmpCr.isIsEnabled() || (tmpCr.getBindingProperty() != null || codRuleInfo.getBindingProperty() != null) && (tmpCr.getBindingProperty() == null || codRuleInfo.getBindingProperty() == null || !StringUtils.equals((String)tmpCr.getBindingProperty().getPropertyName(), (String)codRuleInfo.getBindingProperty().getPropertyName()) || !StringUtils.equals((String)tmpCr.getBindingProperty().getPropertyValue(), (String)codRuleInfo.getBindingProperty().getPropertyValue()))) continue;
                        if (strInfoMsg.length() > 0) {
                            strInfoMsg.append(" | ");
                        }
                        strInfoMsg.append(orgCol.get(orgIndex).getAppOrgUnit().getNumber());
                    }
                    if (strInfoMsg.length() > 0) {
                        String warningMsg = EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource.Msg_MultipleOrgConfict").replaceAll("ORG_NUMBERS", strInfoMsg.toString());
                        MsgBox.showInfo((String)warningMsg);
                        return false;
                    }
                    filter.getFilterItems().add(new FilterItemInfo("appOrgUnit", (Object)strOrgs.toString(), CompareType.INCLUDE));
                    evi.setFilter(filter);
                    codRuleCollection = codRule.getCodingRuleCollection(evi);
                    codRuleCollection = codRuleInfo.getBindingProExtent().size() > 0 ? CodingRuleManagerFactory.getRemoteInstance().checkMoreAdapt(codRuleInfo) : CodingRuleClientUtil.checkCodingRuleCollection(codRuleCollection);
                    strMsg = codRuleCollection.size() == 0 ? "Msg_BeSureEnable" : "Msg_MultiOrgFirstCREnabling";
                }
            } else {
                strMsg = "Msg_BeSureEnable";
            }
        }
        return CodingRuleClientUtil.crEnable(table, comp, codRuleInfo, strMsg);
    }

    public static boolean isCustomProperty(KDTable table, String customProperty) {
        boolean isGoEnable = true;
        if (table == null) {
            return StringUtils.isEmpty((String)customProperty);
        }
        String str = "";
        str = CodingRuleClientUtil.getCustomProperty(table);
        if (!StringUtils.isEmpty((String)str) && !str.equals("number")) {
            isGoEnable = false;
        }
        return isGoEnable;
    }

    public static boolean isCustomProperty(KDTable table, CodingRuleInfo codingRule) {
        boolean isGoEnable = true;
        if (table == null) {
            return StringUtils.isEmpty((String)codingRule.getCustomProperty());
        }
        String str = "";
        str = CodingRuleClientUtil.getCustomProperty(table);
        if (!StringUtils.isEmpty((String)str) && !str.equals("number")) {
            isGoEnable = false;
        }
        return isGoEnable;
    }

    public static List getSelctList(Object table1, String str) {
        KDTable table = (KDTable)table1;
        ArrayList<String> list = new ArrayList<String>();
        String temp = "";
        KDTSelectBlock sb = table.getSelectManager().get();
        int size = table.getSelectManager().size();
        Object ob = null;
        if (size == 1 && sb.getTop() == sb.getBottom()) {
            ob = table.getRow(sb.getTop()).getCell(str).getValue();
            if (ob == null) {
                return null;
            }
            list.add(ob.toString());
        } else {
            block0: for (int i = 0; i < size; ++i) {
                int top;
                ob = null;
                sb = table.getSelectManager().get(i);
                int bottom = sb.getBottom();
                ob = table.getRow(top).getCell(str).getValue();
                if (ob == null) break;
                String temp1 = ob.toString();
                if (top == bottom && !temp.equals(temp1)) {
                    temp = temp1;
                    list.add(temp);
                    continue;
                }
                for (top = sb.getTop(); top <= bottom; ++top) {
                    ob = null;
                    ob = table.getRow(top).getCell(str).getValue();
                    if (ob == null) continue block0;
                    temp1 = ob.toString();
                    if (temp.equals(temp1)) continue;
                    temp = temp1;
                    list.add(temp);
                }
            }
        }
        return list;
    }

    public static String getCustomProperty(KDTable tblList) {
        Iterator it;
        List list = null;
        list = CodingRuleClientUtil.getSelctList(tblList, "custompro");
        String str = null;
        if (list != null && list.size() != 0 && (it = list.iterator()).hasNext()) {
            str = it.next().toString();
        }
        return str;
    }

    private static boolean crEnable(KDTable table, Component comp, CodingRuleInfo codingRule, String strMsg) {
        if (strMsg.equals("false")) {
            return false;
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)comp, (String)EASResource.getString((String)("com.kingdee.eas.base.codingrule.CodingRuleResource." + strMsg))))) {
            return false;
        }
        String codingRuleId = codingRule.getId().toString();
        boolean isCustomProperty = CodingRuleClientUtil.isCustomProperty(table, codingRule.getCustomProperty());
        RequestContext request = null;
        if (comp instanceof CodingRuleListUI_Define) {
            CodingRuleListUI_Define listUi = (CodingRuleListUI_Define)((Object)comp);
            request = listUi.prepareQueryContext(null);
        }
        Date d = new Date();
        try {
            if (CodingRuleClientUtil.isCustomProperty(table, codingRule)) {
                ICodingRuleManager iCRM = CodingRuleManagerFactory.getRemoteInstance();
                if (codingRuleId != null && codingRuleId.trim().length() > 0) {
                    try {
                        iCRM.enabledCodingRule(codingRuleId);
                    }
                    catch (CodingRuleException ex) {
                        ExceptionHandler.handle((Throwable)((Object)ex));
                        return false;
                    }
                }
            } else {
                CodingRuleClientUtil.setupCodingRuleState(d, true, codingRuleId);
            }
            return true;
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_Enabled"), (Throwable)err);
            return false;
        }
    }

    private static void prepareCallHandler(Date d, String codingRuleId, boolean isCustomProperty, RequestContext request) {
        IUIActionPostman man = UIActionPostman.getInstance(null);
        if (request == null) {
            request = new RequestContext();
        }
        request.put("codingRuleId", (Object)codingRuleId);
        request.put("isCustomProperty", (Object)new Boolean(isCustomProperty));
        request.put("enableDate", (Object)d);
        request.setClassName("com.kingdee.eas.base.codingrule.app.CodingRuleListUI_DefineHandler");
        request.setMethodName("handleCallHandlerEabled");
        man.setRequestContext((Serializable)request);
        try {
            man.callHandler();
        }
        catch (Exception e) {
            logger.error((Object)("enable call handler error:" + e));
        }
    }

    public static void setupCodingRuleState(boolean isEnable, String id) throws Exception {
        CodingRuleInfo info = CodingRuleFactory.getRemoteInstance().getCodingRuleInfo((IObjectPK)new ObjectUuidPK(id));
        info.setIsEnabled(isEnable);
        if (isEnable) {
            info.setEnabledDate(new Date());
        } else {
            info.setDisabledDate(new Date());
        }
        CodingRuleManagerFactory.getRemoteInstance().controlCustomProperty(info);
    }

    public static void setupCodingRuleState(Date d, boolean isEnable, String id) throws Exception {
        CodingRuleInfo info = CodingRuleFactory.getRemoteInstance().getCodingRuleInfo((IObjectPK)new ObjectUuidPK(id));
        info.setIsEnabled(isEnable);
        if (isEnable) {
            info.setEnabledDate(d);
        } else {
            info.setDisabledDate(d);
        }
        CodingRuleManagerFactory.getRemoteInstance().controlCustomProperty(info);
    }
}

