/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.CodingRuleCacheUtil;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.ICodingRule;
import com.kingdee.eas.base.codingrule.IntermilNOInfo;
import com.kingdee.eas.base.codingrule.MaxSerialInfo;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Date;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class CodingRuleDAO {
    private static Logger logger = Logger.getLogger(CodingRuleDAO.class);

    private CodingRuleDAO() {
    }

    public static RowSet getMaxSerialInfoValue(Context ctx, String creId, String sortItemValue) throws BOSException {
        return CodingRuleDAO.getMaxSerialInfoValueOfSegment(ctx, creId, sortItemValue, null);
    }

    public static RowSet getMaxSerialInfoValueOfSegment(Context ctx, String creId, String sortItemValue, String segAttrValue) throws BOSException {
        String debugInfo = "\u67e5\u8be2\u6700\u5927\u503c\u64cd\u4f5c\uff0c\u5206\u7c7b\u6392\u5e8f\u503c\u4e3a\uff1a" + sortItemValue + ";\u987a\u5e8f\u53f7\u5206\u5f55id\u4e3a\uff1a" + creId;
        String sql = "select FID,FSortItemValue,FSerialNumber,FCodingRuleEntryID,FInitValue  from T_BAS_MaxSerial where FCodingRuleEntryID = ? and FSortItemValue = ?";
        Object[] params = null;
        params = new Object[]{creId, sortItemValue};
        if (!StringUtils.isEmpty((String)segAttrValue)) {
            debugInfo = debugInfo + ";\u5206\u6bb5\u5c5e\u6027\u503c\u4e3a\uff1a" + segAttrValue;
            sql = sql + " and FSegmentAttrValue = ?";
            params = new Object[]{creId, sortItemValue, segAttrValue};
        }
        CodingRuleDAO.debugLog(debugInfo);
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static void addMaxSerialInfoValue(Context ctx, MaxSerialInfo ms) throws BOSException {
        String sql = null;
        Object[] params = null;
        if (ms.getSegmentAttrValue() == null || ms.getSegmentAttrValue().trim().length() == 0) {
            sql = "insert into T_BAS_MaxSerial(FID,FSortItemValue,FSerialNumber,FCodingRuleEntryID) values(?,?,?,?)";
            params = new Object[]{ms.getId().toString(), ms.getSortItemValue(), new Long(ms.getSerialNumber()), ms.getCodingRuleEntry().getId().toString()};
        } else {
            sql = "insert into T_BAS_MaxSerial(FID,FSortItemValue,FSerialNumber,FCodingRuleEntryID,FSegmentAttrValue) values(?,?,?,?,?)";
            params = new Object[]{ms.getId().toString(), ms.getSortItemValue(), new Long(ms.getSerialNumber()), ms.getCodingRuleEntry().getId().toString(), ms.getSegmentAttrValue().trim()};
        }
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static void updateMaxSerialInfoValue(Context ctx, String id, String sortItemValue, long serialNumber) throws BOSException {
        String debugInfo = "\u66f4\u65b0\u6700\u5927\u503c\u64cd\u4f5c\uff0c\u5206\u7c7b\u6392\u5e8f\u503c\u4e3a\uff1a" + sortItemValue + ";\u6700\u5927\u503cid\u4e3a\uff1a" + id;
        CodingRuleDAO.debugLog(debugInfo);
        String sql = "update T_BAS_MaxSerial set  FSerialNumber = ?,FSortItemValue = ?  where FID = ? ";
        Object[] params = new Object[]{new Long(serialNumber), sortItemValue, id};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private static void debugLog(String debugInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)debugInfo);
        }
    }

    public static void setStateOfSegment(Context ctx, String id, int state) throws BOSException {
        String sql = "update t_bas_seqsegmententry set  FState = ?  where FID = ? ";
        Object[] params = new Object[]{new Integer(state), id};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static RowSet getIntermilNOInfoValue(Context ctx, String creId, String sortItemValue, int initial, int step) throws BOSException {
        String sql = step >= 0 ? "select top 1 FID,FSerialNumber  from T_BAS_IntermitNO where FCodingRuleEntryID = ? and FSortItemValue = ? and FSerialNumber >= ? order by FSerialNumber " : "select top 1 FID,FSerialNumber  from T_BAS_IntermitNO where FCodingRuleEntryID = ? and FSortItemValue = ? and FSerialNumber < ? order by FSerialNumber ";
        Object[] params = new Object[]{creId, sortItemValue, new Integer(initial)};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static RowSet getSelectIntermilNOInfoValue(Context ctx, String creId, String sortItemValue, long number) throws BOSException {
        String sql = "select top 1 FID,FSerialNumber  from T_BAS_IntermitNO where FCodingRuleEntryID = ? and FSortItemValue = ? and FSerialNumber = ? ";
        Object[] params = new Object[]{creId, sortItemValue, new Long(number)};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static void deleteIntermilNOInfoValue(Context ctx, String id) throws BOSException {
        String sql = "delete from T_BAS_IntermitNO where FID = ? ";
        Object[] params = new Object[]{id};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static void deleteIntermilNumbers(Context ctx, String creId, String sortItemValue, String nums) throws BOSException {
        String sql = "delete from T_BAS_IntermitNO where FCodingRuleEntryID = ? and FSortItemValue = ? and FSerialNumber in (" + nums + ")";
        Object[] params = new Object[]{creId, sortItemValue};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static void addIntermilNOInfoValue(Context ctx, IntermilNOInfo inInfo) throws BOSException {
        String sql = "select fid from T_BAS_IntermitNO where FSortItemValue = ? and FSerialNumber = ? and FCodingRuleEntryID = ?";
        Object[] params = new Object[]{inInfo.getSortItemValue(), new Long(inInfo.getSerialNumber()), inInfo.getCodingRuleEntry().getId().toString()};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            if (rowset.next()) {
                return;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        sql = "insert into T_BAS_IntermitNO(FID,FSortItemValue,FSerialNumber,FCodingRuleEntryID) values(?,?,?,?)";
        params = new Object[]{inInfo.getId().toString(), inInfo.getSortItemValue(), new Long(inInfo.getSerialNumber()), inInfo.getCodingRuleEntry().getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        logger.error((Object)"insert intermitNo into T_BAS_IntermitNo success!");
    }

    public static String getCodingRuleInfoValue(Context ctx, String businessObject, String org, int ruleType) throws BOSException {
        ParmCodingRule map = null;
        return CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, ruleType, map);
    }

    public static String getCodingRuleInfoValue(Context ctx, String businessObject, String org, int ruleType, ParmCodingRule parmCodingRule) throws BOSException {
        return CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, ruleType, null, null, "");
    }

    public static String getCodingRuleInfoValue(Context ctx, String businessObject, String org, int ruleType, String propertyName, String propertyValue) throws BOSException {
        return CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, ruleType, propertyName, propertyValue, "");
    }

    public static RowSet getPropertyvalue(Context ctx, String propertyName) throws BOSException {
        String sql = "select  FPropertyValue from T_BAS_BindingProperty where FPropertyName='" + propertyName + "'";
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static String getCodingRuleInfoValue(Context ctx, String businessObject, String org, int ruleType, String propertyName, String propertyValue, ParmCodingRule parmCodingRule) throws BOSException {
        String customProperty = parmCodingRule == null ? "" : parmCodingRule.getCustomProperty();
        return CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, ruleType, propertyName, propertyValue, customProperty);
    }

    public static String getCodingRuleInfoValue(Context ctx, String businessObject, String org, int ruleType, String propertyName, String propertyValue, String customProperty) throws BOSException {
        if (businessObject == null || org == null) {
            return "";
        }
        String res = CodingRuleCacheUtil.getCodingRuleInfoFromCacheNew(businessObject, org, ruleType, propertyName, propertyValue, customProperty);
        if (!StringUtils.isEmpty((String)res)) {
            return res;
        }
        String sql = "";
        boolean isCustom = false;
        boolean isProperty = false;
        if (StringUtils.isEmpty((String)propertyName)) {
            sql = "select top 1 a.FID FID from T_BAS_CodingRule a left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid  where a.FBusinessObject = ? and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and a.FRuleType = ? and a.FIsEnabled = ? and a.FBPID is null ";
        } else {
            sql = "select top 1 a.FID FID from T_BAS_CodingRule a left join T_BAS_BindingProperty b on a.FBPID = b.FID left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid  where a.FBusinessObject = ?  and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and a.FRuleType = ? and b.FPropertyName = ?   and b.FPropertyValue = ?  and a.FIsEnabled = ?";
            isProperty = true;
        }
        if (!StringUtils.isEmpty((String)customProperty)) {
            sql = sql + "and a.FCustomProperty = ?";
            isCustom = true;
        } else {
            sql = sql + "and a.FCustomProperty is null";
        }
        Object[] params = isCustom && isProperty ? new Object[10] : (isCustom ? new Object[8] : (isProperty ? new Object[9] : new Object[7]));
        params[0] = businessObject;
        params[1] = org;
        params[2] = Boolean.FALSE;
        params[3] = org;
        params[4] = Boolean.TRUE;
        params[5] = ruleType;
        if (isCustom) {
            if (isProperty) {
                params[6] = propertyName;
                params[7] = CodingRuleDAO.getPropertyValue(propertyValue);
                params[8] = Boolean.TRUE;
                params[9] = customProperty;
            } else {
                params[6] = Boolean.TRUE;
                params[7] = customProperty;
            }
        } else if (isProperty) {
            params[6] = propertyName;
            params[7] = CodingRuleDAO.getPropertyValue(propertyValue);
            params[8] = Boolean.TRUE;
        } else {
            params[6] = Boolean.TRUE;
        }
        IRowSet ret = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            while (ret.next()) {
                res = ret.getString("FID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"get codingrule info exception:", (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        CodingRuleCacheUtil.putCodingRuleInfoToCacheNew(businessObject, org, ruleType, propertyName, propertyValue, customProperty, res);
        return res;
    }

    private static String getPropertyValue(String propertyValue) {
        String strRe = "";
        strRe = propertyValue.equals("false") ? "0" : (propertyValue.equals("true") ? "1" : propertyValue);
        return strRe;
    }

    public static RowSet getCodingRuleForUseIntermitNumber(Context ctx, String businessObject, String org, int ruleType) throws BOSException {
        String sql = "select top 1 a.FID FID,a.FIsMainRule FIsMainRule,a.FIsaddnewbreak FIsaddnewbreak from T_BAS_CodingRule a left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid  where a.FBusinessObject = ? and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and a.FRuleType = ? and a.FIsEnabled = ? and FBPID is null  ";
        Object[] params = new Object[]{businessObject, org, false, org, true, new Integer(ruleType), true};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static int getCodingRuleForUseIntermitNumberIsMainRule(Context ctx, String businessObject, String org, int ruleType) throws BOSException {
        int icm = 2;
        String sql = "select top 1 a.FID FID,a.FIsMainRule FIsMainRule from T_BAS_CodingRule a left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid  where a.FBusinessObject = ? and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and a.FRuleType = ? and a.FIsEnabled = ? and FBPID is null  ";
        Object[] params = new Object[]{businessObject, org, false, org, true, new Integer(ruleType), true};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            if (rowset.next()) {
                icm = rowset.getInt("FIsMainRule");
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return icm;
    }

    public static RowSet getCodingRuleForIsUserSelect(Context ctx, String businessObject, String org, int ruleType, String propertyName, String propertyValue) throws BOSException {
        String sql = "select top 1 a.FID FID,a.FisUserSelect FisUserSelect from T_BAS_CodingRule a left join T_BAS_BindingProperty b on a.FBPID = b.FID left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid where a.FBusinessObject = ?  and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and a.FRuleType = ? and b.FPropertyName = ?   and b.FPropertyValue = ?  and FIsEnabled = ? ";
        propertyValue = CodingRuleDAO.getPropertyValue(propertyValue);
        Object[] params = new Object[]{businessObject, org, false, org, true, new Integer(ruleType), propertyName, propertyValue, true};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static RowSet getCodingRuleForIsUserSelect(Context ctx, String businessObject, String org, int ruleType) throws BOSException {
        String sql = "select top 1 a.FID FID,a.FisUserSelect FisUserSelect from T_BAS_CodingRule a left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid where FBusinessObject = ? and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and FRuleType = ? and FIsEnabled = ? and FBPID is null  ";
        Object[] params = new Object[]{businessObject, org, false, org, true, new Integer(ruleType), true};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static RowSet getCodingRuleForIsAddView(Context ctx, String businessObject, String org, int ruleType, String propertyName, String propertyValue) throws BOSException {
        String sql = "select top 1 a.FID FID,a.FisAddView FisAddView from T_BAS_CodingRule a left join T_BAS_BindingProperty b on a.FBPID = b.FID left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid where a.FBusinessObject = ?  and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and a.FRuleType = ? and a.FBPID = b.FID and b.FPropertyName = ?   and b.FPropertyValue = ?  and FIsEnabled = ? ";
        propertyValue = CodingRuleDAO.getPropertyValue(propertyValue);
        Object[] params = new Object[]{businessObject, org, false, org, true, new Integer(ruleType), propertyName, propertyValue, true};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static RowSet getCodingRuleForIsAddView(Context ctx, String businessObject, String org, int ruleType) throws BOSException {
        String sql = "select top 1 a.FID FID,a.FisAddView FisAddView from T_BAS_CodingRule a left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid where FBusinessObject = ? and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and FRuleType = ? and FIsEnabled = ? and FBPID is null  ";
        Object[] params = new Object[]{businessObject, org, false, org, true, new Integer(ruleType), true};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static RowSet getCodingRuleForIsModifiable(Context ctx, String businessObject, String org, int ruleType, String propertyName, String propertyValue) throws BOSException {
        String sql = "select top 1 a.FID FID,a.FisModifiable FisModifiable from T_BAS_CodingRule a left join T_BAS_BindingProperty b on a.FBPID = b.FID left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid where a.FBusinessObject = ?  and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and a.FRuleType = ? and a.FBPID = b.FID and b.FPropertyName = ?   and b.FPropertyValue = ?  and FIsEnabled = ? ";
        propertyValue = CodingRuleDAO.getPropertyValue(propertyValue);
        Object[] params = new Object[]{businessObject, org, false, org, true, new Integer(ruleType), propertyName, propertyValue, true};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static RowSet getCodingRuleForIsModifiable(Context ctx, String businessObject, String org, int ruleType) throws BOSException {
        String sql = "select top 1 a.FID FID,a.FisModifiable FisModifiable from T_BAS_CodingRule a left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid where FBusinessObject = ? and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and FRuleType = ? and FIsEnabled = ? and FBPID is null  ";
        Object[] params = new Object[]{businessObject, org, false, org, true, new Integer(ruleType), true};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static RowSet getCodingRuleForUseIntermitNumber(Context ctx, String businessObject, String org, int ruleType, String propertyName, String propertyValue) throws BOSException {
        String sql = "select top 1 a.FID FID,a.FIsMainRule FIsMainRule from T_BAS_CodingRule a left join T_BAS_BindingProperty b on a.FBPID = b.FID left join T_BAS_CRMultiOrg c on c.fcodingrule = a.fid where a.FBusinessObject = ?  and ((a.FAppOrgUnit = ? and (a.FMultiOrgFirst = ? or a.FMultiOrgFirst is null)) or (c.FAppOrgUnit = ? and a.FMultiOrgFirst = ? and c.FIsMainOrg = 0)) and a.FRuleType = ? and a.FBPID = b.FID and b.FPropertyName = ?   and b.FPropertyValue = ?  and FIsEnabled = ? ";
        propertyValue = CodingRuleDAO.getPropertyValue(propertyValue);
        Object[] params = new Object[]{businessObject, org, false, org, true, new Integer(ruleType), propertyName, propertyValue, true};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static int getCodingRuleForUseIntermitNumbeIsMainRule(Context ctx, String businessObject, String org, int ruleType, String propertyName, String propertyValue) throws BOSException {
        int icm = -1;
        RowSet rowset = CodingRuleDAO.getCodingRuleForUseIntermitNumber(ctx, businessObject, org, ruleType, propertyName, propertyValue);
        try {
            if (rowset.next()) {
                icm = rowset.getInt("FIsMainRule");
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return icm;
    }

    public static RowSet getCodingRuleInfoValueByID(Context ctx, String id) throws BOSException {
        StringBuffer sbSQL = new StringBuffer("select a.FID FID ,a.FNumber FNumber,a.FName_l1 FName_l1,a.FName_l2 FName_l2,a.FName_l3 FName_l3,a.FBusinessObject FBusinessObject,a.FOrgType FOrgType,a.FSplitSign FSplitSign,a.FSeqSegmentID FSeqSegmentID, ");
        sbSQL.append(" a.FRuleType FRuleType,a.FIsMainRule FIsMainRule,a.FBPID FBPID,a.FAppOrgUnit FAppOrgUnit,a.FIsEnabled FIsEnabled,a.FEnabledDate FEnabledDate,a.FDisabledDate FDisabledDate,a.FBusinessObjectID FBusinessObjectID,a.FOrgFirst FOrgFirst,a.FGroupFirst FGroupFirst,a.FMultiOrgFirst FMultiOrgFirst,a.FisAddView FisAddView,a.FisModifiable FisModifiable,a.FisUserSelect FisUserSelect,");
        sbSQL.append(" b.FPropertyName FPropertyName,b.FPropertyValue FPropertyValue,b.FUserValue FUserValue,");
        sbSQL.append(" c.FID EntryID,c.FSerialNumber FSerialNumber,c.FCodeSerialNumber FCodeSerialNumber,c.FCodeAttribute FCodeAttribute,c.FValueAttribute FValueAttribute,c.FAttUsingMode FAttUsingMode,");
        sbSQL.append(" c.FFormat FFormat,c.FStep FStep,c.FLength FLength, c.FInitial FInitial,c.FFillSign FFillSign,c.FDescription FDescription,");
        sbSQL.append(" c.FIsSortByItem FIsSortByItem,c.FIsDisplay FIsDisplay,c.FIsSplitSign FIsSplitSign,c.FFillSignDirection FFillSignDirection,");
        sbSQL.append(" c.FInterceptLength FInterceptLength,c.FInterceptPos FInterceptPos,c.FInterceptDirection FInterceptDirection,");
        sbSQL.append(" d.FID FOUID,d.FName_L1 FName_L1,d.FName_L2 FName_L2,d.FName_L3 FName_L3,d.FNumber FOUNumber,d.FLevel FLevel,d.FLongNumber FLongNumber,d.FIsFreeze FIsFreeze,d.FIsCompanyOrgUnit FIsCompanyOrgUnit,d.FIsAdminOrgUnit FIsAdminOrgUnit,d.FIsSaleOrgUnit FIsSaleOrgUnit,d.FIsPurchaseOrgUnit FIsPurchaseOrgUnit,d.FIsStorageOrgUnit FIsStorageOrgUnit,d.FIsProfitOrgUnit FIsProfitOrgUnit,d.FIsCostOrgUnit FIsCostOrgUnit,d.FIsCU FIsCU,d.FIsUnion FIsUnion");
        sbSQL.append(" from T_BAS_CodingRule a left join T_BAS_BindingProperty b on a.FBPID = b. FID left join T_BAS_CodingRuleEntry c on a.FID = c.FCodingRuleID left join T_ORG_BaseUnit d on a.FAppOrgUnit = d.FID");
        sbSQL.append(" where a.FID = ? ");
        sbSQL.append(" order by c.FSerialNumber ");
        Object[] params = new Object[]{id};
        return DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params);
    }

    public static RowSet getCodingRuleSegmentInfoValueByID(Context ctx, String id) throws BOSException {
        StringBuffer sbSQL = new StringBuffer("select a.FID FID,a.FAttrName FAttrName,b.FID bFID,b.FParentID bFParentID,b.FAttrValue bFAttrValue,b.FBeginNum bBeginNum,b.FEndNum bFEndNum,b.FUsedNum bFUsedNum,b.FState bFState,b.FLinkID bFLinkID ");
        sbSQL.append(" from T_BAS_SeqSegment a left join T_BAS_SeqSegmentEntry b on a.FID = b.FParentID ");
        sbSQL.append("where a.FID = ? ");
        sbSQL.append(" order by b.FID ");
        Object[] params = new Object[]{id};
        return DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params);
    }

    public static RowSet getCodingRuleMultiOrgInfo(Context ctx, String id) throws BOSException {
        StringBuffer sbSQL = new StringBuffer("select b.fid FID,d.FID FOUID,d.FName_L1 FName_L1,d.FName_L2 FName_L2,d.FName_L3 FName_L3,d.FNumber FOUNumber,d.FLevel FLevel,d.FLongNumber FLongNumber,d.FIsFreeze FIsFreeze,d.FIsCompanyOrgUnit FIsCompanyOrgUnit,d.FIsAdminOrgUnit FIsAdminOrgUnit,d.FIsSaleOrgUnit FIsSaleOrgUnit,d.FIsPurchaseOrgUnit FIsPurchaseOrgUnit,d.FIsStorageOrgUnit FIsStorageOrgUnit,d.FIsProfitOrgUnit FIsProfitOrgUnit,d.FIsCostOrgUnit FIsCostOrgUnit,d.FIsCU FIsCU,d.FIsUnion FIsUnion");
        sbSQL.append(" from T_BAS_CodingRule a left join T_BAS_CRMultiOrg b on a.FID = b.FCodingRule left join T_ORG_BaseUnit d on b.FAppOrgUnit = d.FID");
        sbSQL.append(" where a.FID = ? ");
        sbSQL.append(" order by d.FID ");
        Object[] params = new Object[]{id};
        return DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params);
    }

    public static void disabledCodingRule(Context ctx, CodingRuleInfo cr) throws BOSException {
        Object[] params;
        String sql;
        if (cr.getBindingProperty() == null) {
            if (cr.getId() != null && cr.getId().toString().length() > 0) {
                sql = "update T_BAS_CodingRule set  FIsEnabled = ? ,FDisabledDate = now()  where FID <> ? and FIsEnabled = ?  and FBusinessObject = ?  and FAppOrgUnit = ? and FRuleType = ? and FBPID is null ";
                params = new Object[]{false, cr.getId().toString(), true, cr.getBusinessObject(), cr.getAppOrgUnit().getId().toString(), new Integer(0)};
            } else {
                sql = "update T_BAS_CodingRule set  FIsEnabled = ? ,FDisabledDate = now()  where FIsEnabled = ?  and FBusinessObject = ?  and FAppOrgUnit = ? and FRuleType = ? and FBPID is null ";
                params = new Object[]{false, true, cr.getBusinessObject(), cr.getAppOrgUnit().getId().toString(), new Integer(0)};
            }
        } else if (cr.getId() != null && cr.getId().toString().length() > 0) {
            sql = "update T_BAS_CodingRule set  FIsEnabled = ? ,FDisabledDate = now()  where FID <> ? and FIsEnabled = ?  and FBusinessObject = ?  and FAppOrgUnit = ? and FRuleType = ?   and FBPID in (select fid from T_BAS_BindingProperty where FPropertyName = ? and FPropertyValue = ? )";
            cr.getBindingProperty().setPropertyValue(CodingRuleDAO.getPropertyValue(cr.getBindingProperty().getPropertyValue()));
            params = new Object[]{false, cr.getId().toString(), true, cr.getBusinessObject(), cr.getAppOrgUnit().getId().toString(), new Integer(0), cr.getBindingProperty().getPropertyName(), cr.getBindingProperty().getPropertyValue()};
        } else {
            sql = "update T_BAS_CodingRule set  FIsEnabled = ? ,FDisabledDate = now()  where FIsEnabled = ?  and FBusinessObject = ?  and FAppOrgUnit = ? and FRuleType = ?   and FBPID in (select fid from T_BAS_BindingProperty where FPropertyName = ? and FPropertyValue = ? )";
            cr.getBindingProperty().setPropertyValue(CodingRuleDAO.getPropertyValue(cr.getBindingProperty().getPropertyValue()));
            params = new Object[]{false, true, cr.getBusinessObject(), cr.getAppOrgUnit().getId().toString(), new Integer(0), cr.getBindingProperty().getPropertyName(), cr.getBindingProperty().getPropertyValue()};
        }
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static void disabledCodingRule(Context ctx, String id) throws BOSException {
        try {
            ICodingRule icr = CodingRuleFactory.getLocalInstance(ctx);
            ObjectUuidPK opk = new ObjectUuidPK(id);
            CodingRuleInfo info = icr.getCodingRuleInfo((IObjectPK)opk);
            info.setIsEnabled(false);
            info.setDisabledDate(new Date());
            icr.update((IObjectPK)opk, (CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static RowSet getEnabledCodingRule(Context ctx, CodingRuleInfo cr) throws BOSException {
        Object[] params;
        String sql;
        if (cr.getBindingProperty() == null) {
            if (cr.getId() != null && cr.getId().toString().length() > 0) {
                sql = "select FID,FName_l1,FName_l2,FName_l3,FNumber from T_BAS_CodingRule where FID <> ? and FIsEnabled = ?  and FBusinessObject = ?  and FAppOrgUnit = ? and FRuleType = ? and FBPID is null ";
                params = new Object[]{cr.getId().toString(), true, cr.getBusinessObject(), cr.getAppOrgUnit().getId().toString(), new Integer(0)};
            } else {
                sql = "select FID,FName_l1,FName_l2,FName_l3,,FNumber from T_BAS_CodingRule where FIsEnabled = ?  and FBusinessObject = ?  and FAppOrgUnit = ? and FRuleType = ? and FBPID is null ";
                params = new Object[]{true, cr.getBusinessObject(), cr.getAppOrgUnit().getId().toString(), new Integer(0)};
            }
        } else if (cr.getId() != null && cr.getId().toString().length() > 0) {
            sql = "select  FID,FName_l1,FName_l2,FName_l3,FNumber from T_BAS_CodingRule where FID <> ? and FIsEnabled = ?  and FBusinessObject = ?  and FAppOrgUnit = ? and FRuleType = ?   and FBPID in (select fid from T_BAS_BindingProperty where FPropertyName = ? and FPropertyValue = ? )";
            cr.getBindingProperty().setPropertyValue(CodingRuleDAO.getPropertyValue(cr.getBindingProperty().getPropertyValue()));
            params = new Object[]{cr.getId().toString(), true, cr.getBusinessObject(), cr.getAppOrgUnit().getId().toString(), new Integer(0), cr.getBindingProperty().getPropertyName(), cr.getBindingProperty().getPropertyValue()};
        } else {
            sql = "select  FID,FName_l1,FName_l2,FName_l3,FNumber from T_BAS_CodingRule where FIsEnabled = ?  and FBusinessObject = ?  and FAppOrgUnit = ? and FRuleType = ?   and FBPID in (select fid from T_BAS_BindingProperty where FPropertyName = ? and FPropertyValue = ? )";
            cr.getBindingProperty().setPropertyValue(CodingRuleDAO.getPropertyValue(cr.getBindingProperty().getPropertyValue()));
            params = new Object[]{true, cr.getBusinessObject(), cr.getAppOrgUnit().getId().toString(), new Integer(0), cr.getBindingProperty().getPropertyName(), cr.getBindingProperty().getPropertyValue()};
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }
}

