/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserInfoRpcHelper;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.client.AbstractAdminListUI;
import com.kingdee.eas.base.permission.client.OrgRangeListUI;
import com.kingdee.eas.base.permission.client.UserEditUI;
import com.kingdee.eas.base.permission.client.util.AdminUtil;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.MyEntityInfo;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgF7Facade;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class AdminListUI
extends AbstractAdminListUI {
    private static final Logger logger = CoreUIObject.getLogger(AdminListUI.class);
    protected static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
    protected static final String PERM_RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String USER_ID_CELLNAME = "id";
    private static final String USER_NUMBER_CELLNAME = "number";
    private static final String USER_TYPE_CELLNAME = "type";
    private static final String CU_ID_CELLNAME = "CU.id";
    OrgRangeCollection currentOrgRange = null;
    private String currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();

    public void onLoad() throws Exception {
        super.onLoad();
        this.getCurrentUserOrgRange();
        this.addTreeExpandListener();
    }

    private void addTreeExpandListener() {
        this.treeMain.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null) {
                    return;
                }
                try {
                    AdminListUI.this.loadNode(tmp);
                }
                catch (Exception e) {
                    AdminListUI.this.handleException(e);
                }
            }
        });
    }

    private void loadNode(DefaultKingdeeTreeNode tmp) throws BOSException, EASBizException {
        FullOrgUnitInfo unitInfo;
        if (tmp != null && tmp.getUserObject() != null && (unitInfo = (FullOrgUnitInfo)tmp.getUserObject()).get("alreadyLoad") == null) {
            OrgAssistInfo assistInfo = this.buildNewOrgF7AssistInfo(this.currentCUID);
            INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
            List orgCol = facade.getDirectChildren(assistInfo, (CoreBaseInfo)unitInfo);
            this.insertNodeIntoRoot(tmp, orgCol);
            unitInfo.put("alreadyLoad", (Object)true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAuthentType.setEnabled(true);
        this.btnAuthentType.setIcon(EASResource.getIcon((String)"imgTbtn_scatterpurview"));
        this.actionGroupAddNew.setEnabled(false);
        this.actionGroupAddNew.setVisible(false);
        this.actionGroupEdit.setEnabled(false);
        this.actionGroupEdit.setVisible(false);
        this.actionGroupMoveTree.setEnabled(false);
        this.actionGroupMoveTree.setVisible(false);
        this.actionGroupRemove.setEnabled(false);
        this.actionGroupRemove.setVisible(false);
        this.actionGroupView.setEnabled(false);
        this.actionGroupView.setVisible(false);
        this.actionMoveTree.setEnabled(false);
        this.actionMoveTree.setVisible(false);
        this.actionAddNew.setVisible(true);
        this.actionEdit.setVisible(true);
        this.actionEdit.setEnabled(true);
        this.actionRemove.setVisible(true);
        this.btnOrgRangeDeal.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
    }

    protected FilterInfo addAuthorizeFilter(FilterInfo filterInfo) throws ParserException, BOSException {
        if (filterInfo == null) {
            this.mainQuery.setFilter(new FilterInfo());
            filterInfo = this.mainQuery.getFilter();
        }
        if (!Administrator.isSuperAuAdmin((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()))) {
            FilterInfo adminFilter = new FilterInfo(" id <> '" + this.superAdminID() + "'");
            filterInfo.mergeFilter(adminFilter, "AND");
        }
        return filterInfo;
    }

    protected String superAdminID() {
        return "";
    }

    public ITreeBase getTreeInterface() {
        try {
            return FullOrgUnitFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            this.handUIException(e);
            return null;
        }
    }

    protected void initTree() throws Exception {
        FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(this.currentCUID));
        KDTreeNode root = new KDTreeNode((Object)unitInfo);
        root.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        OrgAssistInfo assistInfo = this.buildNewOrgF7AssistInfo(this.currentCUID);
        INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
        List orgCol = facade.getDirectChildren(assistInfo, (CoreBaseInfo)unitInfo);
        this.insertNodeIntoRoot((DefaultKingdeeTreeNode)root, orgCol);
        ((FullOrgUnitInfo)root.getUserObject()).put("alreadyLoad", (Object)true);
        this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

            @Override
            public boolean isLeaf(Object node) {
                FullOrgUnitInfo info = (FullOrgUnitInfo)((KDTreeNode)node).getUserObject();
                return info == null || info.isIsLeaf();
            }
        });
        if (root.getUserObject() == null) {
            this.treeMain.setRootVisible(false);
        } else {
            this.treeMain.setRootVisible(true);
        }
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)root);
    }

    private OrgAssistInfo buildNewOrgF7AssistInfo(String cuID) {
        OrgAssistInfo assistInfo = new OrgAssistInfo();
        assistInfo.setNeedAddAssistantFilter(true);
        StringBuffer extraFilters = new StringBuffer();
        extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FIsCU = 1 ");
        assistInfo.setExtraFilters(extraFilters.toString());
        return assistInfo;
    }

    private void insertNodeIntoRoot(DefaultKingdeeTreeNode root, List orgCol) {
        for (int i = 0; i < orgCol.size(); ++i) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)orgCol.get(i);
            KDTreeNode treeNode = new KDTreeNode((Object)info);
            treeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
            root.add((MutableTreeNode)treeNode);
        }
    }

    public String getQueryFieldName() {
        return CU_ID_CELLNAME;
    }

    protected void execQuery() {
        try {
            this.buildTreeFilter();
            this.mainQuery.setFilter(this.addAuthorizeFilter(this.mainQuery.getFilter()));
            logger.info((Object)this.mainQuery.toString());
        }
        catch (ParserException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        super.execQuery();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public String getEditUIName() {
        return UserEditUI.class.getName();
    }

    protected UserInfo getCurrentUserOfContext() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        boolean isAuthenAdmin = SysContext.getSysContext().getCurrentUserInfo().getId().toString().equals("00000000-0000-0000-0000-00000000000113B7DE7F");
        if (!isAuthenAdmin && !this.isManagedOrg((FullOrgUnitInfo)this.getSelectedTreeNode().getUserObject())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)this.getCanNotAddAdminMsgKey()));
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    protected String getCanNotAddAdminMsgKey() {
        return "";
    }

    private boolean isManagedOrg(FullOrgUnitInfo orgInfo) throws Exception {
        return this.getManagedOrgIdCol().contains(orgInfo.getId());
    }

    private OrgRangeCollection getCurrentUserOrgRange() throws BOSException, EASBizException {
        if (this.currentOrgRange == null) {
            this.currentOrgRange = AdminUtil.getCurrentUserOrgRange();
            if (this.isSuperAdmin((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId())) && (this.currentOrgRange == null || this.currentOrgRange.size() < 1)) {
                this.initAdminOrgRange();
                this.currentOrgRange = AdminUtil.getCurrentUserOrgRange();
            }
        }
        return this.currentOrgRange;
    }

    private Collection getManagedOrgIdCol() throws Exception {
        HashSet<BOSUuid> ret = new HashSet<BOSUuid>();
        OrgRangeCollection orgRangeCol = this.getCurrentUserOrgRange();
        Iterator itr = orgRangeCol.iterator();
        while (itr.hasNext()) {
            OrgRangeInfo info = (OrgRangeInfo)itr.next();
            ret.add(info.getOrg().getId());
        }
        return ret;
    }

    protected boolean isSuperAdmin(IObjectPK userPK) {
        return false;
    }

    private void initAdminOrgRange() throws BOSException, EASBizException {
        PermissionFactory.getRemoteInstance().getOrgRanges((IObjectPK)new ObjectUuidPK(this.getCurrentUserOfContext().getId()));
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        EntityViewInfo defaultView = super.getDefaultEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo typeFilterItem = this.getTypeFilterInfo();
        filter.getFilterItems().add(typeFilterItem);
        if (defaultView == null || defaultView.getFilter() == null || defaultView.getFilter().getFilterItems() == null || defaultView.getFilter().getFilterItems().size() == 0) {
            EntityViewInfo temp = new EntityViewInfo();
            temp.setFilter(filter);
            return temp;
        }
        try {
            defaultView.getFilter().mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return defaultView;
    }

    protected FilterItemInfo getTypeFilterInfo() {
        return new FilterItemInfo();
    }

    protected void processFilter() throws BOSException, ParserException {
        FilterInfo filterInfo = null;
        try {
            filterInfo = this.addAuthorizeFilter(filterInfo);
        }
        catch (UuidException e) {
            logger.error((Object)e);
        }
        if (this.mainQuery == null || this.mainQuery.getFilter() == null || this.mainQuery.getFilter().getFilterItems().size() == 0) {
            this.mainQuery.setFilter(filterInfo);
        }
        this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"delUserWarning"));
        if (MsgBox.isYes((int)isYes)) {
            try {
                this.processUserDelete();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
            this.refresh(e);
        }
    }

    private void processUserDelete() throws Exception {
        UserCollection userCol = new UserCollection();
        ArrayList<ObjectStringPK> arrayList = new ArrayList<ObjectStringPK>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                UserInfo tempUserInfo = this.getUserInfoFromTable(this.tblMain.getRow(j));
                this.checkUserCanBeMaintain(tempUserInfo);
                userCol.add(tempUserInfo);
                arrayList.add(new ObjectStringPK(tempUserInfo.getId().toString()));
            }
        }
        IObjectPK[] userPKs = new IObjectPK[arrayList.size()];
        int length = userPKs.length;
        for (int i = 0; i < length; ++i) {
            userPKs[i] = (IObjectPK)arrayList.get(i);
        }
        IUser iUser = (IUser)this.getBizInterface();
        LogProxy logProxy = new LogProxy();
        logProxy.beginLog(null, MyEntityInfo.getMethodAlias(null, iUser.getType(), "delete"), iUser.getType(), null, UserInfoRpcHelper.getforbidDetail(userCol, "delete", true, SysContext.getSysContext().getLocale()));
        iUser.delete(userPKs);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"deleteSucceed"));
        logProxy.end();
    }

    private void checkUserCanBeMaintain(UserInfo userInfo) throws EASBizException, BOSException, UuidException {
        IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
        List onLineInfoList = iUserMonitor.findUsers(SysContext.getSysContext().getDcName(), userInfo.getNumber());
        if (onLineInfoList != null && !onLineInfoList.isEmpty()) {
            Object[] objects = new Object[]{userInfo.getNumber()};
            String str = MessageFormat.format(EASResource.getString((String)PERM_RESOURCE, (String)"userOnlineWhenDelete"), objects);
            MsgBox.showWarning((Component)((Object)this), (String)str);
            this.abort();
        }
    }

    private UserInfo getUserInfoFromTable(IRow iRow) {
        Object object = iRow.getCell(USER_ID_CELLNAME).getValue();
        UserInfo info = new UserInfo();
        info.setId(BOSUuid.read((String)object.toString()));
        CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
        ctrlUnitInfo.setId(BOSUuid.read((String)iRow.getCell(CU_ID_CELLNAME).getValue().toString()));
        info.setCU(ctrlUnitInfo);
        info.setNumber(iRow.getCell(USER_NUMBER_CELLNAME).getValue().toString());
        BizEnumValueInfo bizInfo = (BizEnumValueInfo)iRow.getCell(USER_TYPE_CELLNAME).getValue();
        info.setType(UserType.getEnum(bizInfo.getInt()));
        return info;
    }

    @Override
    public void actionOrgRangeDeal_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectStringPK userPK = new ObjectStringPK(this.getSelectedKeyValue());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"userPK", (Object)userPK);
        try {
            IUIWindow iWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OrgRangeListUI.class.getName(), (Map)uiContext, null);
            iWin.show();
        }
        catch (UIException ex) {
            logger.error((Object)"", (Throwable)ex);
            this.handleException((Exception)((Object)ex));
        }
    }
}

