/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.BizObjectForRoleEntryCollection;
import com.kingdee.eas.base.permission.BizObjectForRoleEntryInfo;
import com.kingdee.eas.base.permission.BizObjectForRoleFactory;
import com.kingdee.eas.base.permission.BizObjectForRoleInfo;
import com.kingdee.eas.base.permission.IBizObjectForRole;
import com.kingdee.eas.base.permission.client.AbstractBizObjPropForRoleUI;
import com.kingdee.eas.base.permission.client.RuleTreeUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BizObjPropForRoleUI
extends AbstractBizObjPropForRoleUI {
    private static final Logger logger = CoreUIObject.getLogger(BizObjPropForRoleUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private String entityDesc = null;
    private DefaultKingdeeTreeNode rootNode = null;
    private BOSObjectType rootBosType = null;
    private BizObjectForRoleInfo roleInfo = null;
    private boolean isModofyData = false;
    private TreeModel oldDataModel = null;
    private String oldDataStr = "";
    private Set oldSet = new HashSet();

    public BizObjPropForRoleUI() throws Exception {
        this.initTree();
        this.installListener();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.actionSave.setVisible(true);
    }

    private void initTree() throws Exception {
        RuleTreeUtil.createRuleRootNode(this.treeObj);
        this.treeProp.setModel(null);
    }

    private void installListener() {
        TreeListener listener = new TreeListener();
        this.treeObj.addTreeSelectionListener((TreeSelectionListener)listener);
        this.treeProp.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (node == null) {
                    return;
                }
                EntityObjectInfo tmpInfo = null;
                if (node == BizObjPropForRoleUI.this.rootNode) {
                    tmpInfo = BizObjPropForRoleUI.this.getEntityObjectInfo(BizObjPropForRoleUI.this.rootBosType);
                } else {
                    MyPropertyInfo info = (MyPropertyInfo)node.getUserObject();
                    LinkPropertyInfo tmpLinkInfo = (LinkPropertyInfo)info.getPropertyInfo();
                    tmpInfo = tmpLinkInfo.getRelationship().getSupplierObject();
                }
                BizObjPropForRoleUI.this.buildTreeNode(node, tmpInfo);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
    }

    private boolean isDataModify() {
        if (this.oldSet.isEmpty() && (this.treeProp == null || this.treeProp.getModel() == null)) {
            return false;
        }
        Set newDataSet = this.getOldDataMap((DefaultKingdeeTreeNode)((DefaultTreeModel)this.treeProp.getModel()).getRoot());
        return !this.oldSet.containsAll(newDataSet) || !newDataSet.containsAll(this.oldSet);
    }

    private BizObjectForRoleInfo getSelectNodeInfo(TreeSelectionEvent e) {
        if (e.getNewLeadSelectionPath() == null) {
            return null;
        }
        KDTreeNode node = (KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
        BizObjectForRoleInfo roleInfo = (BizObjectForRoleInfo)node.getUserObject();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("propEntries.*"));
        selector.add(new SelectorItemInfo("propEntries.propNumber"));
        try {
            IBizObjectForRole bfr = BizObjectForRoleFactory.getRemoteInstance();
            roleInfo = bfr.getBizObjectForRoleInfo((IObjectPK)new ObjectUuidPK(roleInfo.getId()), selector);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return roleInfo;
    }

    private void changedPropTree(BizObjectForRoleInfo roleInfo) {
        if (roleInfo == null || !roleInfo.isIsLeaf()) {
            return;
        }
        this.rootBosType = BOSObjectType.create((String)roleInfo.getNumber());
        this.entityDesc = roleInfo.getName();
        this.roleInfo = roleInfo;
        this.changePropTree();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.rootNode == null) {
            return;
        }
        Enumeration enumerration = this.rootNode.breadthFirstEnumeration();
        this.roleInfo.getPropEntries().clear();
        while (enumerration.hasMoreElements()) {
            Object obj;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enumerration.nextElement();
            if (!node.isLeaf() || !node.isChecked() || !((obj = node.getUserObject()) instanceof MyPropertyInfo)) continue;
            this.saveCheckedProp(this.roleInfo, node);
        }
        this.submit(this.roleInfo);
        this.isModofyData = false;
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
    }

    private Set getOldDataMap(DefaultKingdeeTreeNode rootNode) {
        HashSet<Object> retSet = new HashSet<Object>();
        if (rootNode == null) {
            return retSet;
        }
        Enumeration enumerration = rootNode.breadthFirstEnumeration();
        while (enumerration.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enumerration.nextElement();
            if (!node.isLeaf() || !node.isChecked()) continue;
            retSet.add(node.getUserObject());
        }
        return retSet;
    }

    private void saveCheckedProp(BizObjectForRoleInfo roleInfo, DefaultKingdeeTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof MyPropertyInfo) {
            MyPropertyInfo myInfo = (MyPropertyInfo)obj;
            PropertyInfo propInfo = myInfo.getPropertyInfo();
            BizObjectForRoleEntryInfo entryInfo = new BizObjectForRoleEntryInfo();
            if (node.getParent() != this.rootNode) {
                entryInfo.setPropNumber(this.getLongNumber(node, propInfo));
            } else {
                entryInfo.setPropNumber(propInfo.getName());
            }
            entryInfo.setPropName(propInfo.getAlias(new Locale("l1")), new Locale("l1"));
            entryInfo.setPropName(propInfo.getAlias(new Locale("l2")), new Locale("l2"));
            entryInfo.setPropName(propInfo.getAlias(new Locale("l3")), new Locale("l3"));
            entryInfo.setEntityObj(roleInfo);
            roleInfo.getPropEntries().add(entryInfo);
        }
    }

    private String getLongNumber(DefaultKingdeeTreeNode node, PropertyInfo propInfo) {
        String longNumber = propInfo.getName();
        DefaultKingdeeTreeNode tmpNode = node;
        while (tmpNode.getParent() != this.rootNode) {
            Object obj = (tmpNode = (DefaultKingdeeTreeNode)tmpNode.getParent()).getUserObject();
            if (!(obj instanceof MyPropertyInfo)) continue;
            MyPropertyInfo myInfo = (MyPropertyInfo)obj;
            longNumber = myInfo.getPropertyInfo().getName() + "." + longNumber;
        }
        return longNumber;
    }

    private void submit(BizObjectForRoleInfo roleInfo) throws Exception {
        IBizObjectForRole bfr = BizObjectForRoleFactory.getRemoteInstance();
        ArrayList<BizObjectForRoleInfo> roleArr = new ArrayList<BizObjectForRoleInfo>();
        roleArr.add(roleInfo);
        bfr.submitProp(roleArr);
    }

    private void changePropTree() {
        this.treeProp.setModel(null);
        this.rootNode = new DefaultKingdeeTreeNode((Object)this.entityDesc);
        this.treeProp.setModel((TreeModel)new DefaultTreeModel((TreeNode)this.rootNode));
        this.buildTreeNode(this.rootNode, this.rootBosType);
        this.treeProp.setSyncChecked(true);
        this.treeProp.setShowCheckBox(true);
        ((DefaultTreeModel)this.treeProp.getModel()).setAsksAllowsChildren(true);
        this.oldSet = this.getOldDataMap((DefaultKingdeeTreeNode)((DefaultTreeModel)this.treeProp.getModel()).getRoot());
    }

    private void buildTreeNode(DefaultKingdeeTreeNode parentNode, BOSObjectType type) {
        EntityObjectInfo eoInfo = this.getEntityObjectInfo(type);
        this.buildTreeNode(parentNode, eoInfo);
    }

    private EntityObjectInfo getEntityObjectInfo(BOSObjectType type) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        return loader.getEntity(type);
    }

    private boolean isExistSameProp(DefaultKingdeeTreeNode parentNode, PropertyInfo propInfo) {
        int count = parentNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            MyPropertyInfo tmInfo;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            Object o = node.getUserObject();
            if (!(o instanceof MyPropertyInfo) || (tmInfo = (MyPropertyInfo)o).getPropertyInfo().getName() == null || !tmInfo.getPropertyInfo().getName().equals(propInfo.getName())) continue;
            return true;
        }
        return false;
    }

    private void buildTreeNode(DefaultKingdeeTreeNode parentNode, EntityObjectInfo eoInfo) {
        PropertyCollection coll = eoInfo.getInheritedNoDuplicatedProperties();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo tmp = coll.get(i);
            if (this.isExistSameProp(parentNode, tmp)) continue;
            MyPropertyInfo myInfo = new MyPropertyInfo(tmp);
            DefaultKingdeeTreeNode tmpNode = new DefaultKingdeeTreeNode((Object)myInfo);
            tmpNode.setCheckBoxVisible(true);
            if (this.isCheck(parentNode, tmp)) {
                tmpNode.setChecked(true);
            } else {
                tmpNode.setChecked(false);
            }
            if (tmp.getClass().getName().equals(LinkPropertyInfo.class.getName())) {
                tmpNode.setAllowsChildren(true);
            } else {
                tmpNode.setAllowsChildren(false);
            }
            this.treeProp.addNodeInto((MutableTreeNode)tmpNode, (MutableTreeNode)parentNode);
            tmpNode.syncChecked();
            this.treeProp.scrollPathToVisible(new TreePath(tmpNode.getPath()));
        }
    }

    private boolean isCheck(DefaultKingdeeTreeNode parentNode, PropertyInfo prop) {
        BizObjectForRoleEntryCollection coll = this.roleInfo.getPropEntries();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            BizObjectForRoleEntryInfo entryInfo = coll.get(i);
            int level = parentNode.getLevel();
            if (!this.getPropNumberByLevel(entryInfo.getPropNumber(), level).equals(prop.getName())) continue;
            return true;
        }
        return false;
    }

    private String getPropNumberByLevel(String number, int level) {
        if (number.indexOf(".") >= 0) {
            String[] numbers = number.split("\\.");
            if (level < numbers.length) {
                return numbers[level];
            }
            return "";
        }
        if (level > 0) {
            return "";
        }
        return number;
    }

    private class MyPropertyInfo {
        private PropertyInfo info = null;

        public MyPropertyInfo(PropertyInfo info) {
            this.info = info;
        }

        public String toString() {
            if (this.info.getAlias() != null) {
                return this.info.getAlias().toString();
            }
            return this.info.getName().toString();
        }

        public PropertyInfo getPropertyInfo() {
            return this.info;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof MyPropertyInfo)) {
                return false;
            }
            MyPropertyInfo myInfo = (MyPropertyInfo)o;
            PropertyInfo tmpPropInfo = myInfo.getPropertyInfo();
            if (this == myInfo) {
                return true;
            }
            return this.getPropertyInfo().equals((Object)tmpPropInfo);
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            int isYes = 0;
            if (BizObjPropForRoleUI.this.isDataModify() && MsgBox.isOk((int)(isYes = MsgBox.showConfirm2((String)EASResource.getString((String)BizObjPropForRoleUI.RESOURCE, (String)"alertSave"))))) {
                try {
                    BizObjPropForRoleUI.this.actionSave_actionPerformed(null);
                }
                catch (Exception e1) {
                    BizObjPropForRoleUI.this.handUIException(e1);
                }
            }
            BizObjectForRoleInfo info = BizObjPropForRoleUI.this.getSelectNodeInfo(e);
            BizObjPropForRoleUI.this.changedPropTree(info);
        }
    }
}

