/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.ISecurity;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.Locale;
import com.kingdee.eas.base.permission.SecurityCollection;
import com.kingdee.eas.base.permission.SecurityException;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.client.AbstractCUAdminEditUI;
import com.kingdee.eas.base.permission.client.PasswordMaintainUI;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CtrlF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Map;

public class CUAdminEditUI
extends AbstractCUAdminEditUI {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private UserInfo userInfo;
    private String title = null;
    private UserInfo oldData = null;

    private void initUI() throws EASBizException, BOSException {
        this.initOrgF7();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.title = this.getUITitle();
        this.initUI();
        this.loadFields();
    }

    private void initOrgF7() throws EASBizException, BOSException {
        CtrlF7 ctrlF7 = new CtrlF7((IUIObject)this);
        ctrlF7.setIsCUFilter(true, true);
        ctrlF7.setCurrentCUID(this.getCurrentCUPK().toString());
        ctrlF7.setMultiSelect(false);
        this.pmtCU.setSelector((KDPromptSelector)ctrlF7);
    }

    private UserInfo getUserInfo() throws EASBizException, BOSException {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return this.createNewUser();
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            IUser iUser = (IUser)this.getBizInterface();
            return iUser.getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString())), this.getSelectors());
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            IUser iUser = (IUser)this.getBizInterface();
            return iUser.getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString())), this.getSelectors());
        }
        throw new IllegalArgumentException("UI' state " + this.getOprtState() + " is not supported");
    }

    public UserInfo createNewUser() {
        UserInfo info = new UserInfo();
        Calendar endDate = Calendar.getInstance();
        endDate.set(2199, 11, 31, 0, 0, 0);
        Timestamp invalidate = new Timestamp(endDate.getTimeInMillis());
        info.setInvalidationDate(invalidate);
        info.setEffectiveDate(new Timestamp(System.currentTimeMillis()));
        info.setPWEffectiveDate(new Timestamp(System.currentTimeMillis()));
        info.setErrCount(0);
        info.setIsDelete(false);
        info.setType(UserType.SYSTEM);
        info.setIsForbidden(false);
        info.setIsLocked(false);
        info.setIsRegister(true);
        info.setDefLocale(Locale.L2);
        CtrlUnitInfo ctrlUnitInfo = this.getCtrlUnitInfo(this.getCurrentCUPK());
        info.setCU(ctrlUnitInfo);
        FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
        fullOrgUnitInfo.setId(info.getCU().getId());
        info.setDefOrgUnit(fullOrgUnitInfo);
        return info;
    }

    private CtrlUnitInfo getCtrlUnitInfo(IObjectPK ctrlUnitPK) {
        try {
            return CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo(ctrlUnitPK);
        }
        catch (EASBizException e) {
            this.handUIException(e);
            return null;
        }
        catch (BOSException e) {
            this.handUIException(e);
            return null;
        }
    }

    private void checkModified() throws Exception {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
                if (this.actionSubmit.isInvokeFailed()) {
                    SysUtil.abort();
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    private boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        return !ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)this.oldData, (AbstractObjectValue)this.userInfo);
    }

    public boolean checkBeforeWindowClosing() {
        boolean flag = super.checkBeforeWindowClosing();
        if (!flag) {
            return false;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSubmit.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    return !this.actionSubmit.isInvokeFailed();
                }
                catch (Exception exc) {
                    return false;
                }
            }
            return result == 1;
        }
        return true;
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    public ICoreBase getBizInterface() throws BOSException {
        return UserFactory.getRemoteInstance();
    }

    private void setComponentStatus() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtNumber.setEditable(true);
            this.mlbName.setEditable(true);
            this.cmbSecurity.setEnabled(true);
            this.dpkInuseDate.setEnabled(true);
            this.dpkInvaildDate.setEnabled(true);
            this.cmbDefLang.setEnabled(true);
            this.dpkPWEffectiveDate.setEnabled(true);
            this.pmtCU.setEnabled(true);
            this.mlaDescription.setEditable(true);
            this.btnPassword.setVisible(false);
            this.btnAddNew.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.lbcPassword.setVisible(true);
            this.lbcConfirmPassword.setVisible(true);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEditable(true);
            this.mlbName.setEditable(true);
            this.cmbSecurity.setEnabled(true);
            this.dpkInuseDate.setEnabled(true);
            this.dpkInvaildDate.setEnabled(true);
            this.cmbDefLang.setEnabled(true);
            this.dpkPWEffectiveDate.setEnabled(true);
            this.pmtCU.setEnabled(true);
            this.mlaDescription.setEditable(true);
            this.btnPassword.setVisible(true);
            this.btnAddNew.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.lbcPassword.setVisible(false);
            this.lbcConfirmPassword.setVisible(false);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.txtNumber.setEditable(false);
            this.mlbName.setEditable(false);
            this.cmbSecurity.setEnabled(false);
            this.dpkInuseDate.setEnabled(false);
            this.dpkInvaildDate.setEnabled(false);
            this.cmbDefLang.setEnabled(false);
            this.dpkPWInvaildDate.setEnabled(false);
            this.pmtCU.setEnabled(false);
            this.mlaDescription.setEnabled(false);
            this.btnPassword.setVisible(false);
            this.btnAddNew.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.lbcPassword.setVisible(false);
            this.lbcConfirmPassword.setVisible(false);
        }
    }

    private void setComponentLayout() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.lbcPWInvaildDate.setBounds(new Rectangle(270, 120, 250, 19));
            this.lbcPWEffectiveDate.setBounds(new Rectangle(10, 120, 250, 19));
            this.lblDescription.setBounds(new Rectangle(10, 142, 100, 19));
            this.mlaDescription.setBounds(new Rectangle(10, 164, 510, 149));
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.lbcPWInvaildDate.setBounds(new Rectangle(270, 98, 250, 19));
            this.lbcPWEffectiveDate.setBounds(new Rectangle(10, 98, 250, 19));
            this.lblDescription.setBounds(new Rectangle(10, 120, 100, 19));
            this.mlaDescription.setBounds(new Rectangle(10, 142, 510, 171));
        } else {
            this.lbcPWInvaildDate.setBounds(new Rectangle(270, 98, 250, 19));
            this.lbcPWEffectiveDate.setBounds(new Rectangle(10, 98, 250, 19));
            this.lblDescription.setBounds(new Rectangle(10, 120, 100, 19));
            this.mlaDescription.setBounds(new Rectangle(10, 142, 510, 171));
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber.getText().trim().length() == 0) {
            this.txtNumber.requestFocus();
            throw new UserException(UserException.NUMBER_NOT_NULL);
        }
        if (this.txtNumber.getText().trim().indexOf("'") >= 0) {
            this.txtNumber.requestFocus();
            throw new UserException(UserException.NUMBER_INCLUDE_FORBIDDEN_CHAR);
        }
        if (this.cmbSecurity.getSelectedItem() == null) {
            this.cmbSecurity.requestFocus();
            throw new UserException(UserException.USER_NOT_SECURITY);
        }
        if (this.pmtCU.getData() == null) {
            this.pmtCU.requestFocus();
            throw new UserException(UserException.USER_CU_IS_NULL);
        }
        this.checkUserRealName();
        Date inuserDate = this.dpkInuseDate.getSqlDate();
        Date invalidDate = this.dpkInvaildDate.getSqlDate();
        if (DateTimeUtils.dayAfter((java.util.Date)inuserDate, (java.util.Date)invalidDate)) {
            this.dpkInuseDate.requestFocus();
            throw new UserException(UserException.USER_VALIDDATE_ERROR);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.verifyPassword(new String(this.pwdPassword.getPassword()), new String(this.pwdConfirmPassword.getPassword()));
        }
    }

    private void checkUserRealName() {
        LanguageInfo languageInfo = new LanguageInfo(SysContext.getSysContext().getLocale());
        Object data = this.mlbName.getItemBy(languageInfo).getData();
        if (data != null && StringUtils.isEmpty((String)data.toString())) {
            this.mlbName.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"userRealNameCanBeNull"));
            this.abort();
        }
    }

    private void verifyPassword(String password, String confirmPassword) throws EASBizException {
        if (password == null) {
            this.pwdPassword.requestFocus();
            throw new SecurityException(SecurityException.PASSWORD_TOO_SHORT);
        }
        if (password.indexOf("'") >= 0) {
            this.pwdPassword.requestFocus();
            throw new UserException(UserException.PASSWORD_INCLUDE_FORBIDDEN_CHAR);
        }
        if (confirmPassword == null) {
            this.pwdConfirmPassword.requestFocus();
            throw new UserException(UserException.CONFIRMED_PASSWORD_IS_NULL);
        }
        if (confirmPassword.indexOf("'") >= 0) {
            this.pwdConfirmPassword.requestFocus();
            throw new UserException(UserException.PASSWORD_INCLUDE_FORBIDDEN_CHAR);
        }
        if (!confirmPassword.equals(password)) {
            this.pwdConfirmPassword.requestFocus();
            throw new UserException(UserException.PASSWORD_NOT_MATCH);
        }
    }

    private void loadPasswordSecutity() {
        this.cmbSecurity.removeAllItems();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            SecurityCollection securities = this.getSecurities();
            if (securities != null && securities.size() > 0) {
                this.cmbSecurity.addItems(securities.toArray());
                this.cmbSecurity.setSelectedIndex(0);
            }
        } else if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            if (this.userInfo.getCU().getId().toString().equals(this.getCurrentCUPK().toString())) {
                SecurityCollection securities = this.getSecurities();
                this.cmbSecurity.addItems(securities.toArray());
                int size = securities.size();
                for (int i = 0; i < size; ++i) {
                    if (!securities.get(i).getId().equals((Object)this.userInfo.getSecurity().getId())) continue;
                    this.cmbSecurity.setSelectedIndex(i);
                }
            } else {
                this.cmbSecurity.addItem((Object)this.userInfo.getSecurity());
            }
        }
    }

    private SecurityCollection getSecurities() {
        SecurityCollection securities = null;
        try {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append(" WHERE CU.id = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ");
            buffer.append(" OR CU.id = '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("' ");
            buffer.append(" OR CU.id = '").append(this.getCurrentCUPK().toString()).append("' ");
            buffer.append(" ORDER BY number ");
            ISecurity iSecurity = SecurityFactory.getRemoteInstance();
            securities = iSecurity.getSecurityCollection(buffer.toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return securities;
    }

    @Override
    public void loadFields() {
        try {
            this.userInfo = this.getUserInfo();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.setComponentStatus();
        this.setComponentLayout();
        this.setTilte();
        this.txtNumber.setText(this.userInfo.getNumber());
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.mlbName, (IObjectValue)this.userInfo, (String)"name");
        this.dpkInuseDate.setValue((Object)this.userInfo.getEffectiveDate());
        this.dpkInvaildDate.setValue((Object)this.userInfo.getInvalidationDate());
        this.cmbDefLang.setSelectedItem((Object)this.userInfo.getDefLocale());
        this.loadPasswordSecutity();
        this.dpkPWEffectiveDate.setValue((Object)(this.userInfo.getPWEffectiveDate() == null ? new java.util.Date() : this.userInfo.getPWEffectiveDate()));
        this.loadPWInvaildDate();
        this.pwdPassword.setText(this.userInfo.getPassword());
        this.pwdConfirmPassword.setText(this.userInfo.getPassword());
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.mlaDescription, (IObjectValue)this.userInfo, (String)"description");
        this.pmtCU.setData((Object)this.userInfo.getCU());
        this.oldData = (UserInfo)this.userInfo.clone();
        SecurityInfo security = (SecurityInfo)this.cmbSecurity.getSelectedItem();
        this.oldData.setSecurity(security);
    }

    private void reloadUI() {
        this.loadFields();
    }

    private void setTilte() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setUITitle(this.title + EASResource.getString((String)RESOURCE, (String)"add"));
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.setUITitle(this.title + EASResource.getString((String)RESOURCE, (String)"edit"));
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setUITitle(this.title + EASResource.getString((String)RESOURCE, (String)"view"));
        }
    }

    private void loadPWInvaildDate() {
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            Object object = this.cmbSecurity.getSelectedItem();
            if (object != null && object instanceof SecurityInfo) {
                SecurityInfo securityInfo = (SecurityInfo)object;
                this.setComponentStatusOfPWInvaild(securityInfo);
            }
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            Calendar endDate = Calendar.getInstance();
            endDate.set(2199, 11, 31, 0, 0, 0);
            this.dpkPWInvaildDate.setValue((Object)endDate.getTime());
        } else {
            throw new IllegalArgumentException(" oprt:" + this.getOprtState() + " not supported");
        }
    }

    @Override
    public void storeFields() {
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.mlaDescription, (IObjectValue)this.userInfo, (String)"description");
        this.userInfo.setNumber(this.txtNumber.getText().trim());
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.mlbName, (IObjectValue)this.userInfo, (String)"name");
        this.userInfo.setEffectiveDate((Timestamp)this.dpkInuseDate.getValue(Timestamp.class));
        this.userInfo.setInvalidationDate((Timestamp)this.dpkInvaildDate.getValue(Timestamp.class));
        this.userInfo.setPWEffectiveDate((Timestamp)this.dpkPWEffectiveDate.getValue(Timestamp.class));
        SecurityInfo security = (SecurityInfo)this.cmbSecurity.getSelectedItem();
        this.userInfo.setSecurity(security);
        this.userInfo.setCU((CtrlUnitInfo)this.pmtCU.getData());
        FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
        fullOrgUnitInfo.setId(this.userInfo.getCU().getId());
        this.userInfo.setDefOrgUnit(fullOrgUnitInfo);
        this.userInfo.setDefLocale((Locale)((Object)this.cmbDefLang.getSelectedItem()));
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String password = new String(this.pwdPassword.getPassword());
            try {
                password = CryptoTean.encrypt((String)this.userInfo.getNumber(), (String)password);
            }
            catch (CryptException e) {
                this.handUIException(e);
            }
            this.userInfo.setPassword(password);
            this.oldData.setPassword(password);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.storeFields();
        ObjectUuidPK userPK = null;
        IUser iUser = (IUser)this.getBizInterface();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String deletedUserID = iUser.getDeletedUserID(this.userInfo.getNumber());
            if (StringUtils.isEmpty((String)deletedUserID)) {
                userPK = iUser.addnew((CoreBaseInfo)this.userInfo);
                this.userInfo.setId(BOSUuid.read((String)userPK.toString()));
            } else {
                int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"recycleUserAlert"));
                if (MsgBox.isYes((int)isYes)) {
                    userPK = new ObjectUuidPK(deletedUserID);
                    this.userInfo.setId(BOSUuid.read((String)userPK.toString()));
                    iUser.update((IObjectPK)userPK, (IObjectValue)this.userInfo, true);
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"userNumberIsExistd"));
                    return;
                }
            }
            this.getUIContext().put("ID", userPK.toString());
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            userPK = new ObjectUuidPK(this.userInfo.getId());
            iUser.update((IObjectPK)userPK, (IObjectValue)this.userInfo, OprtState.ADDNEW.equals(this.getOprtState()));
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveSucceed"));
        this.setOprtState(OprtState.EDIT);
        this.reloadUI();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        super.actionAddNew_actionPerformed(e);
        this.setOprtState(OprtState.ADDNEW);
        this.userInfo = this.createNewUser();
        this.loadFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.setButtonDefaultStyl(this.btnAddNew);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnSubmit);
        this.btnPassword.setIcon(EASResource.getIcon((String)"imgTbtn_setpassword"));
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("security.*");
        selectorItemCollection.add("CU.id");
        selectorItemCollection.add("CU.number");
        selectorItemCollection.add("CU.name");
        return selectorItemCollection;
    }

    @Override
    public void actionPassword_actionPerformed(ActionEvent e) throws Exception {
        super.actionPassword_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"targetID", (Object)this.userInfo.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PasswordMaintainUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
    }

    @Override
    protected void cmbSecurity_itemStateChanged(ItemEvent e) throws Exception {
        Object object;
        super.cmbSecurity_itemStateChanged(e);
        if (e.getStateChange() == 1 && (object = this.cmbSecurity.getSelectedItem()) != null && object instanceof SecurityInfo) {
            SecurityInfo securityInfo = (SecurityInfo)object;
            this.setComponentStatusOfPWInvaild(securityInfo);
        }
    }

    private java.util.Date getPWInvaildDate(int days) {
        Calendar pwInvaildDate = Calendar.getInstance();
        pwInvaildDate.setTime((java.util.Date)this.dpkPWEffectiveDate.getValue());
        pwInvaildDate.add(5, days);
        return pwInvaildDate.getTime();
    }

    private void setComponentStatusOfPWInvaild(SecurityInfo securityInfo) {
        if (securityInfo.isPasswordForever()) {
            Calendar pwInvaildDate = Calendar.getInstance();
            pwInvaildDate.set(2099, 11, 31, 0, 0, 0);
            this.dpkPWInvaildDate.setValue((Object)pwInvaildDate.getTime());
        } else {
            this.dpkPWInvaildDate.setValue((Object)this.getPWInvaildDate(securityInfo.getPasswordCycle()));
        }
    }

    @Override
    protected void dpkPWEffectiveDate_dataChanged(DataChangeEvent e) throws Exception {
        super.dpkPWEffectiveDate_dataChanged(e);
        Object object = this.cmbSecurity.getSelectedItem();
        if (object != null && object instanceof SecurityInfo) {
            SecurityInfo securityInfo = (SecurityInfo)object;
            this.setComponentStatusOfPWInvaild(securityInfo);
        }
    }

    @Override
    protected void cmbSecurity_mouseEntered(MouseEvent e) throws Exception {
        super.cmbSecurity_mouseEntered(e);
        Object object = this.cmbSecurity.getSelectedItem();
        if (object != null && object instanceof SecurityInfo) {
            StringBuffer sbTip = new StringBuffer();
            SecurityInfo securityInfo = (SecurityInfo)object;
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityForever")).append(this.getYesORNo(securityInfo.isPasswordForever()));
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityChangePassword")).append(this.getYesORNo(securityInfo.isPasswordCanChg()));
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityPasswordLength")).append(securityInfo.getPasswordLength());
            if (!securityInfo.isPasswordForever()) {
                sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityPasswordDay")).append(securityInfo.getPasswordCycle());
            }
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityLock")).append(this.getYesORNo(securityInfo.isNeedLocked()));
            if (securityInfo.isNeedLocked()) {
                String str = EASResource.getString((String)RESOURCE, (String)"securityErrorCount");
                Object[] objects = new Object[]{new Integer(securityInfo.getLockCount())};
                str = MessageFormat.format(str, objects);
                sbTip.append(str);
            }
            sbTip.append(EASResource.getString((String)RESOURCE, (String)"securityEnd"));
            this.cmbSecurity.setToolTipText(sbTip.toString());
        }
    }

    private String getYesORNo(boolean value) {
        return value ? EASResource.getString((String)RESOURCE, (String)"yes") : EASResource.getString((String)RESOURCE, (String)"no");
    }
}

