/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JScrollBar;

public class DataSelectFilterPanel
extends KDPanel {
    public KDTable tblMain = new KDTable();
    private static final int COLUMN_NUM = 2;
    private static final String[] HEAD_NAMES = new String[]{"code", "name"};
    private String easCommonResource = "com.kingdee.eas.common.EASCommonResource";
    private static final String commonEntityFilterRes = "com.kingdee.eas.base.commonquery.client.CommonEntityFilter";
    private EntityObjectInfo entity = null;
    private int width = 250;
    private int height = 80;
    private int defaultRowNum = 6;
    private KDWorkButton addRowButton;
    private KDWorkButton delRowButton;
    private KDWorkButton clearButton;
    private RuleInfo editData;
    KDBizPromptBox prmtNumber = new KDBizPromptBox();
    private static final int NUMBER_COL_INDEX = 0;
    private static final int NAME_COL_INDEX = 1;
    private String defaultQuery = null;

    public DataSelectFilterPanel(IMetaDataPK metaDataPK, RuleInfo editData) throws Exception {
        this.entity = Util.getEntity((IMetaDataPK)metaDataPK);
        this.editData = editData;
        this.defaultQuery = this.entity.getExtendedProperty("defaultF7Query");
        this.onLoad();
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(this.width, this.height));
        this.addRowButton = new KDWorkButton();
        this.addRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.addRowButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"addRow"));
        this.addRowButton.setBounds(this.width - 8 - 22 - 3 - 22 - 3 - 22, 3, 22, 19);
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSelectFilterPanel.this.addRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.addRowButton);
        this.delRowButton = new KDWorkButton();
        this.delRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.delRowButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"removeRow"));
        this.delRowButton.setBounds(this.width - 8 - 22 - 3 - 22, 3, 22, 19);
        this.delRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSelectFilterPanel.this.delRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.delRowButton);
        this.clearButton = new KDWorkButton();
        this.clearButton.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.clearButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"clear"));
        this.clearButton.setBounds(this.width - 8 - 22, 3, 22, 19);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSelectFilterPanel.this.clearButton_actionPerformed(e);
            }
        });
        this.add((Component)this.clearButton);
        this.add((Component)this.tblMain);
    }

    public void onLoad() throws Exception {
        this.initTable();
        this.loadDatas();
        this.setF7Filter();
    }

    private void initTable() {
        for (int i = 0; i < 2; ++i) {
            this.tblMain.addColumn();
        }
        IRow headRow = this.tblMain.addHeadRow();
        for (int i = 0; i < 2; ++i) {
            headRow.getCell(i).setValue((Object)EASResource.getString((String)this.easCommonResource, (String)HEAD_NAMES[i]));
        }
        this.fillLeftRows();
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        this.prmtNumber.setQueryInfo(this.defaultQuery);
        this.prmtNumber.setEnabledMultiSelection(true);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtNumber);
        this.tblMain.getColumn(0).setEditor((ICellEditor)cellEditor);
        this.tblMain.getColumn(1).getStyleAttributes().setLocked(true);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblMain.getColumn(0).setRenderer((IBasicRender)avr);
        this.tblMain.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.tblMain.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.tblMain.getColumn(1).setWidth(150);
        this.tblMain.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                DataSelectFilterPanel.this.propertyChanged(evt);
            }
        });
    }

    private void setF7Filter() {
        EntityViewInfo view = this.prmtNumber.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        String dataIds = this.getDataIds().replaceAll("'", "");
        FilterItemInfo item = new FilterItemInfo("id", (Object)dataIds, CompareType.NOTINCLUDE);
        if (!StringUtils.isEmpty((String)dataIds)) {
            filter.getFilterItems().add(item);
        }
        view.setFilter(filter);
        this.prmtNumber.setEntityViewInfo(view);
    }

    private void propertyChanged(KDTPropertyChangeEvent e) {
        int i;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex != 0) {
            return;
        }
        Object value = e.getNewValue();
        if (value == null || !(value instanceof Object[])) {
            return;
        }
        Object[] datas = (Object[])value;
        for (i = 0; i < datas.length - 1; ++i) {
            this.tblMain.addRow(rowIndex);
        }
        for (i = 0; i < datas.length; ++i) {
            ICell numberCell = this.tblMain.getCell(rowIndex + i, 0);
            ICell nameCell = this.tblMain.getCell(rowIndex + i, 1);
            IObjectValue data = (IObjectValue)datas[i];
            numberCell.setValue((Object)data);
            nameCell.setValue(data.get("name"));
        }
        this.setF7Filter();
    }

    public KDTable getTable() {
        return this.tblMain;
    }

    private boolean isMultiSelect(Object value) {
        return value != null && ((Object[])value).length > 1;
    }

    protected void addRowButton_actionPerformed(ActionEvent e) {
        this.addRow();
    }

    protected void delRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonEntityFilterRes, (String)"delWarning"));
        } else {
            this.delRow();
        }
    }

    protected void clearButton_actionPerformed(ActionEvent e) {
        this.clear();
    }

    private void addRow() {
        int currentRowSize = this.tblMain.getRowCount();
        this.tblMain.addRow(currentRowSize);
    }

    private void delRow() {
        int selectedRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        this.tblMain.removeRow(selectedRowIndex);
        this.setF7Filter();
    }

    protected void clearTable() {
        this.tblMain.removeRows();
    }

    public void clear() {
        this.clearTable();
        this.fillLeftRows();
    }

    private void fillLeftRows() {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount < this.defaultRowNum) {
            for (int i = 0; i < this.defaultRowNum - rowCount; ++i) {
                this.tblMain.addRow();
            }
        }
    }

    public KDWorkButton getAddRowButton() {
        return this.addRowButton;
    }

    public KDWorkButton getDelRowButton() {
        return this.delRowButton;
    }

    public KDWorkButton getClearButton() {
        return this.clearButton;
    }

    public String getDataIds() {
        ArrayList<Object> idList = new ArrayList<Object>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            ICell cell = this.tblMain.getCell(i, 0);
            Object valueObject = cell.getValue();
            if (valueObject == null || !(valueObject instanceof IObjectValue)) continue;
            idList.add(((IObjectValue)valueObject).get("id"));
        }
        if (idList.size() == 0) {
            return "";
        }
        return ToolUtils.aryToStr(idList);
    }

    public void loadDatas() throws BOSException, EASBizException {
        String dataIds = this.editData.getDataIds();
        if (StringUtils.isEmpty((String)dataIds) || "''".equals(dataIds)) {
            return;
        }
        IDynamicObject object = DynamicObjectFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer();
        oql.append("select id,number,name where id in (").append(dataIds).append(")");
        IObjectCollection col = object.getCollection(this.entity.getType(), oql.toString());
        for (int i = col.size() - 1; i >= 0; --i) {
            IObjectValue objectValue = col.getObject(i);
            IRow row = this.tblMain.addRow(0);
            row.getCell(0).setValue((Object)objectValue);
            row.getCell(1).setValue(objectValue.get("name"));
        }
    }
}

