/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.ui.util.UICommonUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.DynamicCardStateEnum;
import com.kingdee.eas.base.permission.DynamicCardUserCollection;
import com.kingdee.eas.base.permission.DynamicCardUserFactory;
import com.kingdee.eas.base.permission.DynamicCardUserInfo;
import com.kingdee.eas.base.permission.IDynamicCardUser;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserAuthenWayChangeFacadeFactory;
import com.kingdee.eas.base.permission.UserAuthenWayChangeStateEnum;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractDynamicCardUserListUI;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.util.UITableHelper;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.security.client.DynamicCardConfigUI;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DynamicCardUserListUI
extends AbstractDynamicCardUserListUI {
    private static final Logger logger = CoreUIObject.getLogger(DynamicCardUserListUI.class);
    private static String DYNAMIC_INDEX_NAME = "dynamicState";
    private static String USER_LOGIN_AUTHOR_WAY_INDEX_NAME = "loginAuthorWay";
    private static String ID_INDEX_NAME = "id";
    private static String USER_ID_NAME = "user.id";
    private IDynamicCardUser iDynamicCardUser = null;
    private static String RESOURCE_NAME = "com.kingdee.eas.base.permission.PermissionResource";

    public DynamicCardUserListUI() throws Exception {
        this.hideButton();
        this.initButton();
    }

    private void hideButton() {
        this.menuItemView.setVisible(false);
        this.menuItemLocate.setVisible(false);
    }

    private void initButton() {
        this.btnStartCard.setIcon(EASResource.getIcon((String)"imgLight_green"));
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("CurrentUserPK", (Object)ToolUtils.getCurrentUserPK());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    private FilterInfo getRangeUser() throws EASBizException, BOSException, UuidException, ParserException {
        UserListUIHelper helper = new UserListUIHelper();
        return helper.getCurrentRangeUserMayBeAdmin();
    }

    private EntityViewInfo getMaySelectUser() throws Exception {
        FilterInfo filterInfo = this.getRangeUser();
        FilterInfo notSelectUserFilterInfo = this.getNotIncludeUser();
        if (notSelectUserFilterInfo != null) {
            filterInfo.mergeFilter(notSelectUserFilterInfo, "AND");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private List getAlreadUserId() throws Exception {
        ArrayList retList = new ArrayList();
        DynamicCardUserCollection dynamicCol = this.getDynamicCardUser().getDynamicCardUserCollection("select id, user.id");
        if (dynamicCol == null || dynamicCol.isEmpty()) {
            return retList;
        }
        return ToolUtils.transCol2ListByPeroperty((IObjectCollection)dynamicCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                DynamicCardUserInfo dynamicCardUserInfo = (DynamicCardUserInfo)obj;
                if (dynamicCardUserInfo.getUser() != null && dynamicCardUserInfo.getUser().getId() != null) {
                    return dynamicCardUserInfo.getUser().getId().toString();
                }
                return null;
            }
        });
    }

    private FilterInfo getNotIncludeUser() throws Exception {
        List alreadlyUserIdList;
        FilterInfo filterInfo = new FilterInfo();
        if (!PermissionCommonUtil.isAuthenticateAdminEnabled(null)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id ", (Object)"00000000-0000-0000-0000-00000000000113B7DE7F", CompareType.NOTEQUALS));
        }
        if ((alreadlyUserIdList = this.getAlreadUserId()) != null && !alreadlyUserIdList.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(alreadlyUserIdList, false), CompareType.NOTINCLUDE));
        }
        return filterInfo;
    }

    @Override
    public boolean isPrepareActionSelectUser() {
        return true;
    }

    @Override
    public RequestContext prepareActionCancelUser(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    @Override
    public void actionSelectUser_actionPerformed(ActionEvent e) throws Exception {
        Object obj;
        UserPromptBox dlg = null;
        IUIWindow win = this.getUIWindow();
        dlg = new UserPromptBox(win.getUIObject());
        dlg.setEnabledMultiSelection(true);
        EntityViewInfo entityViewInfo = this.getMaySelectUser();
        dlg.setEntityViewInfo(entityViewInfo);
        dlg.show();
        if (!dlg.isCanceled() && (obj = dlg.getData()) != null) {
            Object[] objAry = (Object[])obj;
            DynamicCardUserCollection dynamicUserMapCol = new DynamicCardUserCollection();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < objAry.length; ++i) {
                DynamicCardUserInfo dynamicCardUserInfo = new DynamicCardUserInfo();
                UserInfo userInfo = (UserInfo)objAry[i];
                dynamicCardUserInfo.setUser(userInfo);
                dynamicCardUserInfo.setDynamicState(DynamicCardStateEnum.init);
                dynamicUserMapCol.add(dynamicCardUserInfo);
                sb.append(userInfo.getNumber()).append("\uff1b");
            }
            sb.deleteCharAt(sb.length() - 1);
            IObjectPK logPK = LogUtil.beginLog(null, (String)"addnewMany", (BOSObjectType)new BOSObjectType("4735FD26"), null, (String)(EASResource.getString((String)RESOURCE_NAME, (String)"ADDNEW_USE_DYN_PWD") + "\u201c" + sb.toString() + "\u201d"), (String)"dynamicCard_chose_user");
            this.getDynamicCardUser().addnewMany(dynamicUserMapCol);
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
        this.refreshList();
    }

    @Override
    public void actionCancelUser_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String promptStr = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                BizEnumValueInfo dynamicState = (BizEnumValueInfo)this.tblMain.getValueAt(j, UITools.getColumnIndexByName(this.tblMain, DYNAMIC_INDEX_NAME));
                BizEnumValueInfo loginAuthorWay = (BizEnumValueInfo)this.tblMain.getValueAt(j, UITools.getColumnIndexByName(this.tblMain, USER_LOGIN_AUTHOR_WAY_INDEX_NAME));
                if (0 == loginAuthorWay.getInt()) {
                    arrayList.add(this.tblMain.getValueAt(j, UITools.getColumnIndexByName(this.tblMain, ID_INDEX_NAME)));
                    sb.append(this.tblMain.getValueAt(j, UITools.getColumnIndexByName(this.tblMain, "user.number"))).append(";");
                    continue;
                }
                if (promptStr != null) continue;
                promptStr = EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUsbKeyResource", (String)"ONLY_NORMAL_USER_BE_CANCEL");
            }
        }
        if (arrayList.isEmpty()) {
            logger.info((Object)"no data select , return!");
            if (promptStr != null) {
                MsgBox.showInfo((Component)((Object)this), promptStr);
            }
            return;
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUsbKeyResource", (String)"USER_REMOVE")))) {
            return;
        }
        ObjectStringPK[] idPKAry = new ObjectStringPK[arrayList.size()];
        int size2 = arrayList.size();
        for (int i = 0; i < size2; ++i) {
            idPKAry[i] = new ObjectStringPK((String)arrayList.get(i));
        }
        IObjectPK logPK = LogUtil.beginLog(null, (String)"delete", (BOSObjectType)new BOSObjectType("4735FD26"), null, (String)(EASResource.getString((String)RESOURCE_NAME, (String)"user") + "\u201c" + sb.toString() + EASResource.getString((String)RESOURCE_NAME, (String)"SYN_PWD_LIST_DELETE") + "\u201d"), (String)"dynamicCard_delete_user");
        this.getDynamicCardUser().delete((IObjectPK[])idPKAry);
        LogUtil.afterLog(null, (IObjectPK)logPK);
        this.tblMain.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionExportUser_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        List userId = UITools.getUserIdList(this.tblMain, UITools.getColumnIndexByName(this.tblMain, USER_ID_NAME));
        IUser iUser = UserFactory.getRemoteInstance();
        String oql = "select id,name where isDelete=0 and id in (" + ToolUtils.aryToStr(userId, true) + ")";
        UserCollection userCol = iUser.getUserCollection(oql);
        String fileName = this.getFileName();
        if (StringUtils.isEmpty((String)fileName)) {
            return;
        }
        File file = new File(fileName);
        if (file == null || file.isDirectory() && file.exists()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"FileNotExist_Error"));
            this.abort();
        }
        FileOutputStream fileOut = null;
        OutputStreamWriter fileOutStream = null;
        try {
            fileOut = new FileOutputStream(file);
            fileOutStream = new OutputStreamWriter((OutputStream)fileOut, "UTF-8");
            int size = userCol.size();
            for (int i = 0; i < size; ++i) {
                UserInfo userInfo = userCol.get(i);
                fileOutStream.write(userInfo.getId().toString() + "," + userInfo.getName() + "\r\n");
                if (i % 100 != 0) continue;
                fileOut.flush();
            }
        }
        finally {
            if (fileOutStream != null) {
                try {
                    fileOutStream.close();
                }
                catch (IOException ioException) {
                    logger.error((Object)ioException.getMessage(), (Throwable)ioException);
                    this.handUIException(ioException);
                }
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException ioException) {
                    logger.error((Object)ioException.getMessage(), (Throwable)ioException);
                    this.handUIException(ioException);
                }
            }
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
    }

    private String getFileName() {
        KDFileChooser fc = new KDFileChooser(System.getProperty("user.home"));
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        int retVal = fc.showSaveDialog((Component)((Object)this));
        if (retVal == 1) {
            return null;
        }
        return fc.getSelectedFile().getAbsolutePath();
    }

    @Override
    public boolean isPrepareActionForbidden() {
        return true;
    }

    @Override
    public RequestContext prepareActionForbidden(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    @Override
    public void actionForbidden_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UITableHelper tableHelper = new UITableHelper(this.tblMain);
        tableHelper.recordRow();
        this.setDynamicCardState(DynamicCardStateEnum.forbid);
        this.setUserLoginAuthorWay(LoginAuthorWayEnum.NORMAL);
        this.tblMain.refresh();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"saveSuccessed"));
        tableHelper.restoreRow();
    }

    @Override
    public RequestContext prepareActionStartUser(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            ArrayList idList = this.getSelectedIdValues();
            request.put("idList", (Object)idList);
            List userIdList = UITools.getUserIdList(this.tblMain, UITools.getColumnIndexByName(this.tblMain, USER_ID_NAME));
            request.put("userIdList", (Object)userIdList);
        }
        return request;
    }

    @Override
    public boolean isPrepareActionStartUser() {
        return true;
    }

    @Override
    public RequestContext prepareActionStartUserSecond(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            ArrayList idList = this.getSelectedIdValues();
            request.put("idList", (Object)idList);
            List userIdList = UITools.getUserIdList(this.tblMain, UITools.getColumnIndexByName(this.tblMain, USER_ID_NAME));
            request.put("userIdList", (Object)userIdList);
        }
        return request;
    }

    @Override
    public boolean isPrepareActionStartUserSecond() {
        return true;
    }

    @Override
    public void actionStartUser_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UITableHelper tableHelper = new UITableHelper(this.tblMain);
        tableHelper.recordRow();
        this.setUserLoginAuthorWay(LoginAuthorWayEnum.DYNAMIC);
        this.tblMain.refresh();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"saveSuccessed"));
        tableHelper.restoreRow();
    }

    @Override
    public void actionStartUserSecond_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UITableHelper tableHelper = new UITableHelper(this.tblMain);
        tableHelper.recordRow();
        this.setUserLoginAuthorWay(LoginAuthorWayEnum.NORMAL_DYNAMIC);
        this.tblMain.refresh();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"saveSuccessed"));
        tableHelper.restoreRow();
    }

    private void setDynamicCardState(DynamicCardStateEnum dynamicState) throws EASBizException, BOSException, Exception {
        ArrayList idList = this.getSelectedIdValues();
        Object someDataNotRight = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String dynamicCardMapId = (String)idList.get(i);
            DynamicCardUserInfo dynamicCardUserInfo = this.getDynamicCardUser().getDynamicCardUserInfo("select *,user.number where id='" + dynamicCardMapId + "'");
            dynamicCardUserInfo.setDynamicState(dynamicState);
            IObjectPK logPK = null;
            logPK = DynamicCardStateEnum.started.equals((Object)dynamicState) ? LogUtil.beginLog(null, (String)"update", (BOSObjectType)new BOSObjectType("4735FD26"), null, (String)(EASResource.getString((String)RESOURCE_NAME, (String)"user") + "\u201c" + dynamicCardUserInfo.getUser().getNumber() + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"ENABLE_DYN_PWD")), (String)"dynamicCard_enable_user") : LogUtil.beginLog(null, (String)"update", (BOSObjectType)new BOSObjectType("4735FD26"), null, (String)(EASResource.getString((String)RESOURCE_NAME, (String)"user") + "\u201c" + dynamicCardUserInfo.getUser().getNumber() + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"DISABLE_DYN_PWD")), (String)"dynamicCard_enable_user");
            this.getDynamicCardUser().update((IObjectPK)new ObjectStringPK(dynamicCardMapId), dynamicCardUserInfo);
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
    }

    private void unregisterUserCertfication(List userList) throws BOSException, EASBizException {
        UserFactory.getRemoteInstance().setRegisterResult(userList, false);
    }

    private List getSelectUserIDList() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        Iterator it = range.iterator();
        ArrayList<String> userIDList = new ArrayList<String>();
        while (it.hasNext()) {
            KDTSelectBlock block = (KDTSelectBlock)it.next();
            int bottom = block.getBottom();
            for (int index = block.getTop(); index <= bottom; ++index) {
                String userId = (String)this.tblMain.getRow(index).getCell(USER_ID_NAME).getValue();
                if (StringUtils.isEmpty((String)userId)) continue;
                userIDList.add(userId);
            }
        }
        return userIDList;
    }

    private void setUserLoginAuthorWay(LoginAuthorWayEnum loginAuthorWayEnum) throws EASBizException, BOSException {
        List userIdList = UITools.getUserIdList(this.tblMain, UITools.getColumnIndexByName(this.tblMain, USER_ID_NAME));
        List userNumberList = UITools.getUserIdList(this.tblMain, UITools.getColumnIndexByName(this.tblMain, "user.number"));
        if (userIdList != null && !userIdList.isEmpty()) {
            IUser iUser = UserFactory.getRemoteInstance();
            IObjectPK logPK = null;
            logPK = LoginAuthorWayEnum.NORMAL.equals((Object)loginAuthorWayEnum) ? LogUtil.beginLog(null, (String)"updateLoginAuthorWay", (BOSObjectType)new BOSObjectType("4735FD26"), null, (String)("\u7528\u6237\u201c" + ToolUtils.aryToStr(userNumberList.toArray(), true) + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"RESTORE_LOGIN_AUTHEN")), (String)"dynamicCard_disable_login") : (LoginAuthorWayEnum.NORMAL_DYNAMIC.equals((Object)loginAuthorWayEnum) ? LogUtil.beginLog(null, (String)"updateLoginAuthorWay", (BOSObjectType)new BOSObjectType("4735FD26"), null, (String)("\u7528\u6237\u201c" + ToolUtils.aryToStr(userNumberList.toArray(), true) + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"ENABLE_DOUBLE_AUTHEN")), (String)"dynamicCard_enable_login") : LogUtil.beginLog(null, (String)"updateLoginAuthorWay", (BOSObjectType)new BOSObjectType("4735FD26"), null, (String)("\u7528\u6237\u201c" + ToolUtils.aryToStr(userNumberList.toArray(), true) + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"ENABLE_LOGIN_AUTHEN")), (String)"dynamicCard_enable_login"));
            iUser.updateLoginAuthorWay(userIdList, loginAuthorWayEnum);
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
    }

    private List getSelectDynamicCardAuthenWayUserIDList() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        Iterator it = range.iterator();
        ArrayList<String> userIDList = new ArrayList<String>();
        while (it.hasNext()) {
            KDTSelectBlock block = (KDTSelectBlock)it.next();
            int bottom = block.getBottom();
            for (int index = block.getTop(); index <= bottom; ++index) {
                int loginAuthenWay;
                String userId = (String)this.tblMain.getRow(index).getCell(USER_ID_NAME).getValue();
                if (StringUtils.isEmpty((String)userId) || (loginAuthenWay = ((BizEnumValueInfo)this.tblMain.getRow(index).getCell(USER_LOGIN_AUTHOR_WAY_INDEX_NAME).getValue()).getInt()) == 0) continue;
                userIDList.add(userId);
            }
        }
        return userIDList;
    }

    private void prepareActionRestoreAfterConfirm() throws Exception {
        IUIActionPostman handle = super.prepareInit();
        RequestContext request = new RequestContext();
        List userIdList = UITools.getUserIdList(this.tblMain, UITools.getColumnIndexByName(this.tblMain, USER_ID_NAME));
        request.put("userIdList", (Object)userIdList);
        request.setMethodName("_handleActionRestoreAfterConfirm");
        handle.setRequestContext((Serializable)request);
        handle.callHandler();
    }

    @Override
    public void actionRestoreUser_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UITableHelper tableHelper = new UITableHelper(this.tblMain);
        tableHelper.recordRow();
        if (!MsgBox.isOk((int)MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_NAME, (String)"user_authorway_change_prompt")))) {
            return;
        }
        this.prepareActionRestoreAfterConfirm();
        List dynamicCardAuthenWayUserIDList = this.getSelectDynamicCardAuthenWayUserIDList();
        this.unregisterUserCertfication(dynamicCardAuthenWayUserIDList);
        UserAuthenWayChangeFacadeFactory.getRemoteInstance().userAuthenWayChange(dynamicCardAuthenWayUserIDList, 20, UserAuthenWayChangeStateEnum.DynamicCard_RestoreNormalAuthenWay.getAlias());
        this.setUserLoginAuthorWay(LoginAuthorWayEnum.NORMAL);
        this.tblMain.refresh();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
        tableHelper.restoreRow();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DynamicCardUserFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            FilterInfo filterInfo = new FilterInfo("CU.id IN (" + PermissionRangeHelper.getUserOrgIdRangeSQL(null, ToolUtils.getCurrentUserPK(), null) + ")");
            return filterInfo;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (ParserException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }

    private IDynamicCardUser getDynamicCardUser() throws Exception {
        if (this.iDynamicCardUser == null) {
            this.iDynamicCardUser = (IDynamicCardUser)this.getBizInterface();
        }
        return this.iDynamicCardUser;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectUser.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.menuSelect.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnCancelUser.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.menuCancelUser.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnStart.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnExportUser.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnForbidden.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemForbidUsbKey.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemStartLoginAuthorWay.setIcon(EASResource.getIcon((String)"imgTbtn_reappperform"));
        this.btnRestore.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.menuItemRestoreLoginAuthorWay.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
    }

    @Override
    public void actionServerConfig_actionPerformed(ActionEvent e) throws Exception {
        Frame owner = null;
        owner = this.getUIWindow() == null ? (Frame)this.getUIContext().get("OwnerWindow") : (Frame)SwingUtilities.getWindowAncestor((Component)((Object)this));
        KDDialog dialog = new KDDialog(owner, true);
        UIContext uiContext = new UIContext();
        IUIObject uiObject = UIFactoryHelper.initUIObject((String)DynamicCardConfigUI.class.getName(), (Map)uiContext, null, null);
        dialog.setTitle(uiObject.getUITitle());
        dialog.setSize(((Component)uiObject).getWidth() + 10, ((Component)uiObject).getHeight() + 40);
        dialog.getContentPane().add((Component)uiObject);
        dialog.setResizable(false);
        UICommonUtils.centerWindow((Window)dialog);
        dialog.show();
    }

    @Override
    public void actionStartCard_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UITableHelper tableHelper = new UITableHelper(this.tblMain);
        tableHelper.recordRow();
        this.setDynamicCardState(DynamicCardStateEnum.started);
        this.tblMain.refresh();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"saveSuccessed"));
        tableHelper.restoreRow();
    }
}

