/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.IDSecondAuthorizeCollection;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.IDSecondAuthorizeInfo;
import com.kingdee.eas.base.permission.IIDSecondAuthorize;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.client.AbstractIDSecondAuthorizeTreeUI;
import com.kingdee.eas.base.permission.client.IDSecondAuthorizeListUI;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.tree.IAccreditTreeBuilder;
import com.kingdee.eas.base.permission.client.tree.PermissionTreeBuilderFactory;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LowTimer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class IDSecondAuthorizeTreeUI
extends AbstractIDSecondAuthorizeTreeUI {
    private static final Logger logger = CoreUIObject.getLogger(IDSecondAuthorizeTreeUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
    private static String RESOURCE_NAME = "com.kingdee.eas.base.permission.PermissionResource";
    private IAccreditTreeBuilder builder = null;
    private Map addPermItemMap = new HashMap();
    private Map delPermItemMap = new HashMap();
    private boolean isModified = false;
    private PermItemCollection customPermItems = null;
    private KDTreeNode branchTreeNode;

    public IDSecondAuthorizeTreeUI() throws Exception {
        this.builder = PermissionTreeBuilderFactory.getPermItemTreeBuilder();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void onShow() throws Exception {
        this.buildTrees();
        super.onShow();
    }

    private void buildTrees() throws Exception {
        this.buildStandardTree();
        this.buildCustomTree();
    }

    private void buildStandardTree() throws Exception {
        KDTreeNode root = null;
        try {
            long startTime = System.currentTimeMillis();
            root = (KDTreeNode)this.treeDecoder();
            long elapseTime = System.currentTimeMillis() - startTime;
            logger.info((Object)(PermissionResUtil.getResource("res_90") + elapseTime + "ms."));
        }
        catch (Exception ex) {
            logger.error((Object)(PermissionResUtil.getResource("res_91") + ex));
            long startTime = System.currentTimeMillis();
            root = this.getStandardTreeRoot();
            long elapseTime = System.currentTimeMillis() - startTime;
            logger.info((Object)(PermissionResUtil.getResource("res_92") + elapseTime + "ms."));
            try {
                this.treeEncoder(root);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        ((DefaultTreeModel)this.standardTree.getModel()).setRoot((TreeNode)root);
    }

    private KDTreeNode getStandardTreeRoot() throws BOSException, Exception {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        endTime = lowTimer.msValue();
        logger.debug((Object)("getSourcePerms()  " + (endTime - beginTime)));
        IPermItem iPermItem = this.getPermItemCtroller();
        PermItemCollection perms = iPermItem.getAllLeaves();
        PermItemCollection extraPerms = this.getExtraPerms();
        perms.addCollection(extraPerms);
        KDTreeNode root = this.builder.buildTreeRoot(this.getTreeBranch(), (IObjectCollection)perms);
        return root;
    }

    private IPermItem getPermItemCtroller() throws BOSException {
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        return iPermItem;
    }

    private PermItemCollection getExtraPerms() throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"wf_multiapprove", CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        return this.getPermItemCtroller().getPermItemCollection(evi);
    }

    private void buildCustomTree() {
        try {
            KDTreeNode root;
            PermItemCollection permItemCol = this.getCustomAuthorizeInfo();
            if (permItemCol.size() == 0) {
                root = (KDTreeNode)((KDTreeNode)this.standardTree.getModel().getRoot()).clone();
            } else {
                for (int index = 0; index < permItemCol.size(); ++index) {
                    if (permItemCol.get(index).isIsLeaf()) continue;
                    permItemCol.removeObject(index);
                }
                root = this.builder.buildTreeRoot(this.getSecondAuthroizeTreeBranch(), (IObjectCollection)permItemCol);
            }
            ((DefaultTreeModel)this.customTree.getModel()).setRoot((TreeNode)root);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private KDTreeNode getTreeBranch() throws Exception {
        if (this.branchTreeNode == null) {
            this.branchTreeNode = this.builder.createTreeBranch();
        }
        return this.branchTreeNode;
    }

    private KDTreeNode getSecondAuthroizeTreeBranch() throws Exception {
        return this.builder.createSecondAuthorizeTree();
    }

    private PermItemCollection getCustomAuthorizeInfo() throws BOSException {
        if (this.customPermItems == null) {
            IIDSecondAuthorize iIDSecondAuthorize = IDSecondAuthorizeFactory.getRemoteInstance();
            this.customPermItems = iIDSecondAuthorize.getPermItemCollection();
            if (this.customPermItems == null) {
                this.customPermItems = new PermItemCollection();
            }
        }
        return this.customPermItems;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private IDSecondAuthorizeCollection[] getModifiedPermItems() throws BOSException {
        IDSecondAuthorizeCollection[] results = new IDSecondAuthorizeCollection[]{new IDSecondAuthorizeCollection(), new IDSecondAuthorizeCollection(), new IDSecondAuthorizeCollection()};
        this.saveAuthorTreeNodeInfo(results[0], this.addPermItemMap.values().iterator());
        this.saveAuthorTreeNodeInfo(results[1], this.delPermItemMap.values().iterator());
        return results;
    }

    private void saveAuthorTreeNodeInfo(IDSecondAuthorizeCollection result, Iterator it) {
        while (it.hasNext()) {
            PermItemInfo permInfo = (PermItemInfo)it.next();
            IDSecondAuthorizeInfo authInfo = new IDSecondAuthorizeInfo();
            authInfo.setAuthorizeType(AuthorizeTypeEnum.noAuthor);
            authInfo.setPermItem(permInfo);
            result.add(authInfo);
        }
    }

    private void save() {
        if (this.addPermItemMap.size() == 0 && this.delPermItemMap.size() == 0) {
            return;
        }
        try {
            IIDSecondAuthorize iIDSecondAuthorize = IDSecondAuthorizeFactory.getRemoteInstance();
            IObjectPK logPK = LogUtil.beginLog(null, (String)"saveAuthorizeResult", (BOSObjectType)new BOSObjectType("950E2203"), null, (String)EASResource.getString((String)RESOURCE_NAME, (String)"IMPORT_FUNCTION_TREE"), (String)"second_authorize_import_function");
            iIDSecondAuthorize.saveAuthorizeResult(this.getModifiedPermItems());
            LogUtil.afterLog(null, (IObjectPK)logPK);
            this.addPermItemMap.clear();
            this.delPermItemMap.clear();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                IDSecondAuthorizeTreeUI.this.save();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                UITools.showMsg(IDSecondAuthorizeTreeUI.this, EASResource.getString((String)IDSecondAuthorizeTreeUI.RESOURCE, (String)"infoTreeDefineSuccessful"), false);
            }
        });
        dialog.show();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        TreePath[] treePaths = this.standardTree.getSelectionPaths();
        if (treePaths != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                this.preparePermMap(treeNodes[i], this.addPermItemMap, this.delPermItemMap);
            }
            Set extendedNodes = this.builder.getExpendedNodes(this.standardTree);
            this.builder.addNodes(this.customTree, treeNodes, extendedNodes);
            this.builder.setDataRuleIcon((KDTreeNode)this.customTree.getModel().getRoot());
            this.customTree.repaint();
        }
    }

    private boolean preparePermMap(KDTreeNode rootNode, Map map1, Map map2) {
        PermItemInfo permInfo = (PermItemInfo)rootNode.getUserObject();
        if (permInfo.isIsLeaf()) {
            if (map2.containsKey(permInfo.getId())) {
                map2.remove(permInfo.getId());
            } else {
                map1.put(permInfo.getId(), permInfo);
                this.isModified = true;
            }
        }
        Enumeration permItemEnum = rootNode.children();
        while (permItemEnum.hasMoreElements()) {
            KDTreeNode node = (KDTreeNode)permItemEnum.nextElement();
            this.isModified = this.preparePermMap(node, map1, map2);
        }
        return this.isModified;
    }

    @Override
    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        TreePath[] treePaths = null;
        treePaths = this.customTree.getSelectionPaths();
        if (treePaths != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                this.preparePermMap(treeNodes[i], this.delPermItemMap, this.addPermItemMap);
            }
            this.builder.removeNodes(this.customTree, treeNodes);
        }
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        Object object = this.standardTree.getModel().getRoot();
        if (object != null && object instanceof KDTreeNode) {
            this.delPermItemMap.clear();
            this.preparePermMap((KDTreeNode)object, this.addPermItemMap, this.delPermItemMap);
            Set extendedNodes = this.builder.getExpendedNodes(this.standardTree);
            this.builder.addNodes(this.customTree, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
            this.builder.setDataRuleIcon((KDTreeNode)this.customTree.getModel().getRoot());
        }
    }

    public boolean destroyWindow() {
        if (this.isModified) {
            try {
                ((IDSecondAuthorizeListUI)((Object)this.getUIContext().get("Owner"))).reLoadTree();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return super.destroyWindow();
    }

    @Override
    protected void btnDelAll_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode object = null;
        object = (KDTreeNode)this.customTree.getModel().getRoot();
        if (object != null) {
            this.preparePermMap(object, this.delPermItemMap, this.addPermItemMap);
            this.addPermItemMap.clear();
            this.builder.removeNodes(this.customTree, new KDTreeNode[]{object});
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnDelAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void treeEncoder(Object obj) throws IOException {
        FileOutputStream fop = null;
        ObjectOutputStream encoder = null;
        try {
            File treeFile = this.getSerialFile();
            fop = new FileOutputStream(treeFile);
            encoder = new ObjectOutputStream(fop);
            encoder.writeObject(obj);
            encoder.flush();
        }
        finally {
            if (fop != null) {
                fop.close();
            }
            if (encoder != null) {
                encoder.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object treeDecoder() throws IOException, ClassNotFoundException {
        Object obj;
        FileInputStream fin = null;
        ObjectInputStream decoder = null;
        try {
            File treeFile = this.getSerialFile();
            fin = new FileInputStream(treeFile);
            decoder = new ObjectInputStream(fin);
            obj = decoder.readObject();
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (decoder != null) {
                try {
                    decoder.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return obj;
    }

    private File getSerialFile() {
        String cfgFileName = "authorizeTree.serial";
        String pathEnv = "eas.deploy";
        String serialFilePath = new StringBuffer().append(System.getProperty(pathEnv)).append(File.separator).append("authorizeTree.serial").toString();
        File serialFile = new File(serialFilePath);
        return serialFile;
    }
}

