/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.MachineRegisterFactory;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.client.AbstractMachineRegisterListUI;
import com.kingdee.eas.base.permission.client.MCValidataUserManagerListUI;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;

public class MachineRegisterListUI
extends AbstractMachineRegisterListUI {
    private static final Logger logger = CoreUIObject.getLogger(MachineRegisterListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
    ISecurityAuthParamManager manager = SecurityAuthParamManagerFactory.getRemoteInstance();

    public MachineRegisterListUI() throws Exception {
        this.menuItemAddNew.setVisible(false);
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPass.setIcon(EASResource.getIcon((String)"imgTbtn_putin"));
        this.btnNotPass.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnRemove.setVisible(true);
        this.btnRemove.setEnabled(true);
        this.setAuthButtonState(this.manager.getMachineCodeAuthState());
    }

    public void onShow() throws Exception {
        ToolUtils.setTableAutoSort(this.tblMain);
        super.onShow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean isIgnoreCUFilter() {
        return "00000000-0000-0000-0000-00000000000013B7DE7F".equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public RequestContext prepareActionPass(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            request.put("getSelectedIdValues", (Object)this.getSelectedIdValues());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionPass() {
        return true;
    }

    @Override
    public void actionPass_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.registerMachine(e, true);
    }

    @Override
    public RequestContext prepareActionNotPass(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            request.put("getSelectedIdValues", (Object)this.getSelectedIdValues());
            request.put("getSelectedIP", (Object)this.getSelectedIP());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionNotPass() {
        return true;
    }

    @Override
    public void actionNotPass_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.registerMachine(e, false);
        this.clientKickedOut(this.getSelectedIP());
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String[] selectedIP = this.getSelectedIP();
        IObjectPK logPK = LogUtil.beginLog(null, (String)"remove", (BOSObjectType)new BOSObjectType("AB1AB4D6"), null, (String)(EASResource.getString((String)RESOURCE, (String)"DELETE_CLIENT_IP") + "\u201c" + ToolUtils.aryToStr(selectedIP) + EASResource.getString((String)RESOURCE, (String)"AUTHEN_DATA") + "\u201d"), (String)"machineCode_delete");
        super.actionRemove_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)logPK);
        this.clientKickedOut(selectedIP);
    }

    private void clientKickedOut(String[] ips) {
        try {
            UserMonitorFactory.getRemoteInstance().deleteByIPs(ips);
        }
        catch (Exception ex) {
            logger.error((Object)PermissionResUtil.getResource("res_94"), (Throwable)ex);
        }
    }

    private String[] getSelectedIP() {
        int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String[] ips = new String[rowIndexs.length];
        for (int index = 0; index < rowIndexs.length; ++index) {
            Object ip = this.tblMain.getRow(rowIndexs[index]).getCell("ip").getValue();
            if (ip != null) {
                ips[index] = ip.toString();
                continue;
            }
            logger.error((Object)(PermissionResUtil.getResource("res_95") + "IP" + PermissionResUtil.getResource("res_55")));
        }
        return ips;
    }

    private void registerMachine(ActionEvent e, boolean isRegistered) throws BOSException, EASBizException, Exception {
        try {
            UserFactory.getRemoteInstance().setRegisterResult(this.getSelectedIdValues(), isRegistered);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.actionRefresh_actionPerformed(e);
        String msgInfo = "infoMachineNotPassRegistered";
        if (isRegistered) {
            msgInfo = "infoMachinePassRegistered";
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)msgInfo));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MachineRegisterFactory.getRemoteInstance();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"creator.number", "ip"};
        return locateNames;
    }

    @Override
    public void actionEnableAuth_actionPerformed(ActionEvent e) throws Exception {
        this.setAuthState(true);
    }

    @Override
    public void actionForbidAuth_actionPerformed(ActionEvent e) throws Exception {
        this.setAuthState(false);
    }

    private void setAuthState(boolean isEnableAuth) {
        String ResourceName = "EnableMachineCodeAuthMsg";
        if (!isEnableAuth) {
            ResourceName = "ForbidMachineCodeAuthMsg";
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)ResourceName)))) {
            IObjectPK logPK = null;
            logPK = isEnableAuth ? LogUtil.beginLog(null, (String)"storeMachineCodeAuthState", (BOSObjectType)new BOSObjectType("AB1AB4D6"), null, (String)EASResource.getString((String)RESOURCE, (String)"ENABLE_MACHINE_AHTH"), (String)"machineCode_enable") : LogUtil.beginLog(null, (String)"storeMachineCodeAuthState", (BOSObjectType)new BOSObjectType("AB1AB4D6"), null, (String)EASResource.getString((String)RESOURCE, (String)"DISABLE_MACHINE_AUTH"), (String)"machineCode_enable");
            this.manager.storeMachineCodeAuthState(isEnableAuth);
            LogUtil.afterLog(null, (IObjectPK)logPK);
            this.setAuthButtonState(isEnableAuth);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"infoConfigSuccessful"));
        }
    }

    private void setAuthButtonState(boolean isEnableAuth) {
        this.setEnableAuthButtonState(isEnableAuth);
        this.setForbidAuthButtonState(isEnableAuth);
        this.btnPass.setEnabled(isEnableAuth);
        this.btnNotPass.setEnabled(isEnableAuth);
    }

    private void setEnableAuthButtonState(boolean isEnableAuth) {
        this.btnEnableAuth.setEnabled(!isEnableAuth);
        if (isEnableAuth) {
            this.btnEnableAuth.setToolTipText(EASResource.getString((String)RESOURCE, (String)"MachineCodeAuthEnabled"));
        } else {
            this.btnEnableAuth.setToolTipText("");
        }
    }

    private void setForbidAuthButtonState(boolean isEnableAuth) {
        this.btnForbidAuth.setEnabled(isEnableAuth);
        if (!isEnableAuth) {
            this.btnForbidAuth.setToolTipText(EASResource.getString((String)RESOURCE, (String)"MachineCodeAuthForbided"));
        } else {
            this.btnForbidAuth.setToolTipText("");
        }
    }

    @Override
    public void actionMaintainOtherUser_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(MCValidataUserManagerListUI.class.getName(), (Map)uiContext, null);
        ui.show();
    }
}

