/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserOrgPermFacade;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.AbstractNewUserPermViewUI;
import com.kingdee.eas.base.permission.client.RulePanel;
import com.kingdee.eas.base.permission.client.UserDiscretePermViewUI;
import com.kingdee.eas.base.permission.client.UserFieldAccessViewUI;
import com.kingdee.eas.base.permission.client.f7.AccreditF7PromptDialog;
import com.kingdee.eas.base.permission.client.f7.ManageF7PromptDialog;
import com.kingdee.eas.base.permission.client.helper.NewUserAccreditTreeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import org.apache.log4j.Logger;

public class NewUserPermViewUI
extends AbstractNewUserPermViewUI {
    private static Logger logger = Logger.getLogger(NewUserPermViewUI.class);
    private static final String permissionResource = "com.kingdee.eas.base.permission.PermissionResource";
    private boolean isShowRule = false;
    private RulePanel rulePanel = null;
    private UserInfo targetUser = null;
    private ManageF7PromptDialog manageF7PromptDialog = null;
    private AccreditF7PromptDialog accreditF7PromptDialog = null;
    private NewUserAccreditTreeHelper treeHelper = null;
    private ConfigurationInfo configurationInfo = null;
    private boolean hasShowAuthorization = false;
    private boolean hasShowNormal = false;
    private boolean hasShowForbidden = false;
    FullOrgUnitInfo lastAccreditF7DialogSelected = null;
    FullOrgUnitInfo lasectrlUnitF7DialogSelected = null;

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("CurrentUserPK", (Object)ToolUtils.getCurrentUserPK());
            request.put("TargetUserPK", (Object)this.getTargetUserPK());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    private void initUI() throws Exception {
        this.rulePanel = new RulePanel();
        this.rulePanel.setStatus(this.getOprtState() == null ? OprtState.VIEW : this.getOprtState());
        this.add((Component)((Object)this.rulePanel), null);
        this.rulePanel.setBounds(new Rectangle(0, 345, 630, 170));
        this.remove((Component)this.tabAssign);
        this.add((Component)this.tabAssign, new KDLayout.Constraints(10, 32, 610, 480, 325));
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.btnDiscretePerm.setVisible(false);
        this.btnFieldAccessAccredit.setVisible(false);
        this.tHelper.getDisabledTables().add(this.rulePanel.getTable());
        this.lbcOrg.setBoundLabelText(OrgRangeType.BIZ_ORG_TYPE.getAlias(this.getLocale()));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        if (Administrator.isCUAdmin(null, this.getTargetUserPK())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"adminCanNotViewPerm"));
            this.abort();
        }
        this.setUserInfo();
        this.initTab();
        this.initTrees();
        this.initOrgF7();
        this.loadConfigurationInfo();
        this.tabAssign.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    NewUserPermViewUI.this.tabAssign_stateChanged(e);
                }
                catch (Exception exc) {
                    NewUserPermViewUI.this.handUIException(exc);
                }
            }
        });
    }

    private void tabAssign_stateChanged(ChangeEvent e) throws Exception {
        int tabIndex = this.tabAssign.getSelectedIndex();
        if (tabIndex == 0) {
            if (this.manageF7PromptDialog == null) {
                this.manageF7PromptDialog = new ManageF7PromptDialog((IUIObject)this, this.targetUser);
                this.pmtOrg.setData(this.manageF7PromptDialog.getDefaultData());
            }
            this.manageF7PromptDialog.setMultiSelect(false);
            this.pmtOrg.setSelector((KDPromptSelector)this.manageF7PromptDialog);
            this.pmtOrg.setData((Object)this.lasectrlUnitF7DialogSelected);
            this.lbcOrg.setBoundLabelText(OrgRangeType.MANAGE_ORG_TYPE.getAlias(this.getLocale()));
        }
        if (tabIndex == 1) {
            if (this.accreditF7PromptDialog == null) {
                this.accreditF7PromptDialog = new AccreditF7PromptDialog((IUIObject)this, this.targetUser, false);
                this.pmtOrg.setData(this.accreditF7PromptDialog.getDefaultData());
            }
            this.pmtOrg.setSelector((KDPromptSelector)this.accreditF7PromptDialog);
            this.pmtOrg.setData((Object)this.lastAccreditF7DialogSelected);
            this.lbcOrg.setBoundLabelText(OrgRangeType.BIZ_ORG_TYPE.getAlias(this.getLocale()));
        }
        if (tabIndex == 2) {
            if (this.accreditF7PromptDialog == null) {
                this.accreditF7PromptDialog = new AccreditF7PromptDialog((IUIObject)this, this.targetUser, false);
                this.pmtOrg.setData(this.accreditF7PromptDialog.getDefaultData());
            }
            this.pmtOrg.setSelector((KDPromptSelector)this.accreditF7PromptDialog);
            this.pmtOrg.setData((Object)this.lastAccreditF7DialogSelected);
            this.lbcOrg.setBoundLabelText(OrgRangeType.BIZ_ORG_TYPE.getAlias(this.getLocale()));
        }
        this.buildTargetTree(tabIndex);
    }

    private void loadConfigurationInfo() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        this.configurationInfo = iPermission.getConfigurationInfo();
    }

    private void selectDefOrg() throws EASBizException, BOSException {
        FullOrgUnitInfo defOrgUnit = this.targetUser.getDefOrgUnit();
        if (defOrgUnit != null) {
            this.pmtOrg.setData((Object)defOrgUnit);
        }
    }

    private void setUserInfo() throws EASBizException, BOSException {
        this.targetUser = this.getUserInfo(this.getTargetUserPK());
        this.txtUser.setText(this.targetUser.getNumber() + "(" + this.targetUser.getName() + ")");
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private void initOrgF7() throws EASBizException, BOSException {
        this.accreditF7PromptDialog = new AccreditF7PromptDialog((IUIObject)this, this.targetUser, false);
        this.pmtOrg.setSelector((KDPromptSelector)this.accreditF7PromptDialog);
        this.pmtOrg.setData(this.accreditF7PromptDialog.getDefaultData());
        this.pmtOrg.setEditable(false);
    }

    private void initTrees() throws Exception {
        this.treeHelper = new NewUserAccreditTreeHelper();
        this.initTargetTree();
        this.clearAllTrees();
    }

    private void initTargetTree() {
        this.treeAuthorizedPerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    NewUserPermViewUI.this.buildLevelTargetTree(curNode, 30);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
        this.treeNormalPerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    NewUserPermViewUI.this.buildLevelTargetTree(curNode, 10);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
        this.treeForbiddenPerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    NewUserPermViewUI.this.buildLevelTargetTree(curNode, 20);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    public IUserOrgPermFacade getBizInterface() throws BOSException {
        return UserOrgPermFacadeFactory.getRemoteInstance();
    }

    private FullOrgUnitCollection getOrgCol() throws BOSException {
        FullOrgUnitCollection ret = null;
        ArrayList<BOSUuid> orgList = new ArrayList<BOSUuid>();
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        orgList.add(this.getSelectedOrgInfo().getId());
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(orgList, false), CompareType.INCLUDE));
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("isUnion"));
        selectorCol.add(new SelectorItemInfo("orgtypestr"));
        entityViewInfo.setSelector(selectorCol);
        entityViewInfo.setFilter(filterInfo);
        ret = iFullOrgUnit.getFullOrgUnitCollection(entityViewInfo);
        return ret;
    }

    private void buildLevelTargetTree(KDTreeNode parent, int permType) throws Exception {
        if (parent == null || this.treeHelper.isLeaf(parent) || this.treeHelper.isExpended(parent)) {
            return;
        }
        IUserOrgPermFacade iuopFacade = this.getBizInterface();
        IObjectPK targetUserPK = this.getTargetUserPK();
        PermItemInfo parentPerm = this.treeHelper.getPermItem(parent);
        UserOrgPermCollection userOrgPerms = null;
        boolean sourceFlag = false;
        userOrgPerms = iuopFacade.getLevelViewUOPs(targetUserPK, this.getOrgCol(), parentPerm, permType);
        this.treeHelper.buildLevelTargetTree(parent, (IObjectCollection)userOrgPerms, permType, sourceFlag);
    }

    private void clearAllTrees() {
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot(null);
    }

    private void initTab() throws EASBizException, BOSException {
        if (!this.targetUser.isBizAdmin()) {
            this.tabAssign.setEnabledAt(0, false);
        }
        this.tabAssign.setSelectedIndex(1);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.showRulePanel(this.isShowRule);
    }

    private void showRulePanel(boolean isVisible) {
        this.rulePanel.setVisible(isVisible);
        IUIWindow win = this.getUIWindow();
        if (isVisible) {
            this.remove((Component)this.tabAssign);
            this.add((Component)this.tabAssign, new KDLayout.Constraints(10, 32, 610, 320, 325));
            if (win instanceof UIModelDialog) {
                ((UIModelDialog)win).setSize(636, 600);
            } else if (win instanceof Frame) {
                ((Frame)win).setSize(636, 600);
                this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 630, 500));
                this.add((Component)((Object)this.rulePanel), new KDLayout.Constraints(0, 345, 630, 170, 294));
                ((Frame)win).repaint();
                ((Frame)win).validate();
            }
        } else {
            this.remove((Component)this.tabAssign);
            this.add((Component)this.tabAssign, new KDLayout.Constraints(10, 32, 610, 480, 325));
            if (win instanceof UIModelDialog) {
                ((UIModelDialog)win).setSize(636, 452);
            } else if (win instanceof Frame) {
                ((Frame)win).setSize(636, 452);
            }
        }
    }

    private void buildAllTrees(int selectIndex) throws Exception {
        this.clearAllTrees();
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        this.buildTargetTree(selectIndex);
        float endTime = lowTimer.msValue();
        logger.debug((Object)("buildTargetTree()  " + (endTime - beginTime)));
    }

    private void buildTargetTree(int tabIndex) throws Exception {
        final IObjectPK targetUserPK = this.getTargetUserPK();
        if (!this.hasShowAuthorization && tabIndex == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        IUserOrgPermFacade iuopFacade = NewUserPermViewUI.this.getBizInterface();
                        FullOrgUnitCollection orgCol = NewUserPermViewUI.this.getOrgCol();
                        UserOrgPermCollection a_userOrgPerms = iuopFacade.getTopViewUOPs(targetUserPK, orgCol, 30);
                        NewUserPermViewUI.this.treeHelper.buildTopTargetTree(NewUserPermViewUI.this.treeAuthorizedPerm, (IObjectCollection)a_userOrgPerms);
                        NewUserPermViewUI.this.hasShowAuthorization = true;
                    }
                    catch (Exception e) {
                        NewUserPermViewUI.this.handUIException(e);
                    }
                }
            });
        }
        if (!this.hasShowNormal && tabIndex == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        IUserOrgPermFacade iuopFacade = NewUserPermViewUI.this.getBizInterface();
                        FullOrgUnitCollection orgCol = NewUserPermViewUI.this.getOrgCol();
                        UserOrgPermCollection n_userOrgPerms = iuopFacade.getTopViewUOPs(targetUserPK, orgCol, 10);
                        NewUserPermViewUI.this.treeHelper.buildTopTargetTree(NewUserPermViewUI.this.treeNormalPerm, (IObjectCollection)n_userOrgPerms);
                        NewUserPermViewUI.this.hasShowNormal = true;
                    }
                    catch (Exception e) {
                        NewUserPermViewUI.this.handUIException(e);
                    }
                }
            });
        }
        if (!this.hasShowForbidden && tabIndex == 2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        IUserOrgPermFacade iuopFacade = NewUserPermViewUI.this.getBizInterface();
                        FullOrgUnitCollection orgCol = NewUserPermViewUI.this.getOrgCol();
                        UserOrgPermCollection f_userOrgPerms = iuopFacade.getTopViewUOPs(targetUserPK, orgCol, 20);
                        NewUserPermViewUI.this.treeHelper.buildTopTargetTree(NewUserPermViewUI.this.treeForbiddenPerm, (IObjectCollection)f_userOrgPerms);
                        NewUserPermViewUI.this.hasShowForbidden = true;
                    }
                    catch (Exception e) {
                        NewUserPermViewUI.this.handUIException(e);
                    }
                }
            });
        }
    }

    @Override
    protected void pmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtOrg_dataChanged(e);
        FullOrgUnitInfo org = this.getSelectedOrgInfo();
        if (org != null && org.getCU() != null) {
            this.rulePanel.setCtrlUnitPK((IObjectPK)new ObjectUuidPK(org.getCU().getId()));
            this.hasShowAuthorization = false;
            this.hasShowNormal = false;
            this.hasShowForbidden = false;
            this.buildAllTrees(this.tabAssign.getSelectedIndex());
        } else {
            this.clearAllTrees();
        }
        this.btnFieldAccessAccredit.setVisible(org != null);
        if (this.tabAssign.getSelectedComponent().equals(this.tviewAuthorizedPerm)) {
            this.lasectrlUnitF7DialogSelected = org;
        } else {
            this.lastAccreditF7DialogSelected = org;
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnShowRule.setIcon(EASResource.getIcon((String)"imgTbtn_dataaccredit"));
        this.btnHideRule.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.btnDiscretePerm.setIcon(EASResource.getIcon((String)"imgTbtn_scatterpurview"));
        this.btnFieldAccessAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_fieldpurview"));
    }

    private FullOrgUnitInfo getSelectedOrgInfo() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        if (this.pmtOrg.getData() instanceof FullOrgUnitInfo) {
            return (FullOrgUnitInfo)this.pmtOrg.getData();
        }
        return null;
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return new ObjectUuidPK(this.getSelectedOrgInfo().getId());
    }

    private IObjectPK getTargetUserPK() {
        Object object = this.getUIContext().get("targetID");
        if (object == null) {
            return new ObjectUuidPK(this.getCurrentUser().getId());
        }
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private UserInfo getUserInfo(IObjectPK userPK) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bizAdmin"));
        sic.add(new SelectorItemInfo("defOrgUnit.id"));
        sic.add(new SelectorItemInfo("defOrgUnit.number"));
        sic.add(new SelectorItemInfo("defOrgUnit.name"));
        sic.add(new SelectorItemInfo("defOrgUnit.CU.id"));
        IUser iUser = UserFactory.getRemoteInstance();
        return iUser.getUserInfo(userPK, sic);
    }

    @Override
    public void actionHideRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionHideRule_actionPerformed(e);
        this.isShowRule = false;
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
    }

    @Override
    public void actionShowRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowRule_actionPerformed(e);
        this.isShowRule = true;
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
    }

    @Override
    protected void treeNormalPerm_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeNormalPerm_valueChanged(e);
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            this.loadRule((KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent());
        }
        this.setDiscreteButtonStatus(e);
    }

    private void setDiscreteButtonStatus(TreeSelectionEvent e) {
        BOSObjectType objectType;
        KDTreeNode node;
        Object old;
        if (e.getNewLeadSelectionPath() != null && (old = e.getNewLeadSelectionPath().getLastPathComponent()) != null && this.enableDataPermission(node = (KDTreeNode)old) && (objectType = this.getRuleObjectType(node)) != null) {
            this.btnDiscretePerm.setVisible(this.configurationInfo.getDiscretEntityTables().containsKey(objectType.toString()));
            return;
        }
        this.btnDiscretePerm.setVisible(false);
    }

    private boolean enableDataPermission(KDTreeNode node) {
        if (node.isLeaf()) {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType) && info.getPermItem().isEnableDataPermission()) {
                return true;
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (UserOrgPermInfo)child.getUserObject()).getPermItem().getObjectType())) || !info.getPermItem().isEnableDataPermission()) continue;
                return true;
            }
        }
        return false;
    }

    private BOSObjectType getRuleObjectType(KDTreeNode node) {
        if (node.isLeaf()) {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType)) {
                return BOSObjectType.create((String)objectType);
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (UserOrgPermInfo)child.getUserObject()).getPermItem().getObjectType()))) continue;
                return BOSObjectType.create((String)objectType);
            }
        }
        return null;
    }

    private void loadRule(KDTreeNode node) throws EASBizException, ParserException, BOSException {
        if (node == null) {
            this.rulePanel.reset();
        } else {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            if (info.getPermItem().isIsLeaf() && !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                this.rulePanel.setBizObjectType(BOSObjectType.create((String)info.getPermItem().getObjectType()));
                String ruleStructure = info.getRuleStructure();
                this.rulePanel.setRuleStructure(ruleStructure);
                this.rulePanel.refresh();
            } else {
                this.rulePanel.reset();
            }
        }
    }

    @Override
    public void actionDiscretePerm_actionPerformed(ActionEvent e) throws Exception {
        BOSObjectType objectType;
        super.actionDiscretePerm_actionPerformed(e);
        Object obj = this.treeNormalPerm.getLastSelectedPathComponent();
        if (obj != null && (objectType = this.getRuleObjectType((KDTreeNode)obj)) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"bosObjectType", (Object)objectType);
            uiContext.put((Object)"targetUserPK", (Object)this.getTargetUserPK());
            uiContext.put((Object)"targetOrgPK", (Object)this.getSelectedOrgPK());
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserDiscretePermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
    }

    @Override
    public boolean isPrepareActionFieldAccessAccredit() {
        return true;
    }

    @Override
    public RequestContext prepareActionFieldAccessAccredit(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    @Override
    public void actionFieldAccessAccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionFieldAccessAccredit_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"userPK", (Object)this.getTargetUserPK());
        uiContext.put((Object)"orgPK", (Object)this.getSelectedOrgPK());
        uiContext.put((Object)"targetUserInfo", (Object)this.getTargetUser());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserFieldAccessViewUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    public UserInfo getTargetUser() {
        return this.targetUser;
    }
}

