/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDInfoTip;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.LoginAndLogout;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractOnlineSubscribeCloudActiveUI;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class OnlineSubscribeCloudActiveUI
extends AbstractOnlineSubscribeCloudActiveUI {
    private static final Logger logger = CoreUIObject.getLogger(OnlineSubscribeCloudActiveUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String CLOUDPHONE = "1069013339145";
    private String email;
    private String wholePhone;
    private String mixPhone;
    private String uid;
    private String prod_inst_code;
    private Integer reGetTime;
    private boolean isOnLine;
    private boolean completed;
    private KDInfoTip pdTip;

    public void onLoad() throws Exception {
        String text;
        block6: {
            this.setAPIParam();
            text = null;
            this.setBounds(new Rectangle(11, 120, 540, 250));
            this.pwdTip.setBounds(new Rectangle(296, 82, 230, 48));
            this.pwdTip.setFont(new Font("Serif", 0, 12));
            if (!"".equals(this.email)) {
                try {
                    this.getActiveCodeFromCloud();
                    this.isOnLine = true;
                    this.startTimer();
                    text = EASResource.getString((String)RESOURCE, (String)"emailMessage_online", (Object[])new Object[]{this.email});
                }
                catch (Exception e) {
                    this.btnReGetCode.setEnabled(false);
                    this.btnUpdatepwd.setEnabled(false);
                    text = e.getMessage();
                }
            } else {
                try {
                    this.getActiveCodeFromCloud();
                    this.isOnLine = true;
                    this.startTimer();
                    text = EASResource.getString((String)RESOURCE, (String)"editMessage_online", (Object[])new Object[]{this.mixPhone});
                }
                catch (Exception e) {
                    this.btnReGetCode.setEnabled(false);
                    this.btnUpdatepwd.setEnabled(false);
                    text = e.getMessage();
                    if (!(e instanceof IOException)) break block6;
                    throw e;
                }
            }
        }
        this.txtverifyTip.setBorder(BorderFactory.createEmptyBorder());
        this.txtverifyTip.setText(text);
        this.txtPwd.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    OnlineSubscribeCloudActiveUI.this.pwdPassword_focusLost(e);
                }
                catch (Exception exc) {
                    OnlineSubscribeCloudActiveUI.this.handUIException(exc);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    OnlineSubscribeCloudActiveUI.this.pwdPassword_focusGained(e);
                }
                catch (Exception exc) {
                    OnlineSubscribeCloudActiveUI.this.handUIException(exc);
                }
            }
        });
    }

    private void setAPIParam() throws LicenseException {
        SysContext ctx = SysContext.getSysContext();
        CloudRegistUserInfo crui = CloudRegistSrvAgentFactory.getRemoteInstance().getCloudRegistUserInfo(ctx.getUserName());
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
        this.uid = crui.getCloudUuId();
        String phoneReg = crui.getPhone();
        String emailReg = crui.getEmail();
        if (!StringUtils.isEmpty((String)phoneReg) && phoneReg.contains("@")) {
            this.email = phoneReg;
            this.wholePhone = "";
            this.mixPhone = "";
        } else if (!StringUtils.isEmpty((String)emailReg)) {
            this.email = emailReg;
            if (StringUtils.isEmpty((String)phoneReg)) {
                this.wholePhone = "";
                this.mixPhone = "";
            } else {
                this.wholePhone = phoneReg;
                this.mixPhone = CloudRegistSrvAgentFactory.getRemoteInstance().getErpTelephone(ctx.getUserName());
            }
        } else {
            this.email = "";
            this.wholePhone = phoneReg;
            this.mixPhone = CloudRegistSrvAgentFactory.getRemoteInstance().getErpTelephone(ctx.getUserName());
        }
        this.prod_inst_code = baseInfo.getProductInstanceID();
    }

    private boolean getActiveCodeFromCloud() throws Exception {
        String result = UserFacadeFactory.getRemoteInstance().getActiveCode(this.uid, this.prod_inst_code, this.wholePhone, this.email, "2");
        if (StringUtils.isEmpty((String)result)) {
            throw new BOSException("\u83b7\u53d6\u77ed\u4fe1\u5931\u8d25!");
        }
        JSONObject o = JSON.parseObject((String)result);
        if (o.getInteger("errcode") == 0) {
            this.reGetTime = JSONObject.parseObject((String)o.getString("data")).getInteger("resend_in");
            this.logSendCode();
            return true;
        }
        String descKey = null;
        Locale locale = SysContext.getSysContext().getLocale();
        if ("l1".equalsIgnoreCase(locale.toString())) {
            descKey = EasCloud.DESCRIPTION;
            if (o.getString(descKey) == null) {
                descKey = EasCloud.DESCRIPTION_CN;
            }
        } else {
            descKey = EasCloud.DESCRIPTION_CN;
        }
        throw new BOSException(o.getString(descKey));
    }

    private void logSendCode() {
        try {
            SysContext ctx = SysContext.getSysContext();
            String description = ResourceBase.getString((String)RESOURCE, (String)"log_sendCode", (Locale)ctx.getLocale());
            IObjectPK logPK = LogUtil.beginLog(null, (String)description, (BOSObjectType)new LoginAndLogout().getType(), null, (String)description, (String)"UserLoginLog");
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void btnReGetCode_actionPerformed(ActionEvent e) throws Exception {
        this.getActiveCodeFromCloud();
    }

    private void startTimer() {
        if (!this.isOnLine) {
            this.btnReGetCode.setVisible(false);
            return;
        }
        this.btnReGetCode.setVisible(true);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        if (OnlineSubscribeCloudActiveUI.this.reGetTime == 0) {
                            OnlineSubscribeCloudActiveUI.this.btnReGetCode.setText(EASResource.getString((String)OnlineSubscribeCloudActiveUI.RESOURCE, (String)"reGet"));
                            OnlineSubscribeCloudActiveUI.this.btnReGetCode.setEnabled(true);
                            continue;
                        }
                        Integer n = OnlineSubscribeCloudActiveUI.this.reGetTime;
                        Integer n2 = OnlineSubscribeCloudActiveUI.this.reGetTime = OnlineSubscribeCloudActiveUI.this.reGetTime - 1;
                        OnlineSubscribeCloudActiveUI.this.btnReGetCode.setText(EASResource.getString((String)OnlineSubscribeCloudActiveUI.RESOURCE, (String)"reGetCodeTime", (Object[])new Object[]{OnlineSubscribeCloudActiveUI.this.reGetTime}));
                        OnlineSubscribeCloudActiveUI.this.btnReGetCode.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return;
                }
            }
        });
        thread.start();
    }

    @Override
    protected void btnUpdatepwd_actionPerformed(ActionEvent e) throws Exception {
        String pwd = this.txtPwd.getText().trim();
        String confirmPwd = this.txtConfirmPwd.getText().trim();
        String vcode = this.txtCode.getText();
        if (StringUtils.isEmpty((String)vcode)) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"VCODE_CANNOT_NULL"));
            return;
        }
        if (pwd == null || pwd.isEmpty() || pwd.length() < 8) {
            String format = EASResource.getString((String)RESOURCE, (String)"pwdLength");
            MsgBox.showInfo((String)(format + "8"));
            this.txtPwd.setText("");
            this.txtConfirmPwd.setText("");
            return;
        }
        boolean hasDigit = false;
        boolean hasLetter = false;
        for (int i = 0; i < pwd.length(); ++i) {
            if (Character.isDigit(pwd.charAt(i))) {
                hasDigit = true;
            } else if (Character.isLetter(pwd.charAt(i))) {
                hasLetter = true;
            }
            if (hasDigit && hasLetter) break;
        }
        if (!hasDigit || !hasLetter) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"pwdComplex"));
            this.txtPwd.setText("");
            this.txtConfirmPwd.setText("");
            return;
        }
        if (!StringUtils.equals((String)pwd, (String)confirmPwd)) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"pwdNotSame"));
            this.txtPwd.setText("");
            this.txtConfirmPwd.setText("");
            return;
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        UserFacadeFactory.getRemoteInstance().resetErpAndCloudPass(userInfo.getId().toString(), pwd, this.txtCode.getText());
        HashMap<String, String> ctxMap = new HashMap<String, String>();
        ctxMap.put("cloudUserId", this.uid);
        ContextManagerFactory.getRemoteInstance().setContext(ctxMap);
        this.completed = true;
        this.uiWindow.close();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    private void pwdPassword_focusLost(FocusEvent e) {
        if (this.pdTip != null) {
            this.pdTip.setShowing(false);
        }
    }

    private void pwdPassword_focusGained(FocusEvent e) {
        if (this.pdTip != null && !StringUtils.isEmpty((String)this.pdTip.getTipText())) {
            this.pdTip.setShowing(true);
            return;
        }
        try {
            IUser iUser = UserFactory.getRemoteInstance();
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("security.*"));
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userId), sc);
            SecurityValidator securityValidator = new SecurityValidator(null, userInfo);
            StringBuilder securityPolicy = new StringBuilder();
            securityPolicy.append(EASResource.getString((String)RESOURCE, (String)"kingdee_cloud_securityPolicy_title")).append("\n  ").append(EASResource.getString((String)RESOURCE, (String)"kingdee_cloud_securityPolicy")).append("\n").append(EASResource.getString((String)RESOURCE, (String)"eas_cloud_securityPolicy_title")).append("\n  ");
            String easSecurityPolicy = securityValidator.getSecurityPolicy();
            if (StringUtils.isEmpty((String)easSecurityPolicy)) {
                securityPolicy.append(EASResource.getString((String)RESOURCE, (String)"eas_cloud_securityPolicy"));
            } else {
                securityPolicy.append(easSecurityPolicy);
            }
            this.pdTip = new KDInfoTip((JComponent)this.txtPwd, securityPolicy.toString());
            this.pdTip.setMaxRenderWidth(250.0f);
            this.pdTip.setShowing(true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

