/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.DynamicCardUserFactory;
import com.kingdee.eas.base.permission.IDynamicCardUser;
import com.kingdee.eas.base.permission.IPasswordVerifyFacade;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.PasswordVerifyFacadeFactory;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractPasswordAuthorizeInputUI;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PasswordAuthorizeInputUI
extends AbstractPasswordAuthorizeInputUI {
    private static final Logger logger = CoreUIObject.getLogger(PasswordAuthorizeInputUI.class);
    private boolean isLoginSuccessful = false;
    public static final String ID = "ID";
    public static final String NUMBER = "NUMBER";
    public static final String AuthorizeType = "AuthorizeType";
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    public void init() throws Exception {
        if (this.getAuthorizeType() != null && AuthorizeTypeEnum.pwdAuthor.equals((Object)this.getAuthorizeType())) {
            this.setUITitle(EASResource.getString((String)RESOURCE, (String)"INPUT_PASSWORD"));
        } else {
            this.setUITitle(EASResource.getString((String)RESOURCE, (String)"INPUT_DYNPASSWORD"));
        }
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.tPassword, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
    }

    private AuthorizeTypeEnum getAuthorizeType() {
        return (AuthorizeTypeEnum)((Object)this.getUIContext().get(AuthorizeType));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        String password = "";
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (this.tPassword.getPassword() != null) {
            password = new String(this.tPassword.getPassword());
        }
        String checkedUserName = null;
        String innerPassword = null;
        String checkPassword = null;
        AuthorizeTypeEnum authorizeType = this.getAuthorizeType();
        LoginAuthorWayEnum loginWay = null;
        if (authorizeType == null) {
            authorizeType = AuthorizeTypeEnum.dynAuth;
            loginWay = LoginAuthorWayEnum.DYNAMIC;
        }
        if (AuthorizeTypeEnum.dynAuth.equals((Object)authorizeType)) {
            if (!this.isDyPasswordUser(user.getId().toString())) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"USER_NOT_CONFIG_DYN_PWD"));
            }
            String numberType = PermissionCommonUtil.getDynamicCardUserNumberType(null);
            if (StringUtils.isEmpty((String)numberType)) {
                numberType = "1";
            }
            checkedUserName = "2".equals(numberType) ? user.getNumber() : user.getId().toString();
            checkPassword = innerPassword = LoginHelper.encodePassword((String)checkedUserName, (String)password);
            loginWay = LoginAuthorWayEnum.DYNAMIC;
        } else if (AuthorizeTypeEnum.pwdAuthor.equals((Object)authorizeType)) {
            checkedUserName = user.getNumber();
            checkPassword = StringUtils.isEmpty((String)password) ? null : PermissionUtils.encrypt(user.getId().toString(), password);
            innerPassword = LoginHelper.encodePassword((String)checkedUserName, (String)password);
            loginWay = LoginAuthorWayEnum.NORMAL;
        }
        try {
            boolean result;
            IPasswordVerifyFacade pvf = PasswordVerifyFacadeFactory.getRemoteInstance();
            this.isLoginSuccessful = result = pvf.verifyUserAndPassword(loginWay, checkedUserName, innerPassword);
            if (!result) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"INPUT_PASSWORD_ERROR"));
            }
            this.destroyWindow();
        }
        catch (Exception e1) {
            MsgBox.showInfo((Component)((Object)this), (String)e1.getMessage());
            logger.error((Object)"ReloginAction", (Throwable)e1);
        }
    }

    public boolean isLoginSuccessful() {
        return this.isLoginSuccessful;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    public boolean useCustomizedPlatform() {
        return false;
    }

    private boolean isDyPasswordUser(String user) {
        try {
            IDynamicCardUser service = DynamicCardUserFactory.getRemoteInstance();
            return service.exists("where dynamicState = 0 and user ='" + user + "'");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return false;
    }
}

