/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermItemDeleteStrategyEnum;
import com.kingdee.eas.base.permission.PermItemMaintainCollection;
import com.kingdee.eas.base.permission.PermItemMaintainFactory;
import com.kingdee.eas.base.permission.PermItemMaintainInfo;
import com.kingdee.eas.base.permission.client.AbstractPermItemMaintainUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class PermItemMaintainUI
extends AbstractPermItemMaintainUI {
    private static final Logger logger = CoreUIObject.getLogger(PermItemMaintainUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void onShow() throws Exception {
        this.initUI();
        super.onShow();
        this.loadData2Table();
    }

    private void initUI() {
        this.actionAdd.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionDel.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionRefresh.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_refresh"));
        this.actionSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void loadData2Table() {
        this.mainTable.removeRows();
        try {
            PermItemMaintainCollection col = PermItemMaintainFactory.getRemoteInstance().getPermItemMaintainCollection();
            int size = col.size();
            for (int index = 0; index < size; ++index) {
                IRow row = this.mainTable.addRow();
                PermItemMaintainInfo permItemMaintainInfo = col.get(index);
                row.getCell("id").setValue((Object)permItemMaintainInfo.getId());
                row.getCell("tableName").setValue((Object)permItemMaintainInfo.getTableName());
                row.getCell("fieldName").setValue((Object)permItemMaintainInfo.getFieldName());
                row.getCell("number").setValue((Object)permItemMaintainInfo.getNumber());
                row.getCell("strategy").setValue((Object)permItemMaintainInfo.getDeleteStrategy());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void setStrategyEditor(IRow row) {
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)new KDComboBox(PermItemDeleteStrategyEnum.getEnumList().toArray()));
        row.getCell("strategy").setEditor((ICellEditor)editor);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.mainTable.addRow();
        this.setStrategyEditor(row);
    }

    @Override
    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        KDTRange range = this.mainTable.getSelectManager().toRange().getSequenceRange();
        if (range == null) {
            return;
        }
        int size = range.size();
        for (int index = 0; index < size; ++index) {
            KDTBlock block = (KDTBlock)range.get(index);
            int bottom = block.getBottom();
            for (int top = block.getTop(); top <= bottom; ++top) {
                this.mainTable.removeRow(top);
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.loadData2Table();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.save();
        this.loadData2Table();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveSucceed"));
    }

    private void save() {
        PermItemMaintainCollection cols = new PermItemMaintainCollection();
        int count = this.mainTable.getRowCount();
        for (int index = 0; index < count; ++index) {
            String tableName = (String)this.mainTable.getRow(index).getCell("tableName").getValue();
            String fieldName = (String)this.mainTable.getRow(index).getCell("fieldName").getValue();
            String number = (String)this.mainTable.getRow(index).getCell("number").getValue();
            PermItemDeleteStrategyEnum strategy = (PermItemDeleteStrategyEnum)((Object)this.mainTable.getRow(index).getCell("strategy").getValue());
            if (StringUtils.isEmpty((String)tableName) || !tableName.startsWith("T_") && !tableName.startsWith("t_") || StringUtils.isEmpty((String)fieldName) || !fieldName.startsWith("f") && !fieldName.startsWith("F")) continue;
            PermItemMaintainInfo pmInfo = new PermItemMaintainInfo();
            pmInfo.setTableName(tableName);
            pmInfo.setFieldName(fieldName);
            pmInfo.setNumber(number);
            if (strategy == null) {
                strategy = PermItemDeleteStrategyEnum.deleteRow;
            }
            pmInfo.setDeleteStrategy(strategy);
            cols.add(pmInfo);
        }
        try {
            PermItemMaintainFactory.getRemoteInstance().saveResult(cols);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

