/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.client.AbstractPermissionCopyUI;
import com.kingdee.eas.base.permission.client.f7.AccreditF7PromptDialog;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class PermissionCopyUI
extends AbstractPermissionCopyUI {
    private static final Logger logger = CoreUIObject.getLogger(PermissionCopyUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
    private Set orgSet = new HashSet();
    private final String ORG_NUMBER_CELLNAME = "orgNumber";
    private final String ORG_NAME_CELLNAME = "orgName";

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOrgSelect.setEnabled(false);
        this.srcOrgF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (PermissionCopyUI.this.srcOrgF7.getData() == null) {
                    PermissionCopyUI.this.btnOrgSelect.setEnabled(false);
                    PermissionCopyUI.this.mainTable.removeRows();
                } else {
                    PermissionCopyUI.this.btnOrgSelect.setEnabled(true);
                }
            }
        });
    }

    public void onShow() throws Exception {
        this.initOrgF7();
        super.onShow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void initOrgF7() throws EASBizException, BOSException {
        AccreditF7PromptDialog accreditF7PromptDialog = new AccreditF7PromptDialog((IUIObject)this, this.getTargetUser(), false);
        this.srcOrgF7.setSelector((KDPromptSelector)accreditF7PromptDialog);
        this.srcOrgF7.setEditable(false);
    }

    private IObjectPK getTargetUserPK() {
        String userID = (String)this.getUIContext().get("userID");
        if (StringUtils.isEmpty((String)userID)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        return new ObjectUuidPK(userID);
    }

    private UserInfo getTargetUser() throws EASBizException, BOSException {
        IObjectPK targetUserPK = this.getTargetUserPK();
        return UserFactory.getRemoteInstance().getUserByID(targetUserPK);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        String srcOrgID = null;
        if (this.srcOrgF7.getData() != null) {
            srcOrgID = ((FullOrgUnitInfo)this.srcOrgF7.getData()).getId().toString();
        }
        if (StringUtils.isEmpty(srcOrgID) || this.orgSet.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"orgNotSelect"));
            return;
        }
        String userNumber = UserFactory.getRemoteInstance().getUserInfo(this.getTargetUserPK()).getNumber();
        PermissionHelper.alertNeedAuthen((Component)((Object)this), userNumber);
        UserOrgPermFactory.getRemoteInstance().copyPermission(this.getTargetUserPK().toString(), srcOrgID, ToolUtils.trans2List(this.orgSet));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"infoPermissionCopySuccessful"));
    }

    @Override
    protected void btnOrgSelect_actionPerformed(ActionEvent e) throws Exception {
        AccreditF7PromptDialog accreditF7PromptDialog = new AccreditF7PromptDialog((IUIObject)this, this.getTargetUser(), true){

            @Override
            public void postProcessExtraFilters(StringBuffer extraFilters) {
                if (PermissionCopyUI.this.srcOrgF7.getData() != null) {
                    extraFilters.append(" AND baseunit.fid <> '").append(((FullOrgUnitInfo)PermissionCopyUI.this.srcOrgF7.getData()).getId().toString()).append("'");
                }
            }
        };
        if (this.orgSet.size() > 0) {
            accreditF7PromptDialog.setSelectedOrgIds(this.orgSet);
        }
        accreditF7PromptDialog.show();
        OrgUnitInfo[] orgs = (OrgUnitInfo[])accreditF7PromptDialog.getData();
        if (orgs == null) {
            return;
        }
        this.mainTable.removeRows();
        this.orgSet.clear();
        int size = orgs.length;
        for (int index = 0; index < size; ++index) {
            IRow row = this.mainTable.addRow();
            row.getCell("orgNumber").setValue((Object)orgs[index].getNumber());
            row.getCell("orgName").setValue((Object)orgs[index].getName());
            row.getStyleAttributes().setLocked(true);
            this.orgSet.add(orgs[index].getId().toString());
        }
    }
}

