/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgRoPerm;
import com.kingdee.eas.base.permission.UserRoleOrgCollection;
import com.kingdee.eas.base.permission.UserRoleOrgInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.client.AbstractRoleAssignUserUI;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.helper.RoleHelper;
import com.kingdee.eas.base.permission.client.helper.UserRoleAssignHelper;
import com.kingdee.eas.base.permission.client.util.InheritFatherUserRoleUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.LogNamesHelper;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.MyEntityInfo;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.BizOrgRangeF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RoleAssignUserUI
extends AbstractRoleAssignUserUI {
    private Logger logger = Logger.getLogger((String)RoleAssignUserUI.class.getName());
    private RoleInfo currentEditRole;
    private String curSelectOrgId = null;
    private String curSelectOrgNumber = null;
    private static final String permissionResource = "com.kingdee.eas.base.permission.PermissionResource";

    public RoleAssignUserUI() throws Exception {
        this.initUI();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("CurrentUserPK", (Object)ToolUtils.getCurrentUserPK());
            String roleId = (String)this.getUIContext().get("targetID");
            request.put("ROLEID", (Object)roleId);
            request.put("isBizAdmin", (Object)String.valueOf(this.isBizAdmin()));
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    private void initUI() throws Exception {
        this.menuItemView.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setColumFormat();
        this.setRoleInfoFromContext();
        this.initRoleF7();
        this.logger.info((Object)("query info:" + this.mainQuery.getFilter()));
    }

    private void setColumFormat() {
        this.tblMain.getColumn("effectiveDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        this.tblMain.getColumn("invalidationDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnCancelAssign.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
        this.btnQueryAllOrg.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.menuEdit.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
    }

    private void initOrgF7() throws EASBizException, BOSException {
        BizOrgRangeF7PromptDialog orgF7 = null;
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        orgF7 = new BizOrgRangeF7PromptDialog((IUIObject)this, userInfo);
        orgF7.setMultiSelect(false);
        orgF7.setIsCUFilter(true, true);
        StringBuffer selectedOrgSQL = new StringBuffer();
        selectedOrgSQL.append("select forgid from t_pm_orgrangeincludesuborg where fuserid = '").append(userInfo.getId().toString()).append("' and ftype = ").append(10);
        orgF7.setSelectedOrgIdSQL(selectedOrgSQL.toString());
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        this.pmtOrg.setEditable(false);
    }

    private void initRoleF7() throws EASBizException, BOSException {
        if (this.txtRole == null) {
            this.txtRole = new KDBizPromptBox();
        }
        this.txtRole.setQueryInfo("com.kingdee.eas.base.permission.app.RoleQuery");
        this.txtRole.setEditFormat("$name$");
        this.txtRole.setCommitFormat("$name$");
        this.txtRole.setDisplayFormat("$name$");
        this.txtRole.setEditable(false);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = null;
        if (this.isBizAdmin()) {
            filterInfo = UserRoleAssignHelper.getRoleFilter4BizAdmin();
        } else {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id in (" + RoleHelper.getCUOrgRangeSQL() + ")"));
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filterInfo.setMaskString("#0 or #1");
        }
        entityViewInfo.setFilter(filterInfo);
        this.txtRole.setEntityViewInfo(entityViewInfo);
    }

    private boolean isBizAdmin() {
        return ToolUtils.getCurrentUser().isBizAdmin() && !Administrator.isSuperCUAdmin(ToolUtils.getCurrentUserPK());
    }

    private void setMainQueryFilter(String roleId, String orgId) throws EASBizException, BOSException, Exception {
        FilterInfo filterInfo = new FilterInfo();
        if (!StringUtils.isEmpty((String)roleId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("roleId", (Object)roleId));
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgId", (Object)orgId, CompareType.INCLUDE));
        } else if (this.isBizAdmin()) {
            if (this.getCurrentUser().getId().equals((Object)this.currentEditRole.getCreator().getId())) {
                filterInfo.getFilterItems().add(new FilterItemInfo("orgId.cu.id in (" + RoleHelper.getManageOrgRangeSQL() + ")"));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("orgId in (" + PermissionRangeHelper.getOrgListSQL(ToolUtils.getCurrentUserPK(), this.currentEditRole.getId().toString()) + ")"));
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgId in (" + RoleHelper.getManageOrgRangeSQL() + ")"));
        }
        if (this.isBizAdmin()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("userId", (Object)ToolUtils.getCurrentUserPK().toString(), CompareType.NOTEQUALS));
        }
        if (this.mainQuery != null) {
            this.mainQuery.setFilter(filterInfo);
        }
    }

    private String getAuthorizedOrgs() {
        String orgList = null;
        try {
            orgList = ToolUtils.aryToStr(UserRoleOrgManagerFactory.getRemoteInstance().getOrgList(ToolUtils.getCurrentUserPK(), this.currentEditRole.getId().toString()), false);
        }
        catch (EASBizException e) {
            this.logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            this.logger.error((Object)"", (Throwable)e);
        }
        return orgList;
    }

    private String getSelectedOrgPK() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return this.getSelectedOrgInfo().getId().toString();
    }

    private FullOrgUnitInfo getSelectedOrgInfo() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        return (FullOrgUnitInfo)this.pmtOrg.getData();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        RoleInfo role = this.getCurrentRoleInfo();
        if (role != null) {
            filter.getFilterItems().add(new FilterItemInfo("roleId", (Object)role.getId(), CompareType.EQUALS));
        }
        return filter;
    }

    private void setRoleInfoFromContext() {
        String roleId = (String)this.getUIContext().get("targetID");
        String roleName = (String)this.getUIContext().get("name");
        String roleNumber = (String)this.getUIContext().get("number");
        String creatorID = (String)this.getUIContext().get("creatorID");
        if (this.currentEditRole == null) {
            this.currentEditRole = new RoleInfo();
        }
        if (!StringUtils.isEmpty((String)roleId)) {
            this.currentEditRole.setId(BOSUuid.read((String)roleId));
        }
        if (!StringUtils.isEmpty((String)roleName)) {
            this.currentEditRole.setName(roleName);
        }
        if (!StringUtils.isEmpty((String)roleNumber)) {
            this.currentEditRole.setNumber(roleNumber);
        }
        if (!StringUtils.isEmpty((String)creatorID)) {
            UserInfo usInfo = new UserInfo();
            usInfo.setId(BOSUuid.read((String)creatorID));
            this.currentEditRole.setCreator(usInfo);
        }
        this.txtRole.setData((Object)this.currentEditRole);
    }

    @Override
    public boolean isPrepareActionCancelAssign() {
        return false;
    }

    @Override
    public RequestContext prepareActionCancelAssign(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    @Override
    public void actionCancelAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelAssign_actionPerformed(e);
        this.checkSelected();
        UserRoleOrgCollection userRoleOrgs = this.getSelectedUserRoleOrgCol();
        IUserRoleOrgManager iUserRoleManager = UserRoleOrgManagerFactory.getRemoteInstance();
        iUserRoleManager.disAssignRole2Users(userRoleOrgs);
        this.deleteUserSubOrgRole(null);
        this.refresh(e);
    }

    private void deleteUserSubOrgRole(String permChangeId) {
        if (!InheritFatherUserRoleUtil.needInheritParentUserAndRole()) {
            return;
        }
        HashMap userOrgsMap = new HashMap();
        UserRoleOrgCollection userRoleOrgCol = this.getSelectedUserRoleOrgCol();
        for (int i = 0; i < userRoleOrgCol.size(); ++i) {
            UserRoleOrgInfo info = userRoleOrgCol.get(i);
            String userId = info.getUser().getId().toString();
            String orgId = info.getOrg().getId().toString();
            Collection<String> orgCol = new HashSet<String>();
            if (userOrgsMap.containsKey(userId)) {
                orgCol = (Collection)userOrgsMap.get(userId);
            }
            orgCol.add(orgId);
            userOrgsMap.put(userId, orgCol);
        }
        try {
            InheritFatherUserRoleUtil.deleteUserSubOrgRole(userOrgsMap, (IObjectPK)new ObjectUuidPK(this.getCurrentRoleInfo().getId()), permChangeId);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void verify() {
        if (this.getSelectedOrgInfo() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"orgIsNotSelected"));
            this.abort();
        }
    }

    private KDCommonPromptDialog getUserDialog() throws Exception {
        UserPromptBox dlg = null;
        IUIWindow win = this.getUIWindow();
        if (win instanceof Frame) {
            dlg = new UserPromptBox((Frame)this.getUIWindow());
        } else if (win instanceof Dialog) {
            dlg = new UserPromptBox((Dialog)this.getUIWindow());
        }
        dlg.setEnabledMultiSelection(true);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.UserListQuery");
        dlg.setQueryInfo(queryPK);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.getUserSQL((IObjectPK)new ObjectStringPK(this.currentEditRole.getId().toString()), (IObjectPK)new ObjectStringPK(this.getSelectedOrgPK())), CompareType.INNER));
        try {
            filterInfo.mergeFilter(Administrator.getNotAdminUserFilter(), "AND");
        }
        catch (BOSException e) {
            this.logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        if (this.isBizAdmin()) {
            FilterInfo bizAdminFilter = new FilterInfo();
            bizAdminFilter.getFilterItems().add(new FilterItemInfo("bizAdmin", (Object)Boolean.TRUE, CompareType.NOTEQUALS));
            bizAdminFilter.getFilterItems().add(new FilterItemInfo("CU.id in (" + RoleHelper.getManageOrgRangeSQL() + ")"));
            filterInfo.mergeFilter(bizAdminFilter, "AND");
        }
        entityViewInfo.setFilter(filterInfo);
        dlg.setEntityViewInfo(entityViewInfo);
        dlg.setHasCUDefaultFilter(false);
        return dlg;
    }

    private String getUserSQL(IObjectPK rolePK, IObjectPK orgPK) {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT DISTINCT OrgRange.FUserID FROM T_PM_OrgRange OrgRange ");
        sql.append(" INNER JOIN T_PM_User U ON U.FID = OrgRange.FUserID ").append(" WHERE U.FIsDelete = 0 ").append(" AND OrgRange.FOrgID = '").append(orgPK.toString()).append("' AND OrgRange.FType = 10 ").append(" AND OrgRange.FUserID NOT IN ( ").append(" SELECT UserRoleOrg.FUserID FROM T_PM_UserRoleOrg UserRoleOrg ").append(" WHERE UserRoleOrg.FRoleID = '").append(rolePK.toString()).append("' ").append(" AND UserRoleOrg.FOrgID = '").append(orgPK.toString()).append("' ").append(" ) ").append(" AND OrgRange.FUserID <> '").append(ToolUtils.getCurrentUserPK().toString()).append("' ");
        return sql.toString();
    }

    private String getLogAssignStr(UserRoleOrgCollection userRoleOrgs) {
        Locale locale = SysContext.getSysContext().getLocale();
        if (userRoleOrgs == null || userRoleOrgs.isEmpty()) {
            return "";
        }
        String logStr = "\n " + LogNamesHelper.getLogName("roleNumber4Log", locale) + ":" + this.currentEditRole.getNumber() + " \n " + LogNamesHelper.getLogName("orgNumber4Log", locale) + ":" + userRoleOrgs.get(0).getOrg().getNumber();
        List userNumberList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)userRoleOrgs, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                UserRoleOrgInfo userRoleOrgInfo = (UserRoleOrgInfo)obj;
                return userRoleOrgInfo.getUser().getNumber();
            }
        });
        String userStr = "\n " + LogNamesHelper.getLogName("userNumber4Log", locale) + " :(" + ToolUtils.aryToStr(userNumberList, false) + ")";
        String retStr = logStr + userStr;
        this.logger.info((Object)("logStr is:" + retStr));
        return retStr;
    }

    @Override
    public boolean isPrepareActionAssign() {
        return false;
    }

    @Override
    public RequestContext prepareActionAssign(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        Object data;
        this.verify();
        super.actionAssign_actionPerformed(e);
        KDCommonPromptDialog dlg = this.getUserDialog();
        dlg.show();
        if (!dlg.isCanceled() && (data = dlg.getData()) != null && data instanceof Object[]) {
            Object[] userInfos = (Object[])data;
            RoleInfo roleInfo = RoleFactory.getRemoteInstance().getRoleInfo((IObjectPK)new ObjectUuidPK(this.currentEditRole.getId()));
            UserRoleOrgCollection userRoleOrgs = new UserRoleOrgCollection();
            ArrayList<String> selectedOrgList = new ArrayList<String>();
            ArrayList<String> selectedRoleList = new ArrayList<String>();
            selectedOrgList.add(this.curSelectOrgId);
            selectedRoleList.add(roleInfo.getId().toString());
            PermissionHelper.alertRoleNeedAuthen((Component)((Object)this), selectedOrgList, selectedRoleList, null, null);
            ArrayList<ObjectUuidPK> userPKs = new ArrayList<ObjectUuidPK>();
            int length = userInfos.length;
            for (int i = 0; i < length; ++i) {
                userPKs.add(new ObjectUuidPK(((UserInfo)userInfos[i]).getId()));
            }
            if (userPKs != null && !userPKs.isEmpty()) {
                IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getRemoteInstance();
                LogProxy logProxy = new LogProxy();
                logProxy.beginLog(null, MyEntityInfo.getFacadeMethodAlias(null, iUserRoleOrgManager.getType(), "roleAssignUserOrgBatch"), new RoleInfo().getBOSType(), null, this.getLogAssignStr(userRoleOrgs));
                iUserRoleOrgManager.roleAssignUserOrgBatch(userPKs, roleInfo.getId().toString(), this.curSelectOrgId);
                logProxy.end();
                InheritFatherUserRoleUtil.addUserSubOrgRole(userInfos, (IObjectPK)new ObjectUuidPK(this.currentEditRole.getId()), (IObjectPK)new ObjectStringPK(this.curSelectOrgId));
                this.refresh(e);
            }
        }
    }

    private void checkForReturn(List noExsitsList) {
        if (this.getCurrentUser().isBizAdmin() && noExsitsList.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < noExsitsList.size(); ++i) {
                UserOrgRoPerm eachItem = (UserOrgRoPerm)noExsitsList.get(i);
                Object[] infoString = new String[]{eachItem.getOrgInfo().getName(), eachItem.getRoInfo().getName(), eachItem.getPmInfo().getName()};
                String promptInfo = MessageFormat.format(EASResource.getString((String)permissionResource, (String)"notSuccessRoleOrg"), infoString);
                sb.append(promptInfo);
                sb.append("\n");
            }
            MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"dialog.notExistsPerm"), (String)sb.toString());
        } else {
            UITools.showMsg((CoreUI)this, EASResource.getString((String)permissionResource, (String)"accreditPermSucceed"), false);
        }
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private void prepareActionAssignAfterConfirm(UserRoleOrgCollection userRoleOrgs) throws Exception {
        if (!this.isPrepareActionAssign()) {
            return;
        }
        IUIActionPostman handle = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("userRoleOrgs", (Object)userRoleOrgs);
        request.put("LogAssignStr", (Object)this.getLogAssignStr(userRoleOrgs));
        request.setMethodName("_handleActionAssignAfter");
        handle.setRequestContext((Serializable)request);
        handle.callHandler();
    }

    private UserRoleOrgCollection getSelectedUserRoleOrgCol() {
        UserRoleOrgCollection userRoleOrgs = new UserRoleOrgCollection();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                Object userIdObj = this.tblMain.getRow(j).getCell("id").getValue();
                Object roleIdObj = this.tblMain.getRow(j).getCell("roleId").getValue();
                Object orgIdObj = this.tblMain.getRow(j).getCell("orgId").getValue();
                Object userNumberObj = this.tblMain.getRow(j).getCell("number").getValue();
                Object orgNumberObj = this.tblMain.getRow(j).getCell("orgNumber").getValue();
                UserRoleOrgInfo userRoleOrgInfo = new UserRoleOrgInfo();
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)userIdObj.toString()));
                userInfo.setNumber(userNumberObj.toString());
                userRoleOrgInfo.setUser(userInfo);
                RoleInfo roleInfo = new RoleInfo();
                roleInfo.setId(BOSUuid.read((String)roleIdObj.toString()));
                userRoleOrgInfo.setRole(roleInfo);
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)orgIdObj.toString()));
                fullOrgUnitInfo.setNumber(orgNumberObj.toString());
                userRoleOrgInfo.setOrg(fullOrgUnitInfo);
                userRoleOrgs.add(userRoleOrgInfo);
            }
        }
        return userRoleOrgs;
    }

    @Override
    public boolean isPrepareActionQueryAllOrg() {
        return false;
    }

    @Override
    public RequestContext prepareActionQueryAllOrg(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    @Override
    public void actionQueryAllOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryAllOrg_actionPerformed(e);
        this.pmtOrg.setData(null);
        this.curSelectOrgId = null;
        this.curSelectOrgNumber = null;
        this.setMainQueryFilter(this.currentEditRole.getId().toString(), null);
        this.refreshList();
        this.btnAssign.setEnabled(false);
    }

    @Override
    protected void pmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtOrg_dataChanged(e);
        FullOrgUnitInfo fullOrgInfo = null;
        if (this.pmtOrg.getData() instanceof FullOrgUnitInfo) {
            fullOrgInfo = (FullOrgUnitInfo)this.pmtOrg.getData();
        }
        if (fullOrgInfo != null) {
            this.curSelectOrgId = fullOrgInfo.getId().toString();
            this.curSelectOrgNumber = fullOrgInfo.getNumber();
            this.btnAssign.setEnabled(true);
        }
        this.refreshRole();
    }

    private void refreshRole() throws Exception {
        this.setMainQueryFilter(this.currentEditRole.getId().toString(), this.curSelectOrgId);
        this.refreshList();
    }

    @Override
    protected void txtRole_dataChanged(DataChangeEvent e) throws Exception {
        super.txtRole_dataChanged(e);
        this.currentEditRole = (RoleInfo)this.txtRole.getData();
        if (this.currentEditRole != null) {
            this.refreshRole();
            this.initOrgF7();
        }
    }

    private RoleInfo getCurrentRoleInfo() {
        return (RoleInfo)this.txtRole.getData();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

