/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.DiscretePermCollection;
import com.kingdee.eas.base.permission.DiscretePermInfo;
import com.kingdee.eas.base.permission.DiscretePermissionFactory;
import com.kingdee.eas.base.permission.IDiscretePermission;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.client.AbstractRoleDiscretePermViewUI;
import com.kingdee.eas.base.permission.client.DiscreteAccreditManager;
import com.kingdee.eas.base.permission.client.IDiscreteAccreditProvider;
import com.kingdee.eas.base.permission.client.PermItemCheckBoxGroup;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RoleDiscretePermViewUI
extends AbstractRoleDiscretePermViewUI {
    public static final String BOS_OBJECT_TYPE = "bosObjectType";
    public static final String TARGET_ROLE_PK = "targetRolePK";
    private BOSObjectType bizObjectType = null;
    private QueryInfo bizQuery = null;
    private IObjectPK targetRolePK = null;
    private PermItemCheckBoxGroup checkBoxGroup = new PermItemCheckBoxGroup();
    private IDiscreteAccreditProvider discreteAccreditProvider = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadUIContext();
        this.initUI();
        this.setStatus();
    }

    private void setStatus() {
        this.checkBoxGroup.setAllEnable(false);
    }

    private void loadUIContext() {
        if (this.getUIContext().get(BOS_OBJECT_TYPE) == null) {
            throw new IllegalArgumentException("discreteAccreditContext can not be NULL.");
        }
        this.bizObjectType = (BOSObjectType)this.getUIContext().get(BOS_OBJECT_TYPE);
        this.discreteAccreditProvider = DiscreteAccreditManager.getInstace().getProvider(this.bizObjectType);
        this.bizQuery = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.discreteAccreditProvider.getQueryPK());
        this.targetRolePK = (IObjectPK)this.getUIContext().get(TARGET_ROLE_PK);
    }

    private void initUI() throws EASBizException, BOSException {
        this.initBizDataContainer();
        this.initPermItemPanel();
        this.initRoleF7();
    }

    private void initBizDataContainer() {
        this.initTable();
    }

    private void initPermItemPanel() throws EASBizException, BOSException {
        this.pnlPermItem.setLayout((LayoutManager)new FlowLayout(3));
        this.loadPermItems();
    }

    private void loadPermItems() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        Set permItemNames = (Set)iPermission.getConfigurationInfo().getDiscretEntityPermItems().get(this.bizObjectType.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet(permItemNames), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("enableDataPermission", (Object)new Integer(1)));
        entityViewInfo.setFilter(filterInfo);
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        PermItemCollection permItems = iPermItem.getPermItemCollection(entityViewInfo);
        HashSet<ObjectUuidPK> setPermItemPK = new HashSet<ObjectUuidPK>();
        int size = permItems.size();
        for (int i = 0; i < size; ++i) {
            PermItemInfo permItemInfo = permItems.get(i);
            KDCheckBox checkBox = new KDCheckBox(permItemInfo.getAlias());
            checkBox.setUserObject((Object)permItemInfo);
            this.checkBoxGroup.addCheckBox(permItemInfo.getId(), checkBox);
            this.pnlPermItem.add((Component)checkBox);
            setPermItemPK.add(new ObjectUuidPK(permItemInfo.getId()));
        }
        this.checkBoxGroup.setAllEnable(false);
    }

    private void initRoleF7() throws EASBizException, BOSException {
        IRole iRole = RoleFactory.getRemoteInstance();
        RoleInfo roleInfo = iRole.getRoleInfo(this.targetRolePK);
        this.pmtRole.setData((Object)roleInfo);
        this.pmtRole.setEnabled(false);
    }

    private void initTable() {
        this.contBizData.getContentPane().add((Component)this.table, "Center");
        this.table.getStyleAttributes().setLocked(true);
        this.table.getSelectManager().setSelectMode(2);
        this.table.getDataRequestManager().setDataRequestMode(1);
        this.table.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                RoleDiscretePermViewUI.this.requestRowSet(e);
            }
        });
        this.fillTableHeader();
    }

    private void fillTableHeader() {
        String IS_VISIBLE_FOR_KDTABLE = "isVisibleForKDTable";
        String COL_WIDTH_IN_KDTABLE = "ColWidthInKDTable";
        String DISPLAY_FORMAT = "displayFormat";
        String QUERY = "query";
        this.table.setRefresh(false);
        SelectorInfo selector = this.bizQuery.getSelector();
        int size = selector.getFields().size();
        QueryFieldInfo field = null;
        String[] bindContents = new String[size];
        Map exProperties = this.bizQuery.getExtendedProperties();
        for (int i = 0; i < size; ++i) {
            String colFormat;
            IColumn col = this.table.addColumn(i);
            field = (QueryFieldInfo)selector.getFields().get(i);
            exProperties = field.getExtendedProperties();
            bindContents[i] = field.getName();
            col.setKey(bindContents[i]);
            if (exProperties == null) continue;
            Object objectVisible = exProperties.get("isVisibleForKDTable");
            boolean visible = true;
            if (objectVisible instanceof Boolean) {
                visible = (Boolean)objectVisible;
            } else if (objectVisible instanceof String) {
                visible = objectVisible == null ? true : Boolean.valueOf((String)objectVisible);
            }
            col.getStyleAttributes().setHided(!visible);
            Object objectColWidth = exProperties.get("ColWidthInKDTable");
            int colWidth = 100;
            if (objectColWidth instanceof Integer) {
                colWidth = (Integer)objectColWidth;
            } else if (objectColWidth instanceof String) {
                colWidth = Integer.parseInt((String)objectColWidth);
            }
            col.setWidth(colWidth);
            Object objColFormat = exProperties.get("displayFormat");
            if (!(objColFormat instanceof String) || StringUtils.isEmpty((String)(colFormat = (String)objColFormat))) continue;
            col.getStyleAttributes().setNumberFormat(colFormat);
        }
        this.table.putBindContents("query", bindContents);
        this.table.checkParsed(true);
        IRow row = this.table.addHeadRow();
        for (int i = 0; i < size; ++i) {
            field = (QueryFieldInfo)selector.getFields().get(i);
            String displayName = field.getDisplayName();
            row.getCell(i).setValue((Object)displayName);
        }
        this.table.setRefresh(true);
    }

    private boolean needRequestData() {
        return this.pmtRole.getData() != null;
    }

    private void refreshUI() {
        boolean flag = this.targetRolePK != null;
        this.table.removeRows(flag);
        this.checkBoxGroup.setAllSelected(false);
        this.checkBoxGroup.setAllEnable(false);
    }

    private FilterInfo getBizDataFilter(BOSObjectType objectType, IObjectPK rolePK, boolean isAuthorized) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        ConfigurationInfo configurationInfo = iPermission.getConfigurationInfo();
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SELECT DISTINCT FBizDataID FROM ").append(configurationInfo.getDiscretEntityTables().get(objectType.toString())).append(" WHERE FRoleID = '").append(rolePK.toString()).append("' ");
        FilterInfo filterInfo = new FilterInfo();
        CompareType compareType = isAuthorized ? CompareType.INNER : CompareType.NOTINNER;
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), compareType));
        return filterInfo;
    }

    private IObjectPK getSelectedBizDataPK() {
        if (this.table.getSelectManager().size() != 0) {
            int rowIndex = this.table.getSelectManager().getActiveRowIndex();
            BOSUuid bizDataID = BOSUuid.read((String)this.table.getRow(rowIndex).getCell(this.getLogicPKField(this.bizQuery)).getValue().toString());
            return new ObjectUuidPK(bizDataID);
        }
        return null;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK) {
        IQueryExecutor queryExecutor = null;
        queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExecutor.option().isAutoTranslateEnum = true;
        queryExecutor.option().isAutoTranslateBoolean = true;
        queryExecutor.option().isAutoIgnoreZero = true;
        return queryExecutor;
    }

    private String getLogicPKField(QueryInfo queryInfo) {
        assert (this.bizQuery.getQueryPK().getKeyPropertys().size() == 1);
        QueryFieldInfo queryFieldInfo = this.bizQuery.getQueryPK().getKeyPropertys().get(0);
        return (String)queryFieldInfo.get("name");
    }

    private void requestRowSet(RequestRowSetEvent e) {
        if (this.needRequestData()) {
            try {
                int start = (Integer)e.getParam1();
                int length = (Integer)e.getParam2();
                MetaDataPK queryPK = new MetaDataPK(this.bizQuery.getFullName());
                IQueryExecutor queryExecutor = this.getQueryExecutor((IMetaDataPK)queryPK);
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = this.getBizDataFilter(this.bizObjectType, this.targetRolePK, true);
                entityViewInfo.setFilter(filterInfo);
                queryExecutor.setObjectView(entityViewInfo);
                IRowSet rowSet = queryExecutor.executeQuery(start, length);
                e.setRowSet(rowSet);
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    private DiscretePermCollection getDiscretePerms(IObjectPK bizDataPK) throws EASBizException, BOSException {
        IDiscretePermission iDiscretePermission = DiscretePermissionFactory.getRemoteInstance();
        DiscretePermCollection ddps = iDiscretePermission.getRoleDiscretePerms(this.bizObjectType, this.targetRolePK, this.getSelectedBizDataPK());
        return ddps;
    }

    @Override
    protected void table_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.table_activeCellChanged(e);
        this.checkBoxGroup.setAllSelected(false);
        if (e.getRowIndex() != -1) {
            DiscretePermCollection ddps = this.getDiscretePerms(this.getSelectedBizDataPK());
            int size = ddps.size();
            for (int i = 0; i < size; ++i) {
                DiscretePermInfo info = ddps.get(i);
                BOSUuid permItemID = info.getPermItem().getId();
                if (!this.checkBoxGroup.contains(permItemID)) continue;
                this.checkBoxGroup.setSingleSelected(permItemID, true);
            }
            this.checkBoxGroup.setAllEnable(true);
        } else {
            this.checkBoxGroup.setAllEnable(false);
        }
    }

    @Override
    protected void pmtRole_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtRole_dataChanged(e);
        this.refreshUI();
    }
}

